/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.io;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.HeapBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

final class TemporaryHeapBuffer
extends HeapBuffer {
    boolean isDisposed;

    TemporaryHeapBuffer() {
    }

    void reset(byte[] heap, int offset, int len) {
        this.heap = heap;
        this.offset = offset;
        this.cap = len;
        this.lim = len;
        this.pos = 0;
        this.byteBuffer = null;
        this.isDisposed = false;
    }

    Buffer cloneContent() {
        int length = this.remaining();
        Object buffer = MemoryManager.DEFAULT_MEMORY_MANAGER.allocate(length);
        buffer.allowBufferDispose(true);
        buffer.put(this.heap, this.offset + this.pos, length);
        buffer.flip();
        this.dispose();
        return buffer;
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
        super.dispose();
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemporaryHeapBuffer)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemporaryHeapBuffer that = (TemporaryHeapBuffer)o;
        return this.isDisposed == that.isDisposed;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isDisposed ? 1 : 0);
        return result;
    }

    public void recycle() {
        this.reset(null, 0, 0);
    }
}

