/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.glassfish.grizzly.http.util.Base64Utils;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.websockets.HandshakeException;

public class SecKey {
    private static final Random random = new SecureRandom();
    public static final int KEY_SIZE = 16;
    private final String secKey;
    private String nonce;
    private byte[] bytes;

    public SecKey() {
        this.secKey = this.create();
    }

    private String create() {
        this.bytes = new byte[16];
        random.nextBytes(this.bytes);
        return Base64Utils.encodeToString((byte[])this.bytes, (boolean)false);
    }

    SecKey(String base64) {
        if (base64 == null) {
            throw new HandshakeException("Null keys are not allowed.");
        }
        this.secKey = base64;
    }

    public static SecKey generateServerKey(SecKey clientKey) throws HandshakeException {
        String key = clientKey.getSecKey() + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        try {
            MessageDigest instance = MessageDigest.getInstance("SHA-1");
            instance.update(key.getBytes(Charsets.ASCII_CHARSET));
            byte[] digest = instance.digest();
            if (digest.length != 20) {
                throw new HandshakeException("Invalid key length.  Should be 20: " + digest.length);
            }
            return new SecKey(Base64Utils.encodeToString((byte[])digest, (boolean)false));
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandshakeException(e.getMessage());
        }
    }

    public String getSecKey() {
        return this.secKey;
    }

    public String toString() {
        return this.secKey;
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = Base64Utils.decode((String)this.secKey);
        }
        return this.bytes;
    }

    public String getNonce() {
        if (this.nonce == null) {
            this.nonce = this.create();
        }
        return this.nonce;
    }

    public void validateServerKey(String serverKey) {
        SecKey key = SecKey.generateServerKey(this);
        if (!key.getSecKey().equals(serverKey)) {
            throw new HandshakeException("Server key returned does not match expected response");
        }
    }
}

