/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.grizzly;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;

public final class IntrospectionUtils {
    private static final Logger LOGGER = Grizzly.logger(IntrospectionUtils.class);
    static Map<Class<?>, Method[]> objectMethods = new HashMap();
    static final int dbg = 0;

    public static boolean setProperty(Object o, String name, String value) {
        String setter = "set" + IntrospectionUtils.capitalize(name);
        try {
            int i;
            Method[] methods = IntrospectionUtils.findMethods(o.getClass());
            Method setPropertyMethodVoid = null;
            Method setPropertyMethodBool = null;
            for (i = 0; i < methods.length; ++i) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (!setter.equals(methods[i].getName()) || paramT.length != 1 || !"java.lang.String".equals(paramT[0].getName())) continue;
                methods[i].invoke(o, value);
                return true;
            }
            for (i = 0; i < methods.length; ++i) {
                boolean ok = true;
                if (setter.equals(methods[i].getName()) && methods[i].getParameterTypes().length == 1) {
                    Class<?> paramType = methods[i].getParameterTypes()[0];
                    Object[] params = new Object[1];
                    if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                        try {
                            params[0] = new Integer(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Long".equals(paramType.getName()) || "long".equals(paramType.getName())) {
                        try {
                            params[0] = new Long(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                        params[0] = Boolean.valueOf(value);
                    } else if ("java.net.InetAddress".equals(paramType.getName())) {
                        try {
                            params[0] = InetAddress.getByName(value);
                        }
                        catch (UnknownHostException exc) {
                            IntrospectionUtils.d("Unable to resolve host name:" + value);
                            ok = false;
                        }
                    } else {
                        IntrospectionUtils.d("Unknown type " + paramType.getName());
                    }
                    if (ok) {
                        methods[i].invoke(o, params);
                        return true;
                    }
                }
                if (!"setProperty".equals(methods[i].getName())) continue;
                if (methods[i].getReturnType() == Boolean.TYPE) {
                    setPropertyMethodBool = methods[i];
                    continue;
                }
                setPropertyMethodVoid = methods[i];
            }
            if (setPropertyMethodBool != null || setPropertyMethodVoid != null) {
                Object[] params = new Object[]{name, value};
                if (setPropertyMethodBool != null) {
                    try {
                        return (Boolean)setPropertyMethodBool.invoke(o, params);
                    }
                    catch (IllegalArgumentException biae) {
                        if (setPropertyMethodVoid != null) {
                            setPropertyMethodVoid.invoke(o, params);
                            return true;
                        }
                        throw biae;
                    }
                }
                setPropertyMethodVoid.invoke(o, params);
                return true;
            }
        }
        catch (IllegalArgumentException ex2) {
            LOGGER.log(Level.INFO, "IAE " + o + " " + name + " " + value, ex2);
        }
        catch (SecurityException ex1) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ie) {
            // empty catch block
        }
        return false;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static void clear() {
        objectMethods.clear();
    }

    public static Method[] findMethods(Class<?> c) {
        Method[] methods = objectMethods.get(c);
        if (methods != null) {
            return methods;
        }
        methods = c.getMethods();
        objectMethods.put(c, methods);
        return methods;
    }

    static void d(String s) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "IntrospectionUtils: {0}", s);
        }
    }
}

