/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.jmx;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.server.HttpServerProbe;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.monitoring.jmx.GrizzlyJmxManager;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;

@ManagedObject
@Description(value="The HttpServerFilter is the entity responsible for providing and processing higher level abstractions based on HTTP protocol.")
public class HttpServerFilter
extends JmxObject {
    private final org.glassfish.grizzly.http.server.HttpServerFilter httpServerFilter;
    private final AtomicLong receivedCount = new AtomicLong();
    private final AtomicLong completedCount = new AtomicLong();
    private final AtomicInteger suspendCount = new AtomicInteger();
    private final AtomicLong timedOutCount = new AtomicLong();
    private final AtomicLong cancelledCount = new AtomicLong();
    private final HttpServerProbe probe = new JmxWebServerProbe();

    public HttpServerFilter(org.glassfish.grizzly.http.server.HttpServerFilter httpServerFilter) {
        this.httpServerFilter = httpServerFilter;
    }

    @Override
    public String getJmxName() {
        return "HttpServerFilter";
    }

    @Override
    protected void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        this.httpServerFilter.getMonitoringConfig().addProbes(this.probe);
    }

    @Override
    protected void onDeregister(GrizzlyJmxManager mom) {
        this.httpServerFilter.getMonitoringConfig().removeProbes(this.probe);
    }

    @ManagedAttribute(id="requests-received-count")
    @Description(value="The total number of requests received.")
    public long getRequestsReceivedCount() {
        return this.receivedCount.get();
    }

    @ManagedAttribute(id="requests-completed-count")
    @Description(value="The total number of requests that have been successfully completed.")
    public long getRequestsCompletedCount() {
        return this.completedCount.get();
    }

    @ManagedAttribute(id="current-suspended-request-count")
    @Description(value="The current number of requests that are suspended to be processed at a later point in time.")
    public int getRequestsSuspendedCount() {
        return this.suspendCount.get();
    }

    @ManagedAttribute(id="requests-timed-out-count")
    @Description(value="The total number of suspended requests that have been timed out.")
    public long getRequestsTimedOutCount() {
        return this.timedOutCount.get();
    }

    @ManagedAttribute(id="requests-cancelled-count")
    @Description(value="The total number of suspended requests that have been cancelled.")
    public long getRequestsCancelledCount() {
        return this.cancelledCount.get();
    }

    private final class JmxWebServerProbe
    extends HttpServerProbe.Adapter {
        private JmxWebServerProbe() {
        }

        @Override
        public void onRequestReceiveEvent(org.glassfish.grizzly.http.server.HttpServerFilter filter, Connection connection, Request request) {
            HttpServerFilter.this.receivedCount.incrementAndGet();
        }

        @Override
        public void onRequestCompleteEvent(org.glassfish.grizzly.http.server.HttpServerFilter filter, Connection connection, Response response) {
            HttpServerFilter.this.completedCount.incrementAndGet();
        }

        @Override
        public void onRequestSuspendEvent(org.glassfish.grizzly.http.server.HttpServerFilter filter, Connection connection, Request request) {
            HttpServerFilter.this.suspendCount.incrementAndGet();
        }

        @Override
        public void onRequestResumeEvent(org.glassfish.grizzly.http.server.HttpServerFilter filter, Connection connection, Request request) {
            if (HttpServerFilter.this.suspendCount.get() > 0) {
                HttpServerFilter.this.suspendCount.decrementAndGet();
            }
        }

        @Override
        public void onRequestTimeoutEvent(org.glassfish.grizzly.http.server.HttpServerFilter filter, Connection connection, Request request) {
            HttpServerFilter.this.timedOutCount.incrementAndGet();
            if (HttpServerFilter.this.suspendCount.get() > 0) {
                HttpServerFilter.this.suspendCount.decrementAndGet();
            }
        }

        @Override
        public void onRequestCancelEvent(org.glassfish.grizzly.http.server.HttpServerFilter filter, Connection connection, Request request) {
            HttpServerFilter.this.cancelledCount.incrementAndGet();
            if (HttpServerFilter.this.suspendCount.get() > 0) {
                HttpServerFilter.this.suspendCount.decrementAndGet();
            }
        }
    }
}

