/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.server.CompressionLevel;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;

public class CompressionEncodingFilter
implements EncodingFilter {
    private final CompressionLevel compressionLevel;
    private final int compressionMinSize;
    private final String[] compressableMimeTypes;
    private final String[] noCompressionUserAgents;
    private final String[] aliases;

    public CompressionEncodingFilter(CompressionLevel compressionLevel, int compressionMinSize, String[] compressableMimeTypes, String[] noCompressionUserAgents, String[] aliases) {
        this.compressionLevel = compressionLevel;
        this.compressionMinSize = compressionMinSize;
        this.compressableMimeTypes = compressableMimeTypes;
        this.noCompressionUserAgents = noCompressionUserAgents;
        this.aliases = aliases;
    }

    @Override
    public boolean applyEncoding(HttpHeader httpPacket) {
        DataChunk userAgentValueDC;
        switch (this.compressionLevel) {
            case OFF: {
                return false;
            }
        }
        if (Protocol.HTTP_1_1 != httpPacket.getProtocol()) {
            return false;
        }
        if (!httpPacket.getContentEncodings().isEmpty()) {
            return false;
        }
        HttpResponsePacket responsePacket = (HttpResponsePacket)httpPacket;
        MimeHeaders responseHeaders = responsePacket.getHeaders();
        DataChunk contentEncodingMB = responseHeaders.getValue(Header.ContentEncoding);
        if (contentEncodingMB != null && !contentEncodingMB.isNull()) {
            return false;
        }
        MimeHeaders requestHeaders = responsePacket.getRequest().getHeaders();
        if (!this.userAgentRequestsCompression(requestHeaders)) {
            return false;
        }
        if (this.compressionLevel == CompressionLevel.FORCE) {
            responsePacket.setChunked(true);
            responsePacket.setContentLength(-1);
            return true;
        }
        if (this.noCompressionUserAgents.length > 0 && (userAgentValueDC = requestHeaders.getValue(Header.UserAgent)) != null && CompressionEncodingFilter.indexOf(this.noCompressionUserAgents, userAgentValueDC) != -1) {
            return false;
        }
        long contentLength = responsePacket.getContentLength();
        if (contentLength == -1L || contentLength >= (long)this.compressionMinSize) {
            boolean found = true;
            if (this.compressableMimeTypes.length > 0) {
                boolean bl = found = CompressionEncodingFilter.indexOfStartsWith(this.compressableMimeTypes, responsePacket.getContentType()) != -1;
            }
            if (found) {
                responsePacket.setChunked(true);
                responsePacket.setContentLength(-1);
                return true;
            }
        }
        return false;
    }

    private boolean userAgentRequestsCompression(MimeHeaders requestHeaders) {
        DataChunk acceptEncodingDC = requestHeaders.getValue(Header.AcceptEncoding);
        if (acceptEncodingDC == null) {
            return false;
        }
        String alias = null;
        int idx = -1;
        int len = this.aliases.length;
        for (int i = 0; i < len && (idx = acceptEncodingDC.indexOf(alias = this.aliases[i], 0)) == -1; ++i) {
        }
        if (idx == -1) {
            return false;
        }
        assert (alias != null);
        int qvalueStart = acceptEncodingDC.indexOf(';', idx + alias.length());
        if (qvalueStart != -1) {
            int qvalueEnd;
            int commaIdx = acceptEncodingDC.indexOf(',', qvalueStart = acceptEncodingDC.indexOf('=', qvalueStart));
            int n = qvalueEnd = commaIdx != -1 ? commaIdx : acceptEncodingDC.getLength();
            if (HttpUtils.convertQValueToFloat(acceptEncodingDC, qvalueStart + 1, qvalueEnd) == 0.0f) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean applyDecoding(HttpHeader httpPacket) {
        return false;
    }

    private static int indexOf(String[] aliases, DataChunk dc) {
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (dc.indexOf(alias, 0) == -1) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfStartsWith(String[] aliases, String s) {
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (!s.startsWith(alias)) continue;
            return i;
        }
        return -1;
    }
}

