/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.http.MimeHeadersPacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.utils.Charsets;

public abstract class HttpHeader
extends HttpPacket
implements MimeHeadersPacket,
AttributeStorage {
    private static final byte[] CHUNKED_ENCODING_BYTES = "chunked".getBytes(Charsets.ASCII_CHARSET);
    protected boolean isCommitted;
    protected MimeHeaders headers;
    protected final DataChunk protocolC = DataChunk.newInstance();
    protected Protocol parsedProtocol;
    protected boolean isChunked;
    private final byte[] tmpContentLengthBuffer = new byte[20];
    private final byte[] tmpHeaderEncodingBuffer = new byte[512];
    protected long contentLength = -1L;
    protected String characterEncoding;
    protected String quotedCharsetValue;
    protected boolean charsetSet = false;
    protected String contentType;
    protected boolean isExpectContent = true;
    protected boolean isSkipRemainder;
    protected boolean isContentBroken;
    protected boolean secure;
    protected final DataChunk upgrade = DataChunk.newInstance();
    private TransferEncoding transferEncoding;
    private final List<ContentEncoding> contentEncodings = new ArrayList<ContentEncoding>(2);
    private boolean isContentEncodingsSelected;
    private final AttributeHolder attributes = new IndexedAttributeHolder(Grizzly.DEFAULT_ATTRIBUTE_BUILDER);
    private AttributeHolder activeAttributes;
    Buffer headerBuffer;
    private boolean chunkingAllowed;

    public HttpHeader() {
        this(new MimeHeaders());
    }

    protected HttpHeader(MimeHeaders headers) {
        this.headers = headers;
    }

    void setHeaderBuffer(Buffer headerBuffer) {
        this.headerBuffer = headerBuffer;
    }

    @Override
    public AttributeHolder getAttributes() {
        if (this.activeAttributes == null) {
            this.activeAttributes = this.attributes;
        }
        return this.activeAttributes;
    }

    public abstract boolean isRequest();

    @Override
    public final boolean isHeader() {
        return true;
    }

    @Override
    public HttpHeader getHttpHeader() {
        return this;
    }

    public abstract ProcessingState getProcessingState();

    protected void addContentEncoding(ContentEncoding contentEncoding) {
        this.contentEncodings.add(contentEncoding);
    }

    protected List<ContentEncoding> getContentEncodings(boolean isModifiable) {
        if (isModifiable) {
            return this.contentEncodings;
        }
        return Collections.unmodifiableList(this.contentEncodings);
    }

    public List<ContentEncoding> getContentEncodings() {
        return this.getContentEncodings(false);
    }

    protected final boolean isContentEncodingsSelected() {
        return this.isContentEncodingsSelected;
    }

    protected final void setContentEncodingsSelected(boolean isContentEncodingsSelected) {
        this.isContentEncodingsSelected = isContentEncodingsSelected;
    }

    public TransferEncoding getTransferEncoding() {
        return this.transferEncoding;
    }

    protected void setTransferEncoding(TransferEncoding transferEncoding) {
        this.transferEncoding = transferEncoding;
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public void setChunked(boolean isChunked) {
        this.isChunked = isChunked;
    }

    public boolean isExpectContent() {
        return this.isExpectContent;
    }

    public void setExpectContent(boolean isExpectContent) {
        this.isExpectContent = isExpectContent;
    }

    public boolean isSkipRemainder() {
        return this.isSkipRemainder;
    }

    public void setSkipRemainder(boolean isSkipRemainder) {
        this.isSkipRemainder = isSkipRemainder;
    }

    public boolean isContentBroken() {
        return this.isContentBroken;
    }

    public void setContentBroken(boolean isBroken) {
        this.isContentBroken = isBroken;
    }

    public String getUpgrade() {
        return this.upgrade.toString();
    }

    public DataChunk getUpgradeDC() {
        return this.upgrade;
    }

    public void setUpgrade(String upgrade) {
        this.upgrade.setString(upgrade);
    }

    protected void makeUpgradeHeader() {
        if (!this.upgrade.isNull()) {
            this.headers.setValue(Header.Upgrade).set(this.upgrade);
        }
    }

    protected void makeContentLengthHeader(long defaultLength) {
        if (this.contentLength != -1L) {
            int start = HttpUtils.longToBuffer(this.contentLength, this.tmpContentLengthBuffer);
            this.headers.setValue(Header.ContentLength).setBytes(this.tmpContentLengthBuffer, start, this.tmpContentLengthBuffer.length);
        } else if (defaultLength != -1L) {
            int start = HttpUtils.longToBuffer(defaultLength, this.tmpContentLengthBuffer);
            int idx = this.headers.indexOf(Header.ContentLength, 0);
            if (idx == -1) {
                this.headers.addValue(Header.ContentLength).setBytes(this.tmpContentLengthBuffer, start, this.tmpContentLengthBuffer.length);
            } else if (this.headers.getValue(idx).isNull()) {
                this.headers.getValue(idx).setBytes(this.tmpContentLengthBuffer, start, this.tmpContentLengthBuffer.length);
            }
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
        if (len < 0) {
            this.headers.removeHeader(Header.ContentLength);
        }
    }

    public void setContentLengthLong(long contentLength) {
        this.contentLength = contentLength;
        if (contentLength < 0L) {
            this.headers.removeHeader(Header.ContentLength);
        }
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void setCommitted(boolean isCommitted) {
        this.isCommitted = isCommitted;
    }

    protected void makeTransferEncodingHeader(String defaultValue) {
        int idx = this.headers.indexOf(Header.TransferEncoding, 0);
        if (idx == -1) {
            this.headers.addValue(Header.TransferEncoding).setBytes(CHUNKED_ENCODING_BYTES);
        }
    }

    protected void extractContentEncoding(DataChunk value) {
        int idx = this.headers.indexOf(Header.ContentEncoding, 0);
        if (idx != -1) {
            this.headers.setSerialized(idx, true);
            value.set(this.headers.getValue(idx));
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String charset) {
        if (this.isCommitted()) {
            return;
        }
        if (charset == null) {
            this.characterEncoding = null;
            this.quotedCharsetValue = null;
            this.charsetSet = false;
            return;
        }
        this.characterEncoding = charset;
        this.quotedCharsetValue = charset;
        this.charsetSet = true;
    }

    public boolean isChunkingAllowed() {
        return this.chunkingAllowed;
    }

    public void setChunkingAllowed(boolean chunkingAllowed) {
        this.chunkingAllowed = chunkingAllowed;
    }

    public boolean isContentTypeSet() {
        return this.contentType != null || this.characterEncoding != null || this.headers.getValue(Header.ContentType) != null;
    }

    public String getContentType() {
        String ret = this.contentType;
        if (ret != null && this.quotedCharsetValue != null && this.charsetSet) {
            StringBuilder sb = new StringBuilder(ret.length() + this.quotedCharsetValue.length() + 9);
            ret = sb.append(ret).append(";charset=").append(this.quotedCharsetValue).toString();
        }
        return ret;
    }

    public void setContentType(String type) {
        String charsetValue;
        if (type == null) {
            this.contentType = null;
            return;
        }
        boolean hasCharset = false;
        int semicolonIndex = -1;
        int index = type.indexOf(59);
        while (index != -1) {
            int len = type.length();
            semicolonIndex = index++;
            while (index < len && type.charAt(index) == ' ') {
                ++index;
            }
            if (index + 8 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                hasCharset = true;
                break;
            }
            index = type.indexOf(59, index);
        }
        if (!hasCharset) {
            this.contentType = type;
            return;
        }
        this.contentType = type.substring(0, semicolonIndex);
        String tail = type.substring(index + 8);
        int nextParam = tail.indexOf(59);
        if (nextParam != -1) {
            this.contentType = this.contentType + tail.substring(nextParam);
            charsetValue = tail.substring(0, nextParam);
        } else {
            charsetValue = tail;
        }
        if (charsetValue != null && charsetValue.length() > 0) {
            this.charsetSet = true;
            this.quotedCharsetValue = charsetValue;
            this.characterEncoding = charsetValue.replace('\"', ' ').trim();
        }
    }

    @Override
    public MimeHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        if (name == null) {
            return null;
        }
        String result = this.handleGetSpecialHeader(name);
        return result != null ? result : this.headers.getHeader(name);
    }

    @Override
    public String getHeader(Header header) {
        if (header == null) {
            return null;
        }
        String result = this.handleGetSpecialHeader(header);
        return result != null ? result : this.headers.getHeader(header);
    }

    @Override
    public void setHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if (this.handleSetSpecialHeaders(name, value)) {
            return;
        }
        this.headers.setValue(name).setString(value);
    }

    @Override
    public void setHeader(Header header, String value) {
        if (header == null || value == null) {
            return;
        }
        String name = header.toString();
        if (this.handleSetSpecialHeaders(name, value)) {
            return;
        }
        this.headers.setValue(header).setString(value);
    }

    @Override
    public void addHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if (this.handleSetSpecialHeaders(name, value)) {
            return;
        }
        this.headers.addValue(name).setString(value);
    }

    @Override
    public void addHeader(Header header, String value) {
        if (header == null || value == null) {
            return;
        }
        if (this.handleSetSpecialHeaders(header, value)) {
            return;
        }
        this.headers.addValue(header).setString(value);
    }

    @Override
    public boolean containsHeader(String name) {
        if (name == null) {
            return false;
        }
        String result = this.handleGetSpecialHeader(name);
        return result != null || this.headers.getHeader(name) != null;
    }

    @Override
    public boolean containsHeader(Header header) {
        if (header == null) {
            return false;
        }
        String result = this.handleGetSpecialHeader(header);
        return result != null || this.headers.getHeader(header) != null;
    }

    public DataChunk getProtocolDC() {
        this.parsedProtocol = null;
        return this.protocolC;
    }

    public String getProtocolString() {
        if (this.parsedProtocol == null) {
            return this.getProtocolDC().toString();
        }
        return this.parsedProtocol.getProtocolString();
    }

    public Protocol getProtocol() {
        if (this.parsedProtocol != null) {
            return this.parsedProtocol;
        }
        this.parsedProtocol = Protocol.valueOf(this.protocolC);
        return this.parsedProtocol;
    }

    public void setProtocol(Protocol protocol) {
        this.parsedProtocol = protocol;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public final HttpContent.Builder httpContentBuilder() {
        return HttpContent.builder(this);
    }

    public HttpTrailer.Builder httpTrailerBuilder() {
        return HttpTrailer.builder(this);
    }

    protected void reset() {
        this.isContentEncodingsSelected = false;
        this.secure = false;
        this.isSkipRemainder = false;
        this.isContentBroken = false;
        if (this.activeAttributes != null) {
            this.activeAttributes.recycle();
            this.activeAttributes = null;
        }
        this.protocolC.recycle();
        this.parsedProtocol = null;
        this.contentEncodings.clear();
        this.headers.clear();
        this.isCommitted = false;
        this.isChunked = false;
        this.contentLength = -1L;
        this.characterEncoding = null;
        this.quotedCharsetValue = null;
        this.charsetSet = false;
        this.contentType = null;
        this.chunkingAllowed = false;
        this.transferEncoding = null;
        this.isExpectContent = true;
        this.upgrade.recycle();
        if (this.headerBuffer != null) {
            this.headerBuffer.dispose();
            this.headerBuffer = null;
        }
    }

    @Override
    public void recycle() {
        this.reset();
    }

    protected final String handleGetSpecialHeader(String name) {
        return HttpHeader.isSpecialHeader(name) ? this.getValueBasedOnHeader(name) : null;
    }

    protected final String handleGetSpecialHeader(Header header) {
        return HttpHeader.isSpecialHeader(header.toString()) ? this.getValueBasedOnHeader(header) : null;
    }

    protected final boolean handleSetSpecialHeaders(String name, String value) {
        return HttpHeader.isSpecialHeader(name) && this.setValueBasedOnHeader(name, value);
    }

    protected final boolean handleSetSpecialHeaders(Header header, String value) {
        return HttpHeader.isSpecialHeader(header.toString()) && this.setValueBasedOnHeader(header, value);
    }

    protected static boolean isSpecialHeader(String name) {
        char c = name.charAt(0);
        return c == 'C' || c == 'c' || c == 'U' || c == 'u';
    }

    public byte[] getTempHeaderEncodingBuffer() {
        return this.tmpHeaderEncodingBuffer;
    }

    private String getValueBasedOnHeader(Header header) {
        if (Header.ContentType.equals((Object)header)) {
            String value = this.getContentType();
            if (value != null) {
                return value;
            }
        } else if (Header.ContentLength.equals((Object)header)) {
            long value = this.getContentLength();
            if (value >= 0L) {
                return Long.toString(value);
            }
        } else if (Header.Upgrade.equals((Object)header)) {
            return this.getUpgrade();
        }
        return null;
    }

    private String getValueBasedOnHeader(String name) {
        if (Header.ContentType.toString().equalsIgnoreCase(name)) {
            String value = this.getContentType();
            if (value != null) {
                return value;
            }
        } else if (Header.ContentLength.toString().equalsIgnoreCase(name)) {
            long value = this.getContentLength();
            if (value >= 0L) {
                return Long.toString(value);
            }
        } else if (Header.Upgrade.toString().equalsIgnoreCase(name)) {
            return this.getUpgrade();
        }
        return null;
    }

    private boolean setValueBasedOnHeader(String name, String value) {
        if (Header.ContentType.toString().equalsIgnoreCase(name)) {
            this.setContentType(value);
            return true;
        }
        if (Header.ContentLength.toString().equalsIgnoreCase(name)) {
            try {
                long cLL = Long.parseLong(value);
                this.setContentLengthLong(cLL);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (Header.Upgrade.toString().equalsIgnoreCase(name)) {
            this.setUpgrade(value);
        }
        return false;
    }

    private boolean setValueBasedOnHeader(Header header, String value) {
        if (Header.ContentType.equals((Object)header)) {
            this.setContentType(value);
            return true;
        }
        if (Header.ContentLength.equals((Object)header)) {
            try {
                long cLL = Long.parseLong(value);
                this.setContentLengthLong(cLL);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (Header.Upgrade.equals((Object)header)) {
            this.setUpgrade(value);
        }
        return false;
    }

    protected void flushSpecialHeaders() {
        String ct;
        if (this.contentLength >= 0L) {
            this.headers.setValue(Header.ContentLength).setString(String.valueOf(this.contentLength));
        }
        if ((ct = this.getContentType()) != null) {
            this.headers.setValue(Header.ContentType).setString(String.valueOf(ct));
        }
        if (!this.upgrade.isNull()) {
            this.headers.setValue(Header.Upgrade).setString(this.upgrade.toString());
        }
    }

    public static abstract class Builder<T extends Builder> {
        protected HttpHeader packet;

        public final T protocol(Protocol protocol) {
            this.packet.setProtocol(protocol);
            return (T)this;
        }

        public final T protocol(String protocol) {
            this.packet.getProtocolDC().setString(protocol);
            return (T)this;
        }

        public final T chunked(boolean isChunked) {
            this.packet.setChunked(isChunked);
            return (T)this;
        }

        public final T contentLength(long contentLength) {
            this.packet.setContentLengthLong(contentLength);
            return (T)this;
        }

        public final T contentType(String contentType) {
            this.packet.setContentType(contentType);
            return (T)this;
        }

        public final T upgrade(String upgrade) {
            this.packet.setUpgrade(upgrade);
            return (T)this;
        }

        public final T header(String name, String value) {
            this.packet.addHeader(name, value);
            return (T)this;
        }

        public final T header(Header header, String value) {
            this.packet.addHeader(header, value);
            return (T)this;
        }

        public final T maxNumHeaders(int num) {
            this.packet.getHeaders().setMaxNumHeaders(num);
            return (T)this;
        }
    }
}

