/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.ssl;

import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.config.ssl.JSSEImplementation;
import org.glassfish.grizzly.config.ssl.ServerSocketFactory;
import org.glassfish.grizzly.ssl.SSLSupport;

public abstract class SSLImplementation {
    private static final Logger logger = Logger.getLogger(SSLImplementation.class.getName());
    private static final String JSSEImplementationClass = JSSEImplementation.class.getName();
    private static final String[] implementations = new String[]{JSSEImplementationClass};

    public static SSLImplementation getInstance() throws ClassNotFoundException {
        for (String implementation : implementations) {
            try {
                return SSLImplementation.getInstance(implementation);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Error creating " + implementation, e);
            }
        }
        throw new ClassNotFoundException("Can't find any SSL implementation");
    }

    public static SSLImplementation getInstance(String className) throws ClassNotFoundException {
        if (className == null) {
            return SSLImplementation.getInstance();
        }
        try {
            return (SSLImplementation)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Error loading SSL Implementation " + className, e);
            }
            throw new ClassNotFoundException("Error loading SSL Implementation " + className + " :" + e.toString());
        }
    }

    public abstract String getImplementationName();

    public abstract ServerSocketFactory getServerSocketFactory();

    public abstract SSLSupport getSSLSupport(Socket var1);

    public abstract SSLSupport getSSLSupport(SSLEngine var1);
}

