/*
 * Decompiled with CFR 0.152.
 */
package tools.tzdb;

import tools.tzdb.LocalDate;

class Utils {
    public static final int YEAR_MIN_VALUE = -999999999;
    public static final int YEAR_MAX_VALUE = 999999999;

    Utils() {
    }

    public static long floorDiv(long l, long l2) {
        long l3 = l / l2;
        if ((l ^ l2) < 0L && l3 * l2 != l) {
            --l3;
        }
        return l3;
    }

    public static long floorMod(long l, long l2) {
        return l - Utils.floorDiv(l, l2) * l2;
    }

    public static long addExact(long l, long l2) {
        long l3 = l + l2;
        if (((l ^ l3) & (l2 ^ l3)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return l3;
    }

    public static boolean isLeapYear(int n) {
        return (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static int lengthOfMonth(int n, boolean bl) {
        switch (n) {
            case 2: {
                return bl ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static int maxLengthOfMonth(int n) {
        switch (n) {
            case 2: {
                return 29;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static int plusDayOfWeek(int n, long l) {
        int n2 = (int)(l % 7L);
        return (n - 1 + (n2 + 7)) % 7 + 1;
    }

    public static int minusDayOfWeek(int n, long l) {
        return Utils.plusDayOfWeek(n, -(l % 7L));
    }

    public static LocalDate previousOrSame(LocalDate localDate, int n) {
        return Utils.adjust(localDate, n, 1);
    }

    public static LocalDate nextOrSame(LocalDate localDate, int n) {
        return Utils.adjust(localDate, n, 0);
    }

    private static final LocalDate adjust(LocalDate localDate, int n, int n2) {
        int n3 = localDate.getDayOfWeek();
        if (n2 < 2 && n3 == n) {
            return localDate;
        }
        if ((n2 & 1) == 0) {
            int n4 = n3 - n;
            return localDate.plusDays(n4 >= 0 ? (long)(7 - n4) : (long)(-n4));
        }
        int n5 = n - n3;
        return localDate.minusDays(n5 >= 0 ? (long)(7 - n5) : (long)(-n5));
    }
}

