/*
 * Decompiled with CFR 0.152.
 */
package tools.tzdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import tools.tzdb.LocalDate;
import tools.tzdb.LocalDateTime;
import tools.tzdb.LocalTime;
import tools.tzdb.TimeDefinition;
import tools.tzdb.Utils;
import tools.tzdb.ZoneOffset;
import tools.tzdb.ZoneOffsetTransition;
import tools.tzdb.ZoneOffsetTransitionRule;
import tools.tzdb.ZoneRules;

public class ZoneRulesBuilder {
    private List<TZWindow> windowList = new ArrayList<TZWindow>();

    public ZoneRulesBuilder addWindow(ZoneOffset zoneOffset, LocalDateTime localDateTime, TimeDefinition timeDefinition) {
        Objects.requireNonNull(zoneOffset, "standardOffset");
        Objects.requireNonNull(localDateTime, "until");
        Objects.requireNonNull(timeDefinition, "untilDefinition");
        TZWindow tZWindow = new TZWindow(zoneOffset, localDateTime, timeDefinition);
        if (this.windowList.size() > 0) {
            TZWindow tZWindow2 = this.windowList.get(this.windowList.size() - 1);
            tZWindow.validateWindowOrder(tZWindow2);
        }
        this.windowList.add(tZWindow);
        return this;
    }

    public ZoneRulesBuilder addWindowForever(ZoneOffset zoneOffset) {
        return this.addWindow(zoneOffset, LocalDateTime.MAX, TimeDefinition.WALL);
    }

    public ZoneRulesBuilder setFixedSavingsToWindow(int n) {
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("Must add a window before setting the fixed savings");
        }
        TZWindow tZWindow = this.windowList.get(this.windowList.size() - 1);
        tZWindow.setFixedSavings(n);
        return this;
    }

    public ZoneRulesBuilder addRuleToWindow(LocalDateTime localDateTime, TimeDefinition timeDefinition, int n) {
        Objects.requireNonNull(localDateTime, "transitionDateTime");
        return this.addRuleToWindow(localDateTime.getYear(), localDateTime.getYear(), localDateTime.getMonth(), localDateTime.getDayOfMonth(), -1, localDateTime.getTime(), false, timeDefinition, n);
    }

    public ZoneRulesBuilder addRuleToWindow(int n, int n2, int n3, LocalTime localTime, boolean bl, TimeDefinition timeDefinition, int n4) {
        return this.addRuleToWindow(n, n, n2, n3, -1, localTime, bl, timeDefinition, n4);
    }

    public ZoneRulesBuilder addRuleToWindow(int n, int n2, int n3, int n4, int n5, LocalTime localTime, boolean bl, TimeDefinition timeDefinition, int n6) {
        Objects.requireNonNull(localTime, "time");
        Objects.requireNonNull(timeDefinition, "timeDefinition");
        if (n4 < -28 || n4 > 31 || n4 == 0) {
            throw new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
        }
        if (bl && !localTime.equals(LocalTime.MIDNIGHT)) {
            throw new IllegalArgumentException("Time must be midnight when end of day flag is true");
        }
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("Must add a window before adding a rule");
        }
        TZWindow tZWindow = this.windowList.get(this.windowList.size() - 1);
        tZWindow.addRule(n, n2, n3, n4, n5, localTime, bl, timeDefinition, n6);
        return this;
    }

    public ZoneRules toRules(String string) {
        Objects.requireNonNull(string, "zoneId");
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("No windows have been added to the builder");
        }
        ArrayList<ZoneOffsetTransition> arrayList = new ArrayList<ZoneOffsetTransition>(4);
        ArrayList<ZoneOffsetTransition> arrayList2 = new ArrayList<ZoneOffsetTransition>(256);
        ArrayList<ZoneOffsetTransitionRule> arrayList3 = new ArrayList<ZoneOffsetTransitionRule>(2);
        TZWindow tZWindow = this.windowList.get(0);
        ZoneOffset zoneOffset = tZWindow.standardOffset;
        int n = 0;
        if (tZWindow.fixedSavingAmountSecs != null) {
            n = tZWindow.fixedSavingAmountSecs;
        }
        ZoneOffset zoneOffset2 = ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n);
        LocalDateTime localDateTime = LocalDateTime.of(-999999999, 1, 1, 0, 0);
        ZoneOffset zoneOffset3 = zoneOffset2;
        for (TZWindow tZWindow2 : this.windowList) {
            Iterator iterator;
            Object object;
            tZWindow2.tidy(localDateTime.getYear());
            Integer n2 = tZWindow2.fixedSavingAmountSecs;
            if (n2 == null) {
                n2 = 0;
                object = tZWindow2.ruleList.iterator();
                while (object.hasNext() && ((TZRule)((Object)(iterator = (TZRule)object.next()))).toEpochSecond(zoneOffset, n) <= localDateTime.toEpochSecond(zoneOffset3)) {
                    n2 = ((TZRule)((Object)iterator)).savingAmountSecs;
                }
            }
            if (!zoneOffset.equals(tZWindow2.standardOffset)) {
                arrayList.add(new ZoneOffsetTransition(LocalDateTime.ofEpochSecond(localDateTime.toEpochSecond(zoneOffset3), 0, zoneOffset), zoneOffset, tZWindow2.standardOffset));
                zoneOffset = tZWindow2.standardOffset;
            }
            if (!zoneOffset3.equals(object = ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n2))) {
                arrayList2.add(new ZoneOffsetTransition(localDateTime, zoneOffset3, (ZoneOffset)object));
            }
            n = n2;
            for (TZRule tZRule : tZWindow2.ruleList) {
                ZoneOffsetTransition zoneOffsetTransition;
                if (!tZRule.isTransition(n) || (zoneOffsetTransition = tZRule.toTransition(zoneOffset, n)).toEpochSecond() < localDateTime.toEpochSecond(zoneOffset3) || zoneOffsetTransition.toEpochSecond() >= tZWindow2.createDateTimeEpochSecond(n)) continue;
                arrayList2.add(zoneOffsetTransition);
                n = tZRule.savingAmountSecs;
            }
            iterator = tZWindow2.lastRuleList.iterator();
            while (iterator.hasNext()) {
                TZRule tZRule;
                tZRule = (TZRule)iterator.next();
                arrayList3.add(tZRule.toTransitionRule(zoneOffset, n));
                n = tZRule.savingAmountSecs;
            }
            zoneOffset3 = tZWindow2.createWallOffset(n);
            localDateTime = LocalDateTime.ofEpochSecond(tZWindow2.createDateTimeEpochSecond(n), 0, zoneOffset3);
        }
        return new ZoneRules(tZWindow.standardOffset, zoneOffset2, arrayList, arrayList2, arrayList3);
    }

    class TZRule
    implements Comparable<TZRule> {
        private int year;
        private int month;
        private int dayOfMonthIndicator;
        private int dayOfWeek;
        private LocalTime time;
        private boolean timeEndOfDay;
        private TimeDefinition timeDefinition;
        private int savingAmountSecs;

        TZRule(int n, int n2, int n3, int n4, LocalTime localTime, boolean bl, TimeDefinition timeDefinition, int n5) {
            this.year = n;
            this.month = n2;
            this.dayOfMonthIndicator = n3;
            this.dayOfWeek = n4;
            this.time = localTime;
            this.timeEndOfDay = bl;
            this.timeDefinition = timeDefinition;
            this.savingAmountSecs = n5;
        }

        ZoneOffsetTransition toTransition(ZoneOffset zoneOffset, int n) {
            LocalDate localDate = this.toLocalDate();
            LocalDateTime localDateTime = LocalDateTime.of(localDate, this.time);
            ZoneOffset zoneOffset2 = ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n);
            LocalDateTime localDateTime2 = this.timeDefinition.createDateTime(localDateTime, zoneOffset, zoneOffset2);
            ZoneOffset zoneOffset3 = ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + this.savingAmountSecs);
            return new ZoneOffsetTransition(localDateTime2, zoneOffset2, zoneOffset3);
        }

        long toEpochSecond(ZoneOffset zoneOffset, int n) {
            LocalDateTime localDateTime = LocalDateTime.of(this.toLocalDate(), this.time);
            ZoneOffset zoneOffset2 = ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n);
            return this.timeDefinition.createDateTime(localDateTime, zoneOffset, zoneOffset2).toEpochSecond(zoneOffset2);
        }

        boolean isTransition(int n) {
            return this.savingAmountSecs != n;
        }

        ZoneOffsetTransitionRule toTransitionRule(ZoneOffset zoneOffset, int n) {
            if (this.dayOfMonthIndicator < 0 && this.month != 2) {
                this.dayOfMonthIndicator = Utils.maxLengthOfMonth(this.month) - 6;
            }
            if (this.timeEndOfDay && this.dayOfMonthIndicator > 0 && !(this.dayOfMonthIndicator == 28 && this.month == 2)) {
                LocalDate localDate = LocalDate.of(2004, this.month, this.dayOfMonthIndicator).plusDays(1L);
                this.month = localDate.getMonth();
                this.dayOfMonthIndicator = localDate.getDayOfMonth();
                if (this.dayOfWeek != -1) {
                    this.dayOfWeek = Utils.plusDayOfWeek(this.dayOfWeek, 1L);
                }
                this.timeEndOfDay = false;
            }
            return new ZoneOffsetTransitionRule(this.month, this.dayOfMonthIndicator, this.dayOfWeek, this.time, this.timeEndOfDay, this.timeDefinition, zoneOffset, ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n), ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + this.savingAmountSecs));
        }

        @Override
        public int compareTo(TZRule tZRule) {
            int n = this.year - tZRule.year;
            int n2 = n = n == 0 ? this.month - tZRule.month : n;
            if (n == 0) {
                LocalDate localDate = this.toLocalDate();
                LocalDate localDate2 = tZRule.toLocalDate();
                n = localDate.compareTo(localDate2);
            }
            n = n == 0 ? this.time.compareTo(tZRule.time) : n;
            return n;
        }

        private LocalDate toLocalDate() {
            LocalDate localDate;
            if (this.dayOfMonthIndicator < 0) {
                int n = Utils.lengthOfMonth(this.month, Utils.isLeapYear(this.year));
                localDate = LocalDate.of(this.year, this.month, n + 1 + this.dayOfMonthIndicator);
                if (this.dayOfWeek != -1) {
                    localDate = Utils.previousOrSame(localDate, this.dayOfWeek);
                }
            } else {
                localDate = LocalDate.of(this.year, this.month, this.dayOfMonthIndicator);
                if (this.dayOfWeek != -1) {
                    localDate = Utils.nextOrSame(localDate, this.dayOfWeek);
                }
            }
            if (this.timeEndOfDay) {
                localDate = localDate.plusDays(1L);
            }
            return localDate;
        }
    }

    class TZWindow {
        private final ZoneOffset standardOffset;
        private final LocalDateTime windowEnd;
        private final TimeDefinition timeDefinition;
        private Integer fixedSavingAmountSecs;
        private List<TZRule> ruleList = new ArrayList<TZRule>();
        private int maxLastRuleStartYear = -999999999;
        private List<TZRule> lastRuleList = new ArrayList<TZRule>();

        TZWindow(ZoneOffset zoneOffset, LocalDateTime localDateTime, TimeDefinition timeDefinition) {
            this.windowEnd = localDateTime;
            this.timeDefinition = timeDefinition;
            this.standardOffset = zoneOffset;
        }

        void setFixedSavings(int n) {
            if (this.ruleList.size() > 0 || this.lastRuleList.size() > 0) {
                throw new IllegalStateException("Window has DST rules, so cannot have fixed savings");
            }
            this.fixedSavingAmountSecs = n;
        }

        void addRule(int n, int n2, int n3, int n4, int n5, LocalTime localTime, boolean bl, TimeDefinition timeDefinition, int n6) {
            if (this.fixedSavingAmountSecs != null) {
                throw new IllegalStateException("Window has a fixed DST saving, so cannot have DST rules");
            }
            if (this.ruleList.size() >= 2000) {
                throw new IllegalStateException("Window has reached the maximum number of allowed rules");
            }
            boolean bl2 = false;
            if (n2 == 999999999) {
                bl2 = true;
                n2 = n;
            }
            for (int i = n; i <= n2; ++i) {
                TZRule tZRule = new TZRule(i, n3, n4, n5, localTime, bl, timeDefinition, n6);
                if (bl2) {
                    this.lastRuleList.add(tZRule);
                    this.maxLastRuleStartYear = Math.max(n, this.maxLastRuleStartYear);
                    continue;
                }
                this.ruleList.add(tZRule);
            }
        }

        void validateWindowOrder(TZWindow tZWindow) {
            if (this.windowEnd.compareTo(tZWindow.windowEnd) < 0) {
                throw new IllegalStateException("Windows must be added in date-time order: " + this.windowEnd + " < " + tZWindow.windowEnd);
            }
        }

        void tidy(int n) {
            if (this.lastRuleList.size() == 1) {
                throw new IllegalStateException("Cannot have only one rule defined as being forever");
            }
            if (this.windowEnd.equals(LocalDateTime.MAX)) {
                this.maxLastRuleStartYear = Math.max(this.maxLastRuleStartYear, n) + 1;
                for (TZRule tZRule : this.lastRuleList) {
                    this.addRule(tZRule.year, this.maxLastRuleStartYear, tZRule.month, tZRule.dayOfMonthIndicator, tZRule.dayOfWeek, tZRule.time, tZRule.timeEndOfDay, tZRule.timeDefinition, tZRule.savingAmountSecs);
                    tZRule.year = this.maxLastRuleStartYear + 1;
                }
                if (this.maxLastRuleStartYear == 999999999) {
                    this.lastRuleList.clear();
                } else {
                    ++this.maxLastRuleStartYear;
                }
            } else {
                int n2 = this.windowEnd.getYear();
                for (TZRule tZRule : this.lastRuleList) {
                    this.addRule(tZRule.year, n2 + 1, tZRule.month, tZRule.dayOfMonthIndicator, tZRule.dayOfWeek, tZRule.time, tZRule.timeEndOfDay, tZRule.timeDefinition, tZRule.savingAmountSecs);
                }
                this.lastRuleList.clear();
                this.maxLastRuleStartYear = 999999999;
            }
            Collections.sort(this.ruleList);
            Collections.sort(this.lastRuleList);
            if (this.ruleList.size() == 0 && this.fixedSavingAmountSecs == null) {
                this.fixedSavingAmountSecs = 0;
            }
        }

        boolean isSingleWindowStandardOffset() {
            return this.windowEnd.equals(LocalDateTime.MAX) && this.timeDefinition == TimeDefinition.WALL && this.fixedSavingAmountSecs == null && this.lastRuleList.isEmpty() && this.ruleList.isEmpty();
        }

        ZoneOffset createWallOffset(int n) {
            return ZoneOffset.ofTotalSeconds(this.standardOffset.getTotalSeconds() + n);
        }

        long createDateTimeEpochSecond(int n) {
            ZoneOffset zoneOffset = this.createWallOffset(n);
            LocalDateTime localDateTime = this.timeDefinition.createDateTime(this.windowEnd, this.standardOffset, zoneOffset);
            return localDateTime.toEpochSecond(zoneOffset);
        }
    }
}

