/*
 * Decompiled with CFR 0.152.
 */
package tools.tzdb;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tools.tzdb.LocalTime;
import tools.tzdb.TimeDefinition;
import tools.tzdb.ZoneOffset;
import tools.tzdb.ZoneOffsetTransition;
import tools.tzdb.ZoneOffsetTransitionRule;

final class ZoneRules {
    private final long[] standardTransitions;
    private final ZoneOffset[] standardOffsets;
    private final long[] savingsInstantTransitions;
    private final ZoneOffset[] wallOffsets;
    private final ZoneOffsetTransitionRule[] lastRules;
    static final byte ZRULES = 1;

    ZoneRules(ZoneOffset zoneOffset, ZoneOffset zoneOffset2, List<ZoneOffsetTransition> list, List<ZoneOffsetTransition> list2, List<ZoneOffsetTransitionRule> list3) {
        this.standardTransitions = new long[list.size()];
        this.standardOffsets = new ZoneOffset[list.size() + 1];
        this.standardOffsets[0] = zoneOffset;
        for (int i = 0; i < list.size(); ++i) {
            this.standardTransitions[i] = list.get(i).toEpochSecond();
            this.standardOffsets[i + 1] = list.get(i).getOffsetAfter();
        }
        ArrayList<ZoneOffset> arrayList = new ArrayList<ZoneOffset>();
        arrayList.add(zoneOffset2);
        for (ZoneOffsetTransition zoneOffsetTransition : list2) {
            arrayList.add(zoneOffsetTransition.getOffsetAfter());
        }
        this.wallOffsets = arrayList.toArray(new ZoneOffset[arrayList.size()]);
        this.savingsInstantTransitions = new long[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            this.savingsInstantTransitions[i] = list2.get(i).toEpochSecond();
        }
        if (list3.size() > 16) {
            throw new IllegalArgumentException("Too many transition rules");
        }
        this.lastRules = list3.toArray(new ZoneOffsetTransitionRule[list3.size()]);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(1);
        dataOutput.writeInt(this.standardTransitions.length);
        for (long l : this.standardTransitions) {
            ZoneRules.writeEpochSec(l, dataOutput);
        }
        for (ZoneOffset zoneOffset : this.standardOffsets) {
            ZoneRules.writeOffset(zoneOffset, dataOutput);
        }
        dataOutput.writeInt(this.savingsInstantTransitions.length);
        for (long l : this.savingsInstantTransitions) {
            ZoneRules.writeEpochSec(l, dataOutput);
        }
        for (ZoneOffset zoneOffset : this.wallOffsets) {
            ZoneRules.writeOffset(zoneOffset, dataOutput);
        }
        dataOutput.writeByte(this.lastRules.length);
        for (ZoneOffsetTransitionRule zoneOffsetTransitionRule : this.lastRules) {
            ZoneRules.writeRule(zoneOffsetTransitionRule, dataOutput);
        }
    }

    static void writeOffset(ZoneOffset zoneOffset, DataOutput dataOutput) throws IOException {
        int n = zoneOffset.getTotalSeconds();
        int n2 = n % 900 == 0 ? n / 900 : 127;
        dataOutput.writeByte(n2);
        if (n2 == 127) {
            dataOutput.writeInt(n);
        }
    }

    static void writeEpochSec(long l, DataOutput dataOutput) throws IOException {
        if (l >= -4575744000L && l < 10413792000L && l % 900L == 0L) {
            int n = (int)((l + 4575744000L) / 900L);
            dataOutput.writeByte(n >>> 16 & 0xFF);
            dataOutput.writeByte(n >>> 8 & 0xFF);
            dataOutput.writeByte(n & 0xFF);
        } else {
            dataOutput.writeByte(255);
            dataOutput.writeLong(l);
        }
    }

    static void writeRule(ZoneOffsetTransitionRule zoneOffsetTransitionRule, DataOutput dataOutput) throws IOException {
        int n = zoneOffsetTransitionRule.month;
        byte by = zoneOffsetTransitionRule.dom;
        int n2 = zoneOffsetTransitionRule.dow;
        LocalTime localTime = zoneOffsetTransitionRule.time;
        boolean bl = zoneOffsetTransitionRule.timeEndOfDay;
        TimeDefinition timeDefinition = zoneOffsetTransitionRule.timeDefinition;
        ZoneOffset zoneOffset = zoneOffsetTransitionRule.standardOffset;
        ZoneOffset zoneOffset2 = zoneOffsetTransitionRule.offsetBefore;
        ZoneOffset zoneOffset3 = zoneOffsetTransitionRule.offsetAfter;
        int n3 = bl ? 86400 : localTime.toSecondOfDay();
        int n4 = zoneOffset.getTotalSeconds();
        int n5 = zoneOffset2.getTotalSeconds() - n4;
        int n6 = zoneOffset3.getTotalSeconds() - n4;
        int n7 = n3 % 3600 == 0 ? (bl ? 24 : localTime.getHour()) : 31;
        int n8 = n4 % 900 == 0 ? n4 / 900 + 128 : 255;
        int n9 = n5 == 0 || n5 == 1800 || n5 == 3600 ? n5 / 1800 : 3;
        int n10 = n6 == 0 || n6 == 1800 || n6 == 3600 ? n6 / 1800 : 3;
        int n11 = n2 == -1 ? 0 : n2;
        int n12 = (n << 28) + (by + 32 << 22) + (n11 << 19) + (n7 << 14) + (timeDefinition.ordinal() << 12) + (n8 << 4) + (n9 << 2) + n10;
        dataOutput.writeInt(n12);
        if (n7 == 31) {
            dataOutput.writeInt(n3);
        }
        if (n8 == 255) {
            dataOutput.writeInt(n4);
        }
        if (n9 == 3) {
            dataOutput.writeInt(zoneOffset2.getTotalSeconds());
        }
        if (n10 == 3) {
            dataOutput.writeInt(zoneOffset3.getTotalSeconds());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZoneRules) {
            ZoneRules zoneRules = (ZoneRules)object;
            return Arrays.equals(this.standardTransitions, zoneRules.standardTransitions) && Arrays.equals(this.standardOffsets, zoneRules.standardOffsets) && Arrays.equals(this.savingsInstantTransitions, zoneRules.savingsInstantTransitions) && Arrays.equals(this.wallOffsets, zoneRules.wallOffsets) && Arrays.equals(this.lastRules, zoneRules.lastRules);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.standardTransitions) ^ Arrays.hashCode(this.standardOffsets) ^ Arrays.hashCode(this.savingsInstantTransitions) ^ Arrays.hashCode(this.wallOffsets) ^ Arrays.hashCode(this.lastRules);
    }
}

