/*
 * Decompiled with CFR 0.152.
 */
package tools.tzdb;

import tools.tzdb.ChronoField;

final class LocalTime {
    public static final LocalTime MIN;
    public static final LocalTime MAX;
    public static final LocalTime MIDNIGHT;
    public static final LocalTime NOON;
    private static final LocalTime[] HOURS;
    static final int HOURS_PER_DAY = 24;
    static final int MINUTES_PER_HOUR = 60;
    static final int MINUTES_PER_DAY = 1440;
    static final int SECONDS_PER_MINUTE = 60;
    static final int SECONDS_PER_HOUR = 3600;
    static final int SECONDS_PER_DAY = 86400;
    static final long MILLIS_PER_DAY = 86400000L;
    static final long MICROS_PER_DAY = 86400000000L;
    private final byte hour;
    private final byte minute;
    private final byte second;

    public static LocalTime of(int n, int n2) {
        ChronoField.HOUR_OF_DAY.checkValidValue(n);
        if (n2 == 0) {
            return HOURS[n];
        }
        ChronoField.MINUTE_OF_HOUR.checkValidValue(n2);
        return new LocalTime(n, n2, 0);
    }

    public static LocalTime of(int n, int n2, int n3) {
        ChronoField.HOUR_OF_DAY.checkValidValue(n);
        if ((n2 | n3) == 0) {
            return HOURS[n];
        }
        ChronoField.MINUTE_OF_HOUR.checkValidValue(n2);
        ChronoField.SECOND_OF_MINUTE.checkValidValue(n3);
        return new LocalTime(n, n2, n3);
    }

    public static LocalTime ofSecondOfDay(int n) {
        ChronoField.SECOND_OF_DAY.checkValidValue(n);
        int n2 = n / 3600;
        int n3 = (n -= n2 * 3600) / 60;
        return LocalTime.create(n2, n3, n -= n3 * 60);
    }

    private static LocalTime create(int n, int n2, int n3) {
        if ((n2 | n3) == 0) {
            return HOURS[n];
        }
        return new LocalTime(n, n2, n3);
    }

    private LocalTime(int n, int n2, int n3) {
        this.hour = (byte)n;
        this.minute = (byte)n2;
        this.second = (byte)n3;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public LocalTime plusSeconds(long l) {
        if (l == 0L) {
            return this;
        }
        int n = this.hour * 3600 + this.minute * 60 + this.second;
        int n2 = ((int)(l % 86400L) + n + 86400) % 86400;
        if (n == n2) {
            return this;
        }
        int n3 = n2 / 3600;
        int n4 = n2 / 60 % 60;
        int n5 = n2 % 60;
        return LocalTime.create(n3, n4, n5);
    }

    public LocalTime minusSeconds(long l) {
        return this.plusSeconds(-(l % 86400L));
    }

    public int toSecondOfDay() {
        int n = this.hour * 3600;
        n += this.minute * 60;
        return n += this.second;
    }

    public int compareTo(LocalTime localTime) {
        int n = Integer.compare(this.hour, localTime.hour);
        if (n == 0 && (n = Integer.compare(this.minute, localTime.minute)) == 0) {
            n = Integer.compare(this.second, localTime.second);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            return this.hour == localTime.hour && this.minute == localTime.minute && this.second == localTime.second;
        }
        return false;
    }

    public int hashCode() {
        long l = this.toSecondOfDay();
        return (int)(l ^ l >>> 32);
    }

    static {
        HOURS = new LocalTime[24];
        for (int i = 0; i < HOURS.length; ++i) {
            LocalTime.HOURS[i] = new LocalTime(i, 0, 0);
        }
        MIDNIGHT = HOURS[0];
        NOON = HOURS[12];
        MIN = HOURS[0];
        MAX = new LocalTime(23, 59, 59);
    }
}

