/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.tzupdater.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TarInputStream
extends FilterInputStream {
    private static final int DEFAULT_BLKSIZE = 512;
    private int blockSize;
    private TarEntry entry;
    private long remaining;
    private boolean closed;

    public TarInputStream(InputStream inputStream) {
        this(inputStream, 512);
    }

    public TarInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.blockSize = n;
        this.remaining = 0L;
        this.closed = false;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed");
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private boolean isEOF(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public long skip(long l) throws IOException {
        int n;
        int n2;
        if (l < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        int n3 = (int)Math.min(l, Integer.MAX_VALUE);
        byte[] byArray = new byte[Math.min(n3, 8192)];
        for (n = 0; n < n3; n += n2) {
            n2 = n3 - n;
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            if ((n2 = this.read(byArray, 0, n2)) == -1) break;
        }
        return n;
    }

    public TarEntry getNextEntry() throws IOException {
        int n;
        this.ensureOpen();
        if (this.entry != null) {
            this.closeEntry();
        }
        byte[] byArray = new byte[this.blockSize];
        for (int i = 0; i < this.blockSize; i += n) {
            n = super.read(byArray, i, this.blockSize - i);
            if (n != -1) continue;
            return null;
        }
        if (this.isEOF(byArray)) {
            return null;
        }
        this.entry = new TarEntry(byArray);
        this.remaining = this.entry.getSize();
        return this.entry;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        byte[] byArray = new byte[this.blockSize];
        while (this.read(byArray, 0, byArray.length) != -1) {
        }
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.remaining;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.ensureOpen();
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.entry == null && this.remaining <= 0L) {
            return -1;
        }
        if ((long)n2 > this.remaining) {
            n2 = (int)this.remaining;
        }
        if ((n3 = super.read(byArray, n, n2)) == -1) {
            this.entry = null;
            return -1;
        }
        this.remaining -= (long)n3;
        if (this.remaining == 0L) {
            int n4 = (this.blockSize - (int)(this.entry.getSize() % (long)this.blockSize)) % this.blockSize;
            if (n4 > 0) {
                int n5;
                byte[] byArray2 = new byte[n4];
                while (n4 > 0 && (n5 = super.read(byArray2, 0, n4)) != -1) {
                    n4 -= n5;
                }
            }
            this.entry = null;
        }
        return n3;
    }

    public static class TarEntry {
        private static final int NAME_OFF = 0;
        private static final int NAME_LEN = 100;
        private static final int SIZE_OFF = 124;
        private static final int SIZE_LEN = 12;
        private static final int MAGIC_OFF = 257;
        private static final int MAGIC_LEN = 6;
        private static final long MAXSIZE = 0x1FFFFFFFFL;
        private String name;
        private long size;

        public TarEntry(byte[] byArray) {
            this.name = TarEntry.toString(byArray, 0, 100);
            this.size = TarEntry.toNumber(byArray, 124, 12);
            String string = TarEntry.toString(byArray, 257, 6);
            if (!string.startsWith("ustar") || this.size < 0L || this.size > 0x1FFFFFFFFL) {
                throw new IllegalArgumentException("Illegal tar entry: magic=" + string + ", size=" + this.size);
            }
        }

        public long getSize() {
            return this.size;
        }

        public String getName() {
            return this.name;
        }

        private static long toNumber(byte[] byArray, int n, int n2) {
            byte by;
            long l = 0L;
            int n3 = n + n2;
            while (n < n3 && ((by = byArray[n]) == 32 || by == 48)) {
                ++n;
            }
            while (n < n3 && (by = byArray[n++]) >= 48 && by < 56) {
                l = (l << 3) + (long)(by - 48);
            }
            return l;
        }

        private static String toString(byte[] byArray, int n, int n2) {
            int n3 = n;
            int n4 = n + n2;
            while (n < n4 && byArray[n] != 0) {
                ++n;
            }
            return new String(byArray, n3, n - n3);
        }
    }
}

