/*
 * Decompiled with CFR 0.152.
 */
package com.senior.franklyn.tools;

import com.senior.franklyn.tools.Command;
import java.awt.Component;
import java.awt.Cursor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class FirmwareCommunicator
extends Thread {
    private String ip;
    private String filePath;
    private JButton btn;

    public FirmwareCommunicator(String ip, String filePath, JButton btn) {
        this.ip = ip;
        this.filePath = filePath;
        this.btn = btn;
    }

    @Override
    public void run() {
        if (this.btn.getText().equals("Enviando...")) {
            return;
        }
        String old = this.btn.getText();
        this.btn.getParent().setCursor(new Cursor(3));
        Component[] c = this.btn.getParent().getComponents();
        int i = 0;
        while (i < c.length) {
            c[i].setCursor(new Cursor(3));
            ++i;
        }
        this.btn.setText("Enviando...");
        this.btn.setEnabled(false);
        this.enviaComando();
        this.btn.getParent().setCursor(new Cursor(0));
        this.btn.setText(old);
        c = this.btn.getParent().getComponents();
        i = 0;
        while (i < c.length) {
            c[i].setCursor(new Cursor(0));
            ++i;
        }
        this.btn.setEnabled(true);
    }

    public void enviaComando() {
        try {
            Socket socket = new Socket(this.ip, 7000);
            OutputStream oStream = socket.getOutputStream();
            InputStream iStream = socket.getInputStream();
            this.sendCommand(this.getCommand13(this.filePath), oStream, iStream);
            socket.close();
        }
        catch (UnknownHostException e) {
            JOptionPane.showMessageDialog(null, "Host n\u00e3o encontrado");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    public void sendCommand(Command command, OutputStream oStream, InputStream iStream) throws IOException {
        command.sentInstant = (int)(System.currentTimeMillis() / 1000L);
        DataOutputStream daos = new DataOutputStream(oStream);
        daos.writeByte(30);
        daos.writeByte(command.codigo);
        daos.writeByte(command.timeout);
        daos.writeInt(command.sentInstant);
        daos.writeInt(command.dataSize);
        if (command.data != null) {
            daos.write(command.data);
        }
        daos.flush();
        DataInputStream dais = new DataInputStream(iStream);
        int ReturnID = dais.read();
        dais.readInt();
        int DataSize = dais.readInt();
        if (DataSize > 0) {
            byte[] data = new byte[DataSize];
            dais.read(data);
        }
        if (ReturnID == 1) {
            JOptionPane.showMessageDialog(null, "Transfer\u00eancia conclu\u00edda com sucesso!");
        } else {
            JOptionPane.showMessageDialog(null, "Envio conclu\u00eddo, retorno : \nC\u00f3digo: " + Integer.toString(command.codigo) + "\nReturnID: " + Integer.toString(ReturnID) + "\nDataSize: " + Integer.toString(DataSize));
        }
    }

    public Command getCommand13(String filePath) throws IOException {
        FileInputStream fi = new FileInputStream(filePath);
        Command command = new Command();
        command.codigo = (byte)13;
        command.timeout = (byte)10;
        command.dataSize = fi.available();
        command.data = new byte[command.dataSize];
        fi.read(command.data, 0, command.data.length);
        return command;
    }
}

