/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior;

import br.com.senior.FrmAbout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.apache.commons.io.FileUtils;

public class Main
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 1L;
    private Thread listener;
    JTextArea textArea;
    private DatagramSocket client;
    private DatagramSocket server;
    private byte[] serverbffr;
    private byte[] clientbffr;
    static Main form = null;
    File file = new File("sqlmon.log");
    FileWriter fw = new FileWriter(this.file.getAbsoluteFile());
    private boolean paused = false;
    private Properties props;

    public static void main(String[] args) {
        try {
            form = new Main();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        form.setVisible(true);
    }

    public Main() throws IOException {
        this.setTitle("JDBC Monitor Viewer");
        this.initialize();
        this.readproperties();
        this.listener = new Thread(this);
        this.listener.start();
    }

    private void readproperties() {
        this.props = new Properties();
        try {
            File f = FileUtils.getFile((String[])new String[]{"config.properties"});
            if (!f.exists()) {
                f.createNewFile();
            }
            FileInputStream is = new FileInputStream(f);
            this.props.load(is);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private String getServer() {
        String host = this.props.getProperty("host");
        if (host == null || host.isEmpty()) {
            host = "localhost";
        }
        return host;
    }

    private int getPort() {
        String sPort = this.props.getProperty("port");
        int port = sPort == null || sPort.isEmpty() ? 9998 : Integer.parseInt(sPort);
        return port;
    }

    private void initialize() {
        this.setBounds(100, 100, 800, 600);
        this.setDefaultCloseOperation(3);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnNewMenu = new JMenu("File");
        menuBar.add(mnNewMenu);
        JMenuItem mnSaveLog = new JMenuItem("Save log");
        mnSaveLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.saveLog();
            }
        });
        mnNewMenu.add(mnSaveLog);
        JMenuItem mnExit = new JMenuItem("Exit");
        mnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.desconectar();
            }
        });
        mnNewMenu.add(mnExit);
        JMenu mnHelp = new JMenu("Help");
        menuBar.add(mnHelp);
        JMenuItem mnAbout = new JMenuItem("About");
        mnAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmAbout frmAbout = new FrmAbout();
                frmAbout.setVisible(true);
            }
        });
        mnHelp.add(mnAbout);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JToolBar toolBar = new JToolBar();
        toolBar.setBackground(Color.GRAY);
        this.getContentPane().add((Component)toolBar, "North");
        JButton btnSave = new JButton("Save log");
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.saveLog();
            }
        });
        toolBar.add(btnSave);
        JButton btnClear = new JButton("Clear");
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.textArea.setText("");
            }
        });
        toolBar.add(btnClear);
        final JButton btnPause = new JButton("Pause");
        btnPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.paused = !Main.this.paused;
                if (Main.this.paused) {
                    btnPause.setText("Continue");
                } else {
                    btnPause.setText("Pause");
                }
            }
        });
        toolBar.add(btnPause);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setRows(5);
        scrollPane.setViewportView(this.textArea);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                this.formWindowClosing(evt);
            }

            private void formWindowClosing(WindowEvent evt) {
                Main.this.desconectar();
            }
        });
    }

    private void desconectar() {
        this.sendCommand("SAIR");
    }

    private void sendCommand(String cmd) {
        try {
            String tam = "serverbffrsize=" + cmd.length() + "=";
            this.serverbffr = new byte[tam.length()];
            this.serverbffr = tam.getBytes();
            DatagramPacket sendpack = new DatagramPacket(this.serverbffr, this.serverbffr.length, InetAddress.getByName(this.getServer()), this.getPort());
            this.client.send(sendpack);
            String message = String.valueOf(cmd) + "\n";
            this.clientbffr = new byte[message.length()];
            this.clientbffr = message.getBytes();
            sendpack = new DatagramPacket(this.clientbffr, this.clientbffr.length, InetAddress.getByName(this.getServer()), this.getPort());
            this.client.send(sendpack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveLog() {
        JFileChooser savefile = new JFileChooser();
        int sf = savefile.showSaveDialog(null);
        if (sf == 0) {
            try {
                FileUtils.writeStringToFile((File)FileUtils.getFile((File)savefile.getSelectedFile(), (String[])new String[0]), (String)this.textArea.getText());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            JOptionPane.showMessageDialog(null, "Arquivo salvo", "File Saved", 1);
        } else if (sf == 1) {
            JOptionPane.showMessageDialog(null, "Opera\u00e7\u00e3o cancelada");
        }
    }

    @Override
    public void run() {
        this.serverbffr = new byte[1024];
        try {
            this.client = new DatagramSocket();
            this.server = new DatagramSocket(9998);
            while (true) {
                DatagramPacket datapack = new DatagramPacket(this.serverbffr, this.serverbffr.length);
                this.server.receive(datapack);
                if (this.paused) continue;
                String msg = new String(datapack.getData());
                if (msg.startsWith("serverbffrsize=")) {
                    int tam = Integer.valueOf(msg.split("=")[1]);
                    this.serverbffr = new byte[tam];
                    continue;
                }
                msg = "\n" + msg;
                this.textArea.append("\n" + msg);
                this.serverbffr = new byte[1024];
                FileUtils.writeStringToFile((File)FileUtils.getFile((String[])new String[]{"sqlmon.log"}), (String)msg, (boolean)true);
            }
        }
        catch (Exception exception) {
            return;
        }
    }
}

