/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.tzupdater;

import com.sun.tools.tzupdater.TextFileReader;
import com.sun.tools.tzupdater.TimezoneUpdater;
import com.sun.tools.tzupdater.TzupdaterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class DataConfiguration {
    private static final String VENDOR_CONF = "/data/vendor.conf";
    private static final List configs = new ArrayList();
    private static DataConfiguration conf = null;
    private final Pattern vendor;
    private final String tzID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DataConfiguration getDataConfiguration(String string, File file) throws IOException {
        if (configs.isEmpty()) {
            InputStream inputStream = TimezoneUpdater.class.getResourceAsStream(VENDOR_CONF);
            TextFileReader textFileReader = new TextFileReader(inputStream);
            try {
                String string2 = null;
                String[] stringArray = new String[2];
                stringArray[0] = textFileReader.getLine();
                textFileReader.close();
                File file2 = new File(file.getPath() + File.separator + "version");
                if (file2.exists()) {
                    if (!file2.canRead()) {
                        throw new TzupdaterException("Unable to read " + file2.getPath());
                    }
                    textFileReader = new TextFileReader(new FileInputStream(file2));
                    stringArray[1] = "tzdata" + textFileReader.getLine().trim();
                } else {
                    File file3 = new File(file.getPath() + File.separator + "Makefile");
                    if (!file3.canRead()) {
                        throw new TzupdaterException("Unable to read " + file3.getPath());
                    }
                    textFileReader = new TextFileReader(new FileInputStream(file3));
                    while ((string2 = textFileReader.getLine()) != null) {
                        if (!string2.startsWith("VERSION=")) continue;
                        stringArray[1] = "tzdata" + string2.substring(string2.indexOf(61) + 1, string2.length()).trim();
                        break;
                    }
                }
                try {
                    conf = new DataConfiguration(stringArray[0], stringArray[1]);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new TzupdaterException("/data/vendor.conf:" + stringArray[0] + ": regex error", patternSyntaxException);
                }
            }
            finally {
                if (textFileReader != null) {
                    textFileReader.close();
                }
            }
        }
        if (conf.matchesVendor(string)) {
            return conf;
        }
        return null;
    }

    DataConfiguration(String string, String string2) {
        this.vendor = Pattern.compile(string);
        this.tzID = string2;
    }

    private boolean matchesVendor(String string) {
        return this.vendor.matcher(string).matches();
    }

    String getTzID() {
        return this.tzID;
    }
}

