-- EXECUTAR COM O MGGLO

-- Create table
create table GLO_DBMEGAINDICETAB
(
  id             NUMBER not null,
  dbit_st_owner  VARCHAR2(30),
  dbit_st_tabela VARCHAR2(30)
);
-- Add comments to the table 
comment on table GLO_DBMEGAINDICETAB
  is 'Controle de tabelas para analise de ndices do mdulo DBMega';
-- Add comments to the columns 
comment on column GLO_DBMEGAINDICETAB.id
  is 'ID
ID da tabela de controle';
comment on column GLO_DBMEGAINDICETAB.dbit_st_owner
  is 'Owner
Owner da tabela a ser verificada';
comment on column GLO_DBMEGAINDICETAB.dbit_st_tabela
  is 'Tabela
Nome da tabela a ser verificada';
-- Create/Recreate primary, unique and foreign key constraints 
alter table GLO_DBMEGAINDICETAB
  add constraint PK_GLO_DBMEGAINDICETAB primary key (ID);
alter table GLO_DBMEGAINDICETAB
  add constraint AK_GLO_DBMEGAINDICETAB unique (DBIT_ST_OWNER, DBIT_ST_TABELA);

-- Create table
create table GLO_DBMEGAINDICE
(
  id                 NUMBER not null,
  dbi_st_ownerfk     VARCHAR2(30),
  dbi_st_tabelafk    VARCHAR2(30),
  id_dbmegaindicetab NUMBER,
  dbi_st_nomeindice  VARCHAR2(30),
  dbi_ch_status      CHAR(1),
  dbi_st_comando     VARCHAR2(2000)
);
-- Add comments to the table 
comment on table GLO_DBMEGAINDICE
  is 'Controle de ndices do mdulo DBMega';
-- Add comments to the columns 
comment on column GLO_DBMEGAINDICE.id
  is 'ID
ID da tabela de controle de ndices';
comment on column GLO_DBMEGAINDICE.dbi_st_ownerfk
  is 'Owner
Owner da tabela que possu a foreign key';
comment on column GLO_DBMEGAINDICE.dbi_st_tabelafk
  is 'Tabela
Nome da tabela que possu a foreign key';
comment on column GLO_DBMEGAINDICE.id_dbmegaindicetab
  is 'ID
ID da tabela de controle';
comment on column GLO_DBMEGAINDICE.dbi_st_nomeindice
  is 'Nome ndice
Nome do ndice criado';
comment on column GLO_DBMEGAINDICE.dbi_ch_status
  is 'Status
Status do log
P;Pendente
O;Executado com sucesso
E;Erro
A;Aviso';
comment on column GLO_DBMEGAINDICE.dbi_st_comando
  is 'Comando
Comando do ndice criado';
-- Create/Recreate indexes 
create index GLO_DBIT_IDENT_GLO_DBI on GLO_DBMEGAINDICE (ID_DBMEGAINDICETAB);
-- Create/Recreate primary, unique and foreign key constraints 
alter table GLO_DBMEGAINDICE
  add constraint PK_GLO_DBMEGAINDICE primary key (ID);
alter table GLO_DBMEGAINDICE
  add constraint GLO_DBIT_IDENT_GLO_DBI foreign key (ID_DBMEGAINDICETAB)
  references GLO_DBMEGAINDICETAB (ID) on delete cascade;

-- Create table
create table GLO_DBMEGALOG
(
  id              NUMBER not null,
  id_dbmega       NUMBER,
  dbl_dt_data     DATE,
  dbl_ch_status   CHAR(1),
  dbl_cl_mensagem CLOB
);
-- Add comments to the table 
comment on table GLO_DBMEGALOG
  is 'Log do mdulo DBMega';
-- Add comments to the columns 
comment on column GLO_DBMEGALOG.id
  is 'ID
ID da tabela de Log';
comment on column GLO_DBMEGALOG.id_dbmega
  is 'ID
ID das tabelas que gravam log no mdulo DBMega';
comment on column GLO_DBMEGALOG.dbl_dt_data
  is 'Data
Data de criao do log';
comment on column GLO_DBMEGALOG.dbl_ch_status
  is 'Status
Status do log
O;Executado com sucesso
E;Erro
A;Aviso';
comment on column GLO_DBMEGALOG.dbl_cl_mensagem
  is 'Mensagem
Mensagem de retorno';
-- Create/Recreate indexes 
create index GLO_IE_IDDBMEGA on GLO_DBMEGALOG (ID_DBMEGA);
-- Create/Recreate primary, unique and foreign key constraints 
alter table GLO_DBMEGALOG
  add constraint PK_GLO_DBMEGALOG primary key (ID);

--CREATE GLO_PCK_DBMEGA
create or replace package GLO_PCK_DBMEGA is

  procedure P_VerificaIndiceFK(pTablespace varchar2 default null);
  
  procedure P_ExecutaIndiceFK(pStatus char default 'P');
end GLO_PCK_DBMEGA;
/
create or replace package body GLO_PCK_DBMEGA is

  procedure P_InsereIndiceFK(pDBI_ST_OWNERFK in varchar2
                            ,pDBI_ST_TABELAFK  in varchar2
                            ,pID_DBMEGAINDICETAB in number
                            ,pDBI_ST_NOMEINDICE in varchar2
                            ,pDBI_CH_STATUS in char
                            ,pDBI_ST_COMANDO in varchar2 default null) is
  begin
    merge into GLO_DBMEGAINDICE IDX
    using (select pDBI_ST_OWNERFK  DBI_ST_OWNERFK
                 ,pDBI_ST_TABELAFK DBI_ST_TABELAFK
                 ,pDBI_ST_NOMEINDICE DBI_ST_NOMEINDICE
             from DUAL) D
    on ((IDX.DBI_ST_OWNERFK = D.DBI_ST_OWNERFK and IDX.DBI_ST_TABELAFK = D.DBI_ST_TABELAFK and IDX.DBI_ST_NOMEINDICE = D.DBI_ST_NOMEINDICE))  
    when matched then
      update
         set DBI_CH_STATUS     = pDBI_CH_STATUS
            ,DBI_ST_COMANDO    = nvl(pDBI_ST_COMANDO,DBI_ST_COMANDO)
    when not matched then
      insert
        (ID
        ,DBI_ST_OWNERFK
        ,DBI_ST_TABELAFK
        ,ID_DBMEGAINDICETAB
        ,DBI_ST_NOMEINDICE
        ,DBI_CH_STATUS
        ,DBI_ST_COMANDO)
      values
        (GLO_SEQ_DBMEGAINDICE.NEXTVAL
        ,pDBI_ST_OWNERFK
        ,pDBI_ST_TABELAFK
        ,pID_DBMEGAINDICETAB
        ,pDBI_ST_NOMEINDICE
        ,pDBI_CH_STATUS
        ,pDBI_ST_COMANDO);
  end;
  
  procedure P_InsereLog(pID_DBMEGA in number
                       ,pDBL_CH_STATUS in char
                       ,pDBL_CL_MENSAGEM in clob) is
  begin
    insert into GLO_DBMEGALOG
      (ID
      ,ID_DBMEGA
      ,DBL_DT_DATA
      ,DBL_CH_STATUS
      ,DBL_CL_MENSAGEM)
    values
      (GLO_SEQ_DBMEGALOG.NEXTVAL
      ,pID_DBMEGA
      ,sysdate
      ,pDBL_CH_STATUS
      ,pDBL_CL_MENSAGEM);
  end;

  procedure P_VerificaIndiceFK(pTablespace varchar2 default null) is
    vFKColunas varchar2(2000);
    vIDXColunas varchar2(2000);
    vIDXNomeCriado varchar2(255);
    vIDXOwnerCriado varchar2(255);
    vTabelaSemIndice boolean default true;
    vACHOU boolean default false;
    vComando varchar2(4000);
    vIDXNovoIndice varchar2(255);
    vIDXTablespace varchar2(255);
  begin
    vIDXTablespace := pTablespace;
    for CrTabela in
    (
      select FKREF.OWNER
            ,FKREF.TABLE_NAME
            ,FKREF.CONSTRAINT_NAME
            ,DBM.ID
        from ALL_CONSTRAINTS FKREF
       inner join ALL_CONSTRAINTS PK
          on (PK.CONSTRAINT_NAME = FKREF.R_CONSTRAINT_NAME and PK.OWNER = FKREF.R_OWNER)
       inner join GLO_DBMEGAINDICETAB DBM
          on (UPPER(DBM.DBIT_ST_OWNER) = PK.OWNER and UPPER(DBM.DBIT_ST_TABELA) = PK.TABLE_NAME)
       where FKREF.CONSTRAINT_TYPE = 'R' --R (referential integrity)
         and PK.CONSTRAINT_TYPE = 'P' --P (primary key)
       order by FKREF.OWNER
               ,FKREF.TABLE_NAME
    )
    loop
      vFKColunas := '';
      for CrFKColunas in
      (
        select C.COLUMN_NAME || ',' FKColunas
          from ALL_CONS_COLUMNS C
         where C.CONSTRAINT_NAME = CrTabela.CONSTRAINT_NAME
           and C.OWNER = CrTabela.OWNER
         order by C.POSITION
      )
      loop
        vFKColunas := vFKColunas || CrFKColunas.FKColunas;
      end loop;
      vFKColunas := SUBSTR(vFKColunas, 1, LENGTH(vFKColunas) - 1);--Retira ltima virgula

      vTabelaSemIndice := true;
      vACHOU := false;
      for CrIndice in
      (
        select I.INDEX_NAME
              ,I.OWNER
              ,I.TABLE_NAME
              ,I.TABLE_OWNER
          from ALL_INDEXES I
         where I.TABLE_NAME = CrTabela.TABLE_NAME
           and I.TABLE_OWNER = CrTabela.OWNER
      )
      loop
        vIDXColunas := '';
        vTabelaSemIndice := false;

        for CrIDXColunas in
        (
          select I.COLUMN_NAME || ',' IDXColunas
            from ALL_IND_COLUMNS I
           where I.INDEX_NAME = CrIndice.INDEX_NAME
             and I.INDEX_OWNER = CrIndice.OWNER
           order by I.COLUMN_POSITION
        )
        loop
          vIDXColunas := vIDXColunas || CrIDXColunas.IDXColunas;
        end loop;
        vIDXColunas := SUBSTR(vIDXColunas, 1, LENGTH(vIDXColunas) - 1);--Retira ltima virgula

        if vFKColunas <> vIDXColunas then
          vACHOU := false;
        else
          vIDXNomeCriado := CrIndice.INDEX_NAME;
          vIDXOwnerCriado := CrIndice.OWNER;
          vACHOU := true;
          exit;
        end if;
      end loop;
      
      vComando := null;
      if vTabelaSemIndice or not(vACHOU) then
        vIDXNovoIndice := CRTABELA.CONSTRAINT_NAME;

        vComando := 'CREATE INDEX '||CrTabela.OWNER||'.'||vIDXNovoIndice||' ON '||CrTabela.OWNER||'.'||CrTabela.TABLE_NAME ||'('||vFKColunas||')';
        if vIDXTablespace is not null then
          vComando := vComando ||' compute statistics tablespace '||vIDXTablespace;
        else
          vComando := vComando ||' compute statistics';
        end if;
        P_InsereIndiceFK(CrTabela.OWNER
                        ,CrTabela.TABLE_NAME 
                        ,CrTabela.ID
                        ,vIDXNovoIndice
                        ,'P'
                        ,vComando);
      elsif vACHOU then
        P_InsereIndiceFK(CrTabela.OWNER
                        ,CrTabela.TABLE_NAME 
                        ,CrTabela.ID
                        ,vIDXNomeCriado
                        ,'O'
                        ,vComando);
      end if;
    end loop;
  end;
  
  procedure P_ExecutaIndiceFK(pStatus char default 'P') is
    vColunaIndexada exception;
    vNomeUtilizado exception;
    pragma exception_init(vColunaIndexada, -1408); --ORA-01408: esta lista de colunas j est indexada]
    pragma exception_init(vNomeUtilizado, -955); --ORA-00955: o nome j est a ser utilizado por um objeto existente
  begin
    for CrIndices in
    (
      select IDX.ID
            ,IDX.DBI_ST_COMANDO
            ,IDX.DBI_ST_OWNERFK||'.'||IDX.DBI_ST_NOMEINDICE NOMEINDICE
        from GLO_DBMEGAINDICE IDX
       where IDX.DBI_CH_STATUS = pStatus
       order by IDX.ID
    )
    loop
      begin
        execute immediate CrIndices.DBI_ST_COMANDO;
        
        begin
          update GLO_DBMEGAINDICE I
             set I.DBI_CH_STATUS = 'O'
           where I.ID = CrIndices.ID;

          P_InsereLog(CrIndices.ID
                     ,'O'
                     ,'ndice criado com Sucesso.');
        exception
          when others then
            update GLO_DBMEGAINDICE I
               set I.DBI_CH_STATUS = 'E'
             where I.ID = CrIndices.ID;
            P_InsereLog(CrIndices.ID
                       ,'E'
                       ,'Erro ao atualizar o status do ndice '||CrIndices.NOMEINDICE||'.'||CHR(13)||'Erro: '||sqlerrm);
        end;
      exception
        when vNomeUtilizado then
          update GLO_DBMEGAINDICE I
             set I.DBI_CH_STATUS = 'E'
           where I.ID = CrIndices.ID;
          P_InsereLog(CrIndices.ID
                     ,'E'
                     ,'Nome j utilizado por outro objeto existente.');
        when vColunaIndexada then
          update GLO_DBMEGAINDICE I
             set I.DBI_CH_STATUS = 'A'
           where I.ID = CrIndices.ID;
          P_InsereLog(CrIndices.ID
                     ,'A'
                     ,'Esta lista de colunas j est indexada.');
        when others then
          update GLO_DBMEGAINDICE I
             set I.DBI_CH_STATUS = 'E'
           where I.ID = CrIndices.ID;
          P_InsereLog(CrIndices.ID
                     ,'E'
                     ,'Erro ao criar o ndice '||CrIndices.NOMEINDICE||'.'||CHR(13)||'Erro: '||sqlerrm);
      end;
    end loop;  
  end;
begin
  null;
end GLO_PCK_DBMEGA;
/

-- CREATE SEQUENCES

create sequence GLO_SEQ_DBMEGAINDICE
minvalue 1
maxvalue 9999999999
start with 1
increment by 1
nocache;

create sequence GLO_SEQ_DBMEGAINDICETAB
minvalue 1
maxvalue 9999999999
start with 1
increment by 1
nocache;

create sequence GLO_SEQ_DBMEGALOG
minvalue 1
maxvalue 9999999999
start with 1
increment by 1
nocache;

-- INSERT

insert into GLO_DBMEGAINDICETAB
  (ID
  ,DBIT_ST_OWNER
  ,DBIT_ST_TABELA)
values
  (GLO_SEQ_DBMEGAINDICETAB.NEXTVAL
  ,'MGADM'
  ,'EST_MOVSUMARIZADO');
insert into GLO_DBMEGAINDICETAB
  (ID
  ,DBIT_ST_OWNER
  ,DBIT_ST_TABELA)
values
  (GLO_SEQ_DBMEGAINDICETAB.NEXTVAL
  ,'MGADM'
  ,'EST_LOTESMOVIMENTO');
insert into GLO_DBMEGAINDICETAB
  (ID
  ,DBIT_ST_OWNER
  ,DBIT_ST_TABELA)
values
  (GLO_SEQ_DBMEGAINDICETAB.NEXTVAL
  ,'MGADM'
  ,'EST_MOVIMENTO');
insert into GLO_DBMEGAINDICETAB
  (ID
  ,DBIT_ST_OWNER
  ,DBIT_ST_TABELA)
values
  (GLO_SEQ_DBMEGAINDICETAB.NEXTVAL
  ,'MGADM'
  ,'EST_PRODUTOS');
insert into GLO_DBMEGAINDICETAB
  (ID
  ,DBIT_ST_OWNER
  ,DBIT_ST_TABELA)
values
  (GLO_SEQ_DBMEGAINDICETAB.NEXTVAL
  ,'MGCON'
  ,'CON_LANCAMENTO');
insert into GLO_DBMEGAINDICETAB
  (ID
  ,DBIT_ST_OWNER
  ,DBIT_ST_TABELA)
values
  (GLO_SEQ_DBMEGAINDICETAB.NEXTVAL
  ,'MGFIN'
  ,'FIN_FATURAPAGAR');
insert into GLO_DBMEGAINDICETAB
  (ID
  ,DBIT_ST_OWNER
  ,DBIT_ST_TABELA)
values
  (GLO_SEQ_DBMEGAINDICETAB.NEXTVAL
  ,'MGFIN'
  ,'FIN_OCORRENCIA');
insert into GLO_DBMEGAINDICETAB
  (ID
  ,DBIT_ST_OWNER
  ,DBIT_ST_TABELA)
values
  (GLO_SEQ_DBMEGAINDICETAB.NEXTVAL
  ,'MGFIN'
  ,'FIN_MOVIMENTO');
insert into GLO_DBMEGAINDICETAB
  (ID
  ,DBIT_ST_OWNER
  ,DBIT_ST_TABELA)
values
  (GLO_SEQ_DBMEGAINDICETAB.NEXTVAL
  ,'MGFIN'
  ,'FIN_FATURARECEBER');
insert into GLO_DBMEGAINDICETAB
  (ID
  ,DBIT_ST_OWNER
  ,DBIT_ST_TABELA)
values
  (GLO_SEQ_DBMEGAINDICETAB.NEXTVAL
  ,'MGGLO'
  ,'GLO_ACAOMOVIMENTO');