/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.servlet;

import com.senior.formcenter.servlet.util.ResponseHandler;
import com.senior.http.AbstractSeniortoolsServlet;
import com.senior.resource.IResourceId;
import com.senior.resource.ResourceManager;
import com.senior.util.MimeTypeUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerServlet
extends AbstractSeniortoolsServlet {
    private static final Logger logger = LoggerFactory.getLogger(ResourceManagerServlet.class);

    protected void innerService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getPathInfo();
        if (uri == null) {
            response.sendError(404);
            return;
        }
        IResourceId resourceId = ResourceManager.getResourceId((String)(uri = uri.replace("/", " ").trim()));
        if (resourceId == null) {
            response.sendError(404, "Recurso n\u00e3o encontrado.");
            if (logger.isDebugEnabled()) {
                logger.debug("Resource not found: " + uri);
            }
        } else if (resourceId.allowAccess()) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream input = ResourceManager.getResourceStream((String)uri);){
                String resourceType = resourceId.getResourceType();
                resourceType = resourceType == null ? MimeTypeUtils.getMimeTypeByFileName((String)resourceId.getUniqueKey()) : resourceType;
                ResponseHandler.sendData(response, resourceType, resourceId.getResourceLifeTime(), false, input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Send resource -> " + resourceId.getUniqueKey());
            }
        } else {
            response.sendError(403, "Sem permiss\u00e3o de acesso ao arquivo.");
            if (logger.isDebugEnabled()) {
                logger.debug("Forbidden access :" + resourceId.getUniqueKey());
            }
        }
    }
}

