/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.servlet;

import com.senior.ui.core.IIOProcessor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOProcessorHelper
implements HttpSessionListener {
    public static final String RENDERER_HEADER = "renderer";
    public static final String EXT3_RENDERER = "ext3";
    public static final String LOCAL_RENDERER = "local";
    private static final String CURRENT_RENDERER = "current_renderer";
    private static final Logger LOGGER = LoggerFactory.getLogger(IOProcessorHelper.class);

    public static IIOProcessor getIOProcessor(HttpServletRequest request) {
        HttpSession session = request.getSession();
        IIOProcessor iop = (IIOProcessor)session.getAttribute(CURRENT_RENDERER);
        if (iop == null) {
            String renderer = request.getHeader(RENDERER_HEADER);
            String className = LOCAL_RENDERER.equals(renderer) ? RendererRegistry.LOCAL.getRendererClass() : RendererRegistry.EXT3.getRendererClass();
            try {
                Class<?> localClass = Class.forName(className);
                iop = (IIOProcessor)localClass.getConstructor(String.class).newInstance(request.getSession().getId());
                session.setAttribute(CURRENT_RENDERER, (Object)iop);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return iop;
    }

    public void sessionCreated(HttpSessionEvent sessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        LOGGER.debug("HTTP session has been destroyed.");
        HttpSession session = sessionEvent.getSession();
        IIOProcessor processor = (IIOProcessor)session.getAttribute(CURRENT_RENDERER);
        if (processor == null) {
            LOGGER.debug("There wasn't an IIOProcessor in session being destroyed.");
            return;
        }
        processor.handleSessionDestruction();
        session.removeAttribute(CURRENT_RENDERER);
    }

    public static enum RendererRegistry {
        EXT3("com.senior.ui.ext.ExtIOProcessor"),
        LOCAL("com.senior.ui.test.local.renderer.LocalIOProcessor");

        private final String rendererClass;

        private RendererRegistry(String className) {
            this.rendererClass = className;
        }

        public String getRendererClass() {
            return this.rendererClass;
        }
    }
}

