/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.profiler;

import com.senior.formcenter.profiler.ProfilerEvents;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class XmlProfilerParser {
    XmlProfilerParser() {
    }

    public static List<ProfilerEvents> parse(String xml) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        XMLStreamReader xmlStreamReader = null;
        ArrayList<ProfilerEvents> listEvents = new ArrayList<ProfilerEvents>();
        ProfilerEvents eventTemp = new ProfilerEvents();
        try {
            xmlStreamReader = xmlInputFactory.createXMLStreamReader(new ByteArrayInputStream(xml.getBytes(Charset.defaultCharset().name())));
            xmlStreamReader.nextTag();
            while (xmlStreamReader.hasNext()) {
                String name = xmlStreamReader.getName().toString().toUpperCase();
                if (xmlStreamReader.isStartElement()) {
                    Tag tag = Tag.valueOf(name);
                    switch (tag) {
                        case EVENTS: {
                            break;
                        }
                        case EVENT: {
                            eventTemp.setType(xmlStreamReader.getAttributeValue(0));
                            break;
                        }
                        case DESCRIPTION: {
                            xmlStreamReader.next();
                            eventTemp.setDescription(xmlStreamReader.getText());
                            break;
                        }
                        case BLOCK: {
                            xmlStreamReader.next();
                            int block = Integer.parseInt(xmlStreamReader.getText());
                            eventTemp.setBlock(block);
                            break;
                        }
                        case TIME: {
                            xmlStreamReader.next();
                            long time = Long.parseLong(xmlStreamReader.getText());
                            eventTemp.setTime(time);
                            break;
                        }
                    }
                } else if (xmlStreamReader.isEndElement() && name.equals(Tag.EVENT.toString())) {
                    listEvents.add(eventTemp);
                    eventTemp = new ProfilerEvents();
                }
                xmlStreamReader.next();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return listEvents;
    }

    private static enum Tag {
        EVENTS,
        EVENT,
        DESCRIPTION,
        BLOCK,
        TIME;

    }
}

