/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.profiler;

import com.senior.formcenter.profiler.MemoryTestHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MemoryUse {
    private final List<Long> captures = new ArrayList<Long>();
    private final boolean saveHistory;
    private final MemoryReaderType typeReader;
    private final String processName;

    public MemoryUse(boolean saveHistory, MemoryReaderType type, String processName) {
        this.saveHistory = saveHistory;
        this.typeReader = type;
        this.processName = processName;
    }

    public long captureMemory() {
        long value = 0L;
        value = this.typeReader == MemoryReaderType.SERVER ? MemoryTestHelper.getVmMemory() : MemoryTestHelper.getProcessMemory(this.processName) * 1024L;
        if (this.saveHistory) {
            this.captures.add(value);
        }
        return value;
    }

    public long average() {
        long average = 0L;
        if (!this.captures.isEmpty()) {
            for (Long mark : this.captures) {
                average += mark.longValue();
            }
            average /= (long)this.captures.size();
        }
        return average;
    }

    public long maxCapture() {
        long media = -1L;
        if (!this.captures.isEmpty()) {
            for (Long mark : this.captures) {
                if (media >= mark) continue;
                media = mark;
            }
        }
        return media;
    }

    public long minCapture() {
        long media = 0L;
        if (!this.captures.isEmpty()) {
            for (Long mark : this.captures) {
                if (media > mark) {
                    media = mark;
                }
                if (media != 0L) continue;
                media = mark;
            }
        }
        return media;
    }

    public long diferenceLastInterval() {
        long diference = 0L;
        int size = this.captures.size();
        if (size >= 2) {
            Long first = this.captures.get(size - 2);
            Long last = this.captures.get(size - 1);
            diference = last - first;
        }
        return diference;
    }

    public long diferenceFirstLastInterval() {
        long diference = 0L;
        int size = this.captures.size();
        if (size >= 2) {
            Long first = this.captures.get(0);
            Long last = this.captures.get(size - 1);
            diference = last - first;
        }
        return diference;
    }

    public List<Long> getCaptures() {
        return Collections.unmodifiableList(this.captures);
    }

    public void clearCaptures() {
        this.captures.clear();
    }

    public void putManualCapture(Long memory) {
        this.captures.add(memory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("averageOfAllSnapshot: " + ConvertBytesHelper.convertToKB(this.average()) + " kb\n");
        sb.append("diferenceLastInterval: " + ConvertBytesHelper.convertToKB(this.diferenceLastInterval()) + " kb\n");
        sb.append("diferenceFirstLastInterval: " + ConvertBytesHelper.convertToKB(this.diferenceFirstLastInterval()) + " kb\n");
        sb.append("m\u00e1ximo: " + ConvertBytesHelper.convertToKB(this.maxCapture()) + " kb\n");
        sb.append("min\u00edmo: " + ConvertBytesHelper.convertToKB(this.minCapture()) + " kb\n");
        sb.append("Marca\u00e7\u00f5es:\n");
        for (long snapshot : this.getCaptures()) {
            sb.append(String.valueOf(ConvertBytesHelper.convertToKB(snapshot)) + " kb\n");
        }
        return sb.toString();
    }

    public static class ConvertBytesHelper {
        public static long convertToKB(long valueBytes) {
            return valueBytes / 1024L;
        }

        public static long convertToMB(long valueBytes) {
            return valueBytes / 1024L / 1024L;
        }

        public static long convertToGB(long valueBytes) {
            return valueBytes / 1024L / 1024L / 1024L;
        }
    }

    public static enum MemoryReaderType {
        SERVER,
        CLIENT;

    }
}

