/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.profiler;

import com.senior.formcenter.profiler.ProfilerEvents;
import com.senior.formcenter.profiler.XmlProfilerParser;
import com.senior.profiler.IProfiler;
import com.senior.profiler.ProfilerManager;
import com.senior.profiler.ProfilerManagerConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FormcenterProfilerServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormcenterProfilerServlet.class);
    private static final long serialVersionUID = 13246454212106541L;
    private static final String THREAD_PROFILER_CLIENT = "ThreadProfiler";
    private static final String NAME_PROFILER_CLIENT = "ProfilerClient";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletOutputStream out = resp.getOutputStream();
        try {
            String profileAction = req.getParameter("action");
            if (profileAction != null) {
                if (profileAction.equals("start")) {
                    ProfilerManager.start();
                    out.print("Profiler started.");
                    return;
                } else if (profileAction.equals("stop")) {
                    ProfilerManager.stop();
                    out.print("Profiler stoped.");
                    return;
                } else if (profileAction.equals("profilerFile")) {
                    out.print(ProfilerManagerConfiguration.getDefault().getOutputFile().getAbsolutePath());
                    return;
                } else {
                    out.print("Action " + profileAction + " is unknown.");
                }
                return;
            }
            if (!ProfilerManager.isEnabled()) {
                out.print("Profiler is disabled.");
                return;
            }
            String xml = req.getParameter("xmlData");
            if (xml == null) {
                out.print("xmlData parameter is NULL.");
                return;
            }
            try {
                List<ProfilerEvents> listEvents = XmlProfilerParser.parse(xml);
                FormcenterProfilerServlet.createProfiler(listEvents);
                out.print("ok");
                return;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                out.println("error");
                out.print(e.getMessage());
            }
            return;
        }
        finally {
            resp.setStatus(200);
            resp.flushBuffer();
            resp.getOutputStream().close();
        }
    }

    private static void createProfiler(List<ProfilerEvents> events) {
        IProfiler currentProfiler = ProfilerManager.profiler((String)NAME_PROFILER_CLIENT, (boolean)true, (String)THREAD_PROFILER_CLIENT);
        Stack<Integer> listBlock = new Stack<Integer>();
        for (ProfilerEvents event : events) {
            EventType eventType = EventType.valueOf(event.getType().toUpperCase());
            switch (eventType) {
                case START: {
                    int block = currentProfiler.start((Object)event.getDescription(), event.getTime());
                    listBlock.push(block);
                    break;
                }
                case STEP: {
                    currentProfiler.step(((Integer)listBlock.lastElement()).intValue(), event.getDescription(), event.getTime());
                    break;
                }
                case STOP: {
                    int block = (Integer)listBlock.pop();
                    currentProfiler.stop(block, event.getTime());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Evento de profiler inv\u00e1lido.");
                }
            }
        }
    }

    private static enum EventType {
        START,
        STOP,
        STEP;

    }
}

