/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.processor;

import com.senior.resource.FileUploadManager;
import com.senior.ui.core.UploadFileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.Normalizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public final class UploadHelper {
    private static final String UTF_8 = "UTF-8";

    public static UploadFileDescriptor getUploadFileDescriptor(HttpServletRequest request) {
        boolean isMultipart;
        String perspectiveId = request.getParameter("perspectiveId");
        String fileName = request.getParameter("upload");
        if (fileName != null) {
            try {
                fileName = Normalizer.normalize(URLDecoder.decode(fileName, UTF_8), Normalizer.Form.NFC);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ServletFileUpload upload = new ServletFileUpload();
            try {
                upload.setHeaderEncoding(UTF_8);
                FileItemIterator itemsIter = upload.getItemIterator(request);
                while (itemsIter.hasNext()) {
                    FileItemStream item = itemsIter.next();
                    if (item.isFormField()) continue;
                    InputStream stream = item.openStream();
                    if (fileName == null) {
                        fileName = item.getFieldName() != null ? item.getFieldName() : item.getName();
                    }
                    UploadHelper.storeFile(perspectiveId, fileName, stream);
                }
            }
            catch (FileUploadException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        UploadFileDescriptor uploadFileDescritor = new UploadFileDescriptor(perspectiveId, fileName);
        return uploadFileDescritor;
    }

    private static void storeFile(String perspectiveId, String fileName, InputStream stream) {
        try {
            FileUploadManager.storeFile((String)perspectiveId, (String)fileName, (InputStream)stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

