/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.error;

import com.senior.containeradapter.ContainerAdapterFactory;
import com.senior.containeradapter.HTTPErrorKind;
import com.senior.formcenter.processor.HttpRequestDescriptor;
import com.senior.formcenter.servlet.IOProcessorHelper;
import com.senior.ui.core.IIOProcessor;
import com.senior.ui.core.IRequestDescriptor;
import com.senior.ui.core.RequestProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public final class ErrorPageHandler
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(ErrorPageHandler.class.getName());
    private static final String ERROR_PAGE_TITLE = "Relat\u00f3rio de erro";
    private static final String SERVER_TOO_MANY_ACTIVE_SESSIONS = "O sistema est\u00e1 sobrecarregado. Por favor tente novamente mais tarde.";
    private static final long serialVersionUID = 1L;
    private static SoftReference<IIOProcessor> ioProcessor = new SoftReference<Object>(null);

    protected void service(HttpServletRequest request, HttpServletResponse response) {
        ErrorPageHandler.handlerRequest(request, response);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        ErrorPageHandler.handlerRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        ErrorPageHandler.handlerRequest(req, resp);
    }

    private static void handlerRequest(HttpServletRequest request, HttpServletResponse response) {
        ErrorPageHandler.renderCriticalErrorPage(request, response);
    }

    private static void renderCriticalErrorPage(HttpServletRequest request, HttpServletResponse response) {
        Throwable throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        String errorMessage = (String)request.getAttribute("javax.servlet.error.message");
        ErrorPageHandler.logError(errorMessage, throwable);
        HashMap<String, Object> parameters = new HashMap<String, Object>(4, 1.0f);
        parameters.put(RequestProperties.TITLE.name(), ERROR_PAGE_TITLE);
        HTTPErrorKind errorKind = ContainerAdapterFactory.getContainerAdapter().getErrorKind(throwable);
        switch (errorKind) {
            case SERVER_OVERLOADED: {
                parameters.put(RequestProperties.MESSAGE_TITLE.name(), SERVER_TOO_MANY_ACTIVE_SESSIONS);
                statusCode = 503;
                break;
            }
            default: {
                parameters.put(RequestProperties.MESSAGE_TITLE.name(), StringUtils.trimToEmpty((String)errorMessage));
            }
        }
        String message = errorMessage;
        if (throwable != null) {
            message = throwable.getMessage();
        }
        parameters.put(RequestProperties.MESSAGE.name(), message);
        parameters.put(RequestProperties.STATUS_CODE.name(), String.valueOf(statusCode));
        try {
            response.setHeader("Content-Type", "text/html; charset=iso-8859-1");
            response.setStatus(statusCode.intValue());
            ErrorPageHandler.getIOProcessor(request).handleError((IRequestDescriptor)new HttpRequestDescriptor(request, parameters), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void logError(String errorMessage, Throwable throwable) {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            StringBuilder sbMessage = new StringBuilder();
            if (StringUtils.isNotBlank((String)errorMessage)) {
                sbMessage.append(errorMessage);
            }
            if (throwable != null) {
                if (sbMessage.length() != 0) {
                    sbMessage.append(throwable.getMessage());
                }
                sbMessage.append(", Stack: ").append(ErrorPageHandler.exceptionToString(throwable));
            }
            LOGGER.severe(sbMessage.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IIOProcessor getIOProcessor(HttpServletRequest request) {
        IIOProcessor instance = ioProcessor.get();
        if (instance == null) {
            SoftReference<IIOProcessor> softReference = ioProcessor;
            synchronized (softReference) {
                instance = ioProcessor.get();
                if (instance == null) {
                    instance = ErrorPageHandler.newIoProcessor(request);
                    ioProcessor = new SoftReference<IIOProcessor>(instance);
                    return instance;
                }
            }
        }
        return instance;
    }

    private static IIOProcessor newIoProcessor(HttpServletRequest request) {
        String renderer = request.getHeader("renderer");
        String className = "local".equals(renderer) ? IOProcessorHelper.RendererRegistry.LOCAL.getRendererClass() : IOProcessorHelper.RendererRegistry.EXT3.getRendererClass();
        try {
            Class<?> localClass = Class.forName(className);
            IIOProcessor instance = (IIOProcessor)localClass.getConstructor(String.class).newInstance("IIOProcessorError");
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static String exceptionToString(Throwable exception) {
        if (exception != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter((Writer)writer, true);
            exception.printStackTrace(printer);
            printer.flush();
            writer.flush();
            return writer.toString();
        }
        return "";
    }
}

