/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.servlet.util;

import com.senior.util.MimeTypeUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseHandler.class);

    public static boolean sendData(HttpServletResponse response, String contentType, LocalDateTime deadLineTime, boolean download, InputStream data) {
        return ResponseHandler.sendData(response, contentType, deadLineTime, download, data, null);
    }

    /*
     * Loose catch block
     */
    public static boolean sendData(HttpServletResponse response, String contentType, LocalDateTime deadLineTime, boolean download, InputStream data, String fileName) {
        LocalDateTime start;
        if (contentType != null) {
            response.setContentType(contentType);
        }
        if (download) {
            String fileExtension;
            if (fileName == null && (fileExtension = MimeTypeUtils.getFileExtension((String)contentType)) != null) {
                fileName = "download.".concat(fileExtension);
            }
            if (contentType == null) {
                String contentTypeOf = MimeTypeUtils.getMimeTypeByFileName((String)fileName);
                if (contentTypeOf == null) {
                    contentTypeOf = "application/octet-stream";
                }
                response.setContentType(contentTypeOf);
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            response.setHeader("filename", fileName);
        }
        if (deadLineTime != null && (start = new LocalDateTime()).compareTo((ReadablePartial)deadLineTime) < 0) {
            long time = Seconds.secondsBetween((ReadablePartial)start, (ReadablePartial)deadLineTime).getSeconds();
            response.setHeader("Cache-Control", "max-age=".concat(Long.toString(time)));
        }
        ServletOutputStream out = null;
        out = response.getOutputStream();
        byte[] b = new byte[2048];
        int read = -1;
        while ((read = data.read(b)) != -1) {
            out.write(b, 0, read);
        }
        out.flush();
        try {
            data.close();
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException e) {
            try {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    data.close();
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                data.close();
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }
}

