/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.profiler;

import com.senior.FrameworkProperty;
import com.senior.profiler.IProfiler;
import com.senior.util.CurrentTime;
import com.senior.util.PendingImplementationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteProfilerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteProfilerHelper.class);
    private final String baseUrl;
    public static final String PERFORMANCE_PROFILER = "com.senior.formcenter.performance";
    public static final String CLIENT = "client";
    public static final String SERVER = "server";
    private final Map<String, IProfiler> profilers = new HashMap<String, IProfiler>();

    public RemoteProfilerHelper() {
        this(FrameworkProperty.PROFILER_REMOTE_URL.get());
    }

    public RemoteProfilerHelper(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void startProfiler() {
        String data = "action=start";
        this.sendRequest(data);
    }

    public void stopProfiler() {
        String data = "action=stop";
        this.sendRequest(data);
    }

    public String profileFile() {
        String data = "action=profilerFile";
        return this.sendRequest(data).replace("\\", "/");
    }

    public IProfiler profiler(String name) {
        IProfiler profiler = this.profilers.get(name);
        if (profiler != null) {
            return profiler;
        }
        profiler = new InternalProfiler(name);
        this.profilers.put(name, profiler);
        return profiler;
    }

    private String sendRequest(String data) {
        StringBuilder sb = new StringBuilder();
        try {
            URL url = new URL(this.baseUrl);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            Throwable throwable = null;
            Object var6_9 = null;
            try (OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());){
                wr.write(data);
                wr.flush();
                Throwable throwable2 = null;
                Object var9_14 = null;
                try (BufferedReader buf = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String line = null;
                    String newLine = "";
                    while ((line = buf.readLine()) != null) {
                        LOGGER.info(line);
                        sb.append(newLine).append(line);
                        newLine = "\n";
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    private void sendProfilerData(InternalProfiler profiler) {
        String xmlData = RemoteProfilerHelper.buildXmlData(profiler);
        this.sendRequest(xmlData);
        profiler.getEventList().clear();
    }

    private static String buildXmlData(InternalProfiler profiler) {
        List<Object[]> evts = profiler.getEventList();
        StringBuilder sb = new StringBuilder();
        sb.append("xmlData=<events>");
        int block = 1000;
        for (Object[] event : evts) {
            sb.append("<event type= \"");
            sb.append(event[0]);
            sb.append("\">");
            sb.append("<description>");
            sb.append(event[1]);
            sb.append("</description>");
            sb.append("<block>");
            sb.append(++block);
            sb.append("</block>");
            sb.append("<time>");
            sb.append(event[2]);
            sb.append("</time>");
            sb.append("</event>");
        }
        sb.append("</events>");
        return sb.toString();
    }

    private static enum EventType {
        START,
        STEP,
        STOP,
        MESSAGE;

    }

    private class InternalProfiler
    implements IProfiler {
        private final List<Object[]> eventList = new ArrayList<Object[]>();
        private final List<Object> namesList = new ArrayList<Object>();
        private final String name;

        InternalProfiler(String name) {
            this.name = name;
        }

        List<Object[]> getEventList() {
            return this.eventList;
        }

        public boolean enabled() {
            return true;
        }

        public int getCode() {
            return 0;
        }

        public int getParamCode(Object param) {
            int index = this.namesList.indexOf(param);
            if (index != -1) {
                return index;
            }
            index = this.namesList.size();
            this.namesList.add(param);
            return index;
        }

        public int getWorkUnitCode(Object param) {
            return 0;
        }

        public int getStepCode(String step) {
            return 0;
        }

        public int start(Object ... args) {
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                sb.append(value);
                ++n2;
            }
            this.eventList.add(new Object[]{EventType.START, sb.toString(), CurrentTime.millis()});
            return this.getParamCode(sb.toString());
        }

        public int start(Object param, long time) {
            this.eventList.add(new Object[]{EventType.START, param, time});
            return this.getParamCode(param);
        }

        public int start(Object param, String step) {
            throw new PendingImplementationException();
        }

        public int start(int block) {
            if (this.namesList.get(block) == null) {
                throw new RuntimeException("Illegal parameter, there's no name associated with the key " + block);
            }
            this.eventList.add(new Object[]{EventType.START, this.name, CurrentTime.millis()});
            return block;
        }

        public int start(int param, int step) {
            throw new PendingImplementationException();
        }

        public int start(Object param, int step) {
            throw new PendingImplementationException();
        }

        public int start(int param, String step) {
            throw new PendingImplementationException();
        }

        public void stop(int block) {
            if (this.namesList.get(block) == null) {
                throw new RuntimeException("Illegal parameter, there's no name associated with the key " + block);
            }
            this.eventList.add(new Object[]{EventType.STOP, this.namesList.get(block), CurrentTime.millis()});
            RemoteProfilerHelper.this.sendProfilerData(this);
        }

        public void stop(int block, long time) {
            if (this.namesList.get(block) == null) {
                throw new RuntimeException("Illegal parameter, there's no name associated with the key " + block);
            }
            this.eventList.add(new Object[]{EventType.STOP, this.name, time});
            RemoteProfilerHelper.this.sendProfilerData(this);
        }

        public void step(int block, Object ... args) {
            StringBuilder sb;
            if (this.namesList.get(block) != null) {
                sb = new StringBuilder();
                Object[] objectArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    sb.append(value);
                    ++n2;
                }
            } else {
                throw new RuntimeException("Illegal parameter, there's no name associated with the key " + block);
            }
            this.eventList.add(new Object[]{EventType.STEP, sb.toString(), CurrentTime.millis()});
        }

        public void step(int block, String step, long time) {
            if (this.namesList.get(block) == null) {
                throw new RuntimeException("Illegal parameter, there's no name associated with the key " + block);
            }
            this.eventList.add(new Object[]{EventType.STEP, this.name, step, time});
        }

        public void step(int block, int step) {
            throw new PendingImplementationException();
        }

        public void message(Object message, boolean cache) {
            this.eventList.add(new Object[]{EventType.MESSAGE, message, CurrentTime.millis()});
        }

        public void message(int param, Object message, boolean cache) {
            throw new PendingImplementationException();
        }

        public void message(int param, int message) {
            throw new PendingImplementationException();
        }

        public void flag(int param, int flag) {
            throw new PendingImplementationException();
        }

        public boolean isActive() {
            throw new PendingImplementationException();
        }

        public void message(Object message, boolean cache, long time) {
            throw new PendingImplementationException();
        }
    }
}

