/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.profiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MemoryTestHelper {
    private static final String EXEC_COMMAND = "tasklist.exe /nh /v /fo csv";

    public static long getProcessMemory(String name) {
        Collection<Map<ProcessProperty, String>> processes = MemoryTestHelper.readProcesses();
        long memory = 0L;
        for (Map<ProcessProperty, String> map : processes) {
            if (!name.equals(map.get((Object)ProcessProperty.NAME))) continue;
            String mem = map.get((Object)ProcessProperty.MEMORY);
            try {
                memory += Long.parseLong(NumberFormat.getNumberInstance().parse(mem.substring(0, mem.length() - 2)).toString());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return memory;
    }

    public static long getVmMemory() {
        System.gc();
        long maxMemory = Runtime.getRuntime().maxMemory();
        long memory = (maxMemory == Long.MAX_VALUE ? Long.MAX_VALUE : maxMemory) - Runtime.getRuntime().freeMemory();
        return memory;
    }

    private static String parseValue(String value) {
        return value.substring(1, value.length() - 1);
    }

    private static Collection<Map<ProcessProperty, String>> readProcesses() {
        Process exec;
        ArrayList<Map<ProcessProperty, String>> processes = new ArrayList<Map<ProcessProperty, String>>();
        try {
            exec = Runtime.getRuntime().exec(EXEC_COMMAND);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(exec.getInputStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (StringUtils.isBlank((String)line)) continue;
                    EnumMap<ProcessProperty, String> map = new EnumMap<ProcessProperty, String>(ProcessProperty.class);
                    String[] properties = line.split(",");
                    map.put(ProcessProperty.NAME, MemoryTestHelper.parseValue(properties[0]));
                    map.put(ProcessProperty.PID, MemoryTestHelper.parseValue(properties[1]));
                    map.put(ProcessProperty.SESSION_NAME, MemoryTestHelper.parseValue(properties[2]));
                    map.put(ProcessProperty.SESSION, MemoryTestHelper.parseValue(properties[3]));
                    map.put(ProcessProperty.MEMORY, MemoryTestHelper.parseValue(properties[4]));
                    map.put(ProcessProperty.STATUS, MemoryTestHelper.parseValue(properties[5]));
                    map.put(ProcessProperty.USER, MemoryTestHelper.parseValue(properties[6]));
                    map.put(ProcessProperty.CPU_TIME, MemoryTestHelper.parseValue(properties[7]));
                    map.put(ProcessProperty.TITLE, MemoryTestHelper.parseValue(properties[8]));
                    processes.add(map);
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return processes;
    }

    public static enum ProcessProperty {
        NAME,
        PID,
        SESSION_NAME,
        SESSION,
        MEMORY,
        STATUS,
        USER,
        CPU_TIME,
        TITLE;

    }
}

