/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.processor;

import com.senior.formcenter.processor.HttpRequestDescriptor;
import com.senior.formcenter.servlet.IOProcessorHelper;
import com.senior.formcenter.servlet.util.ResponseHandler;
import com.senior.resource.IResourceId;
import com.senior.resource.ResourceManager;
import com.senior.ui.core.IHttpRequestDescriptor;
import com.senior.ui.core.IIOProcessor;
import com.senior.ui.core.IRequestDescriptor;
import com.senior.util.MimeTypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.joda.time.LocalDateTime;

public final class ResourcesProcessor {
    private static final String IGNORE_MAX_AGE = "ignoreMaxAge";
    private static final String SELENIUM_MODE_PARAMETER_SESSION = "seleniumMode";
    private static final String SELENIUM_MODE_PARAMETER_REQUEST = "selenium-mode";

    private ResourcesProcessor() {
    }

    public static void process(HttpServletRequest req, HttpServletResponse resp) {
        Object resExpirationTime;
        InputStream input;
        boolean isDownload;
        HttpSession session = req.getSession();
        HashMap<String, String> sessionAttributes = new HashMap<String, String>();
        Object seniorSession = session.getAttribute("seniorSession");
        if (seniorSession != null) {
            sessionAttributes.put("seniorSession", (String)seniorSession);
        }
        for (Map.Entry parameter : req.getParameterMap().entrySet()) {
            Map.Entry entry = parameter;
            Object parameterValue = entry.getValue();
            if (parameterValue == null) continue;
            sessionAttributes.put((String)entry.getKey(), ((String[])parameterValue)[0]);
        }
        boolean hasSeleniumModeParams = sessionAttributes.containsKey(SELENIUM_MODE_PARAMETER_REQUEST);
        HashMap<String, Object> parameters = new HashMap<String, Object>(hasSeleniumModeParams ? 2 : 1, 1.0f);
        String token = UUID.randomUUID().toString();
        session.setAttribute(token, sessionAttributes);
        parameters.put("seniorSession", token);
        if (hasSeleniumModeParams) {
            parameters.put(SELENIUM_MODE_PARAMETER_REQUEST, sessionAttributes.get(SELENIUM_MODE_PARAMETER_REQUEST));
        }
        HttpRequestDescriptor reqInfo = new HttpRequestDescriptor(req, parameters);
        HashMap<String, String> props = new HashMap<String, String>();
        String prop = req.getParameter("style");
        if (prop != null && prop.trim().length() > 0) {
            props.put("style", prop);
        }
        if ((prop = req.getParameter("debug")) != null && prop.trim().length() > 0) {
            props.put("debug", prop);
        }
        String contentType = null;
        String fileName = null;
        String download = req.getParameter("download");
        boolean bl = isDownload = download != null;
        if (isDownload) {
            IResourceId resourceId = ResourceManager.getResourceId((String)download);
            input = ResourceManager.getResourceStream((String)download);
            contentType = resourceId.getResourceType();
            fileName = resourceId.getResourceName();
            resExpirationTime = resourceId.getResourceLifeTime();
        } else {
            if (ResourcesProcessor.isRoot(reqInfo)) {
                String seleniumMode = String.valueOf(parameters.get(SELENIUM_MODE_PARAMETER_REQUEST));
                boolean isSeleniumMode = Boolean.parseBoolean(seleniumMode);
                if (isSeleniumMode) {
                    req.getSession().setAttribute(IGNORE_MAX_AGE, (Object)Boolean.TRUE);
                    req.getSession().setAttribute(SELENIUM_MODE_PARAMETER_SESSION, (Object)Boolean.valueOf(seleniumMode));
                } else if (req.getSession().getAttribute(SELENIUM_MODE_PARAMETER_SESSION) != null) {
                    parameters.put(SELENIUM_MODE_PARAMETER_REQUEST, req.getSession().getAttribute(SELENIUM_MODE_PARAMETER_SESSION));
                }
            }
            IIOProcessor processor = IOProcessorHelper.getIOProcessor(req);
            try {
                input = processor.getResourceManager().getResourceInputStream((IRequestDescriptor)reqInfo);
            }
            catch (IOException iOException) {
                try {
                    resp.sendError(404, "Resource not found: " + reqInfo.getRequestPath());
                    return;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if (!isDownload && (contentType = "/".equals(reqInfo.getRequestPath()) ? "text/html" : MimeTypeUtils.getMimeTypeByFileName((String)reqInfo.getRequestPath())) == null) {
            contentType = "application/octet-stream";
        }
        resExpirationTime = Boolean.TRUE.equals(req.getSession().getAttribute(IGNORE_MAX_AGE)) ? null : ("/".equals(reqInfo.getRequestPath()) ? null : new LocalDateTime().plusWeeks(2));
        ResponseHandler.sendData(resp, contentType, resExpirationTime, isDownload, input, fileName);
    }

    private static boolean isRoot(IHttpRequestDescriptor reqInfo) {
        return "/".equals(reqInfo.getRequestPath());
    }
}

