/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.processor;

import com.google.gson.JsonObject;
import com.senior.formcenter.processor.HttpRequestDescriptor;
import com.senior.formcenter.servlet.IOProcessorHelper;
import com.senior.security.IUser;
import com.senior.security.SecurityManagerProvider;
import com.senior.ui.core.FormcenterException;
import com.senior.ui.core.IHttpRequestDescriptor;
import com.senior.ui.core.IIOProcessor;
import com.senior.ui.core.IRequestDescriptor;
import com.senior.ui.core.PerspectiveAccessDeniedException;
import com.senior.ui.core.RequestProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestProcessor {
    private static final String MAX_INACTIVE_INTERVAL = "maxInactiveInterval";
    private static final String HTTP_CHAR_ENCODING = "ISO-8859-1";
    private static final String HTTP_CONTENT_TYPE = "text/html;charset=ISO-8859-1";
    static final String SENIOR_SESSION_KEY = "seniorSession";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestProcessor.class);
    private static Map<String, RequestCommand> commands = new ConcurrentHashMap<String, RequestCommand>();

    static {
        commands.put("authenticate", RequestCommand.AUTHENTICATE);
        commands.put("start", RequestCommand.START);
        commands.put("destroy", RequestCommand.DESTROY);
        commands.put("beforeDestroy", RequestCommand.BEFORE_DESTROY);
        commands.put("error", RequestCommand.ERROR);
        commands.put("upload", RequestCommand.UPLOAD);
        commands.put("logOff", RequestCommand.LOG_OFF);
    }

    private RequestProcessor() {
    }

    static RequestCommand getCommand(String requestType) {
        RequestCommand command = commands.get(requestType.replace("/", ""));
        if (command == null) {
            return RequestCommand.DEFAULT;
        }
        return command;
    }

    public static void process(HttpServletRequest request, HttpServletResponse response) {
        Object attribute;
        HttpSession session = request.getSession();
        Object seconds = session.getAttribute(MAX_INACTIVE_INTERVAL);
        if (seconds != null) {
            session.setMaxInactiveInterval(((Integer)seconds).intValue());
            session.removeAttribute(MAX_INACTIVE_INTERVAL);
        }
        Map requestParameters = request.getParameterMap();
        String token = request.getParameter(SENIOR_SESSION_KEY);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (token != null && (attribute = request.getSession().getAttribute(token)) != null) {
            ret.putAll((Map)attribute);
        }
        if (requestParameters != null) {
            for (Map.Entry entry : requestParameters.entrySet()) {
                ret.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
        }
        HttpRequestDescriptor reqInfo = new HttpRequestDescriptor(request, ret);
        try {
            RequestCommand requestCommand = RequestProcessor.getCommand(reqInfo.getRequestPath());
            response.setCharacterEncoding(HTTP_CHAR_ENCODING);
            response.setContentType(HTTP_CONTENT_TYPE);
            IIOProcessor processor = IOProcessorHelper.getIOProcessor(request);
            requestCommand.execute(reqInfo, processor, request, response, (OutputStream)response.getOutputStream());
        }
        catch (PerspectiveAccessDeniedException e) {
            RequestProcessor.handleError(request, response, requestParameters, "Acesso negado", e.getMessage(), e.getMessage(), 500);
            e.printStackTrace();
        }
        catch (FormcenterException e) {
            RequestProcessor.handleError(request, response, requestParameters, "Erro cr\u00edtico", "Relat\u00f3rio de erro: " + e.getMessage(), e.getMessage(), 500);
            e.printStackTrace();
        }
        catch (Exception exception) {
            RequestProcessor.handleError(request, response, requestParameters, "Erro cr\u00edtico", "Relat\u00f3rio de erro: " + exception.getMessage(), exception.getMessage(), 500);
            exception.printStackTrace();
        }
        catch (Error error) {
            throw error;
        }
    }

    private static void handleError(HttpServletRequest request, HttpServletResponse response, Map<String, String[]> requestParameters, String title, String titleMessage, String message, int statuCode) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(requestParameters.size() + 3, 1.0f);
        for (Map.Entry<String, String[]> entry : requestParameters.entrySet()) {
            if (entry.getValue().length == 1) {
                parameters.put(entry.getKey(), entry.getValue()[0]);
                continue;
            }
            throw new IllegalArgumentException("Unknow param: " + entry.getKey());
        }
        parameters.put(RequestProperties.TITLE.name(), StringUtils.trimToEmpty((String)title));
        parameters.put(RequestProperties.MESSAGE_TITLE.name(), StringUtils.trimToEmpty((String)titleMessage));
        parameters.put(RequestProperties.MESSAGE.name(), StringUtils.trimToEmpty((String)message));
        parameters.put(RequestProperties.STATUS_CODE.name(), String.valueOf(statuCode));
        try {
            IOProcessorHelper.getIOProcessor(request).handleError((IRequestDescriptor)new HttpRequestDescriptor(request, parameters), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String stackToString(Throwable error) {
        String detail = null;
        if (error == null) return detail;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                StringWriter writer = new StringWriter();
                try {
                    try (PrintWriter printWriter = new PrintWriter(writer);){
                        error.printStackTrace(printWriter);
                        printWriter.flush();
                        detail = writer.toString();
                    }
                    if (writer == null) return detail;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (writer == null) throw throwable;
                    writer.close();
                    throw throwable;
                }
                writer.close();
                return detail;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum RequestCommand {
        AUTHENTICATE{

            @Override
            void execute(IHttpRequestDescriptor requestDesc, IIOProcessor processor, HttpServletRequest request, HttpServletResponse response, OutputStream output) {
                String formId = request.getParameter("formId");
                StringBuilder redirectUrl = new StringBuilder();
                if ("".equals(request.getContextPath())) {
                    redirectUrl.append('/');
                } else {
                    redirectUrl.append(request.getContextPath());
                }
                if (!StringUtils.isBlank((String)formId)) {
                    if (formId.indexOf(63) == -1) {
                        redirectUrl.append('?');
                    }
                    redirectUrl.append(formId);
                }
                try {
                    response.sendRedirect(redirectUrl.toString().replaceAll("\n", " "));
                }
                catch (RuntimeException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                catch (Error error) {
                    throw error;
                }
            }
        }
        ,
        START{

            @Override
            void execute(IHttpRequestDescriptor requestDesc, IIOProcessor processor, HttpServletRequest request, HttpServletResponse response, OutputStream output) {
                processor.handlePerspectiveOpening((IRequestDescriptor)requestDesc, output);
            }
        }
        ,
        DESTROY{

            @Override
            void execute(IHttpRequestDescriptor requestDesc, IIOProcessor processor, HttpServletRequest request, HttpServletResponse response, OutputStream output) {
                String perspectiveId = (String)requestDesc.getParameter("perspective");
                if ("loginPage".equals(perspectiveId) || processor.handlePerspectiveClosing((IRequestDescriptor)requestDesc, output)) {
                    HttpSession session = request.getSession();
                    int time = session.getMaxInactiveInterval();
                    session.setAttribute(RequestProcessor.MAX_INACTIVE_INTERVAL, (Object)time);
                    session.setMaxInactiveInterval(10);
                }
            }
        }
        ,
        BEFORE_DESTROY{

            @Override
            void execute(IHttpRequestDescriptor requestDesc, IIOProcessor processor, HttpServletRequest request, HttpServletResponse response, OutputStream output) {
                processor.handlePerspectiveBeforeClose((IRequestDescriptor)requestDesc, output);
            }
        }
        ,
        ERROR{

            @Override
            void execute(IHttpRequestDescriptor requestDesc, IIOProcessor processor, HttpServletRequest request, HttpServletResponse response, OutputStream output) {
                processor.handleError((IRequestDescriptor)requestDesc, output);
            }
        }
        ,
        DEFAULT{

            @Override
            void execute(IHttpRequestDescriptor requestDesc, IIOProcessor processor, HttpServletRequest request, HttpServletResponse response, OutputStream output) {
                processor.handleDefaultInput((IRequestDescriptor)requestDesc, output);
            }
        }
        ,
        UPLOAD{

            @Override
            void execute(IHttpRequestDescriptor requestDesc, IIOProcessor processor, HttpServletRequest request, HttpServletResponse response, OutputStream output) {
                try {
                    processor.handleUpload((IRequestDescriptor)requestDesc, output);
                }
                catch (Throwable e) {
                    try {
                        ServletOutputStream outputStream = response.getOutputStream();
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.addProperty("errorMessage", e.getMessage());
                        jsonObject.addProperty("errorStack", RequestProcessor.stackToString(e));
                        PrintWriter printWriter = new PrintWriter((OutputStream)outputStream);
                        printWriter.write(jsonObject.toString());
                        printWriter.flush();
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                }
            }
        }
        ,
        LOG_OFF{

            @Override
            void execute(IHttpRequestDescriptor requestDesc, IIOProcessor processor, HttpServletRequest request, HttpServletResponse response, OutputStream output) {
                if (LOGGER.isDebugEnabled()) {
                    IUser currentUser = SecurityManagerProvider.getInstance().getCurrentUser();
                    LOGGER.debug("User {} is logging off.", (Object)(currentUser == null ? null : currentUser.getName()));
                }
                processor.handleSessionDestruction();
                request.getSession().invalidate();
            }
        };


        abstract void execute(IHttpRequestDescriptor var1, IIOProcessor var2, HttpServletRequest var3, HttpServletResponse var4, OutputStream var5);
    }
}

