/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.processor;

import com.senior.formcenter.processor.UploadHelper;
import com.senior.ui.core.IHttpRequestDescriptor;
import com.senior.ui.core.UploadFileDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HttpRequestDescriptor
implements IHttpRequestDescriptor {
    protected final HttpServletRequest request;
    private final Map<String, Object> parametersMap;

    public HttpRequestDescriptor(HttpServletRequest request, Map<String, Object> parametersMap) {
        this.request = request;
        this.parametersMap = new HashMap<String, Object>(parametersMap);
    }

    public HttpRequestDescriptor(HttpServletRequest request) {
        this.request = request;
        this.parametersMap = Collections.emptyMap();
    }

    public Object getHeaderParameter(Object key) {
        return this.request.getHeader(key.toString());
    }

    public Collection<String> getHeaderParametersKeys() {
        Enumeration names = this.request.getHeaderNames();
        ArrayList<String> listNames = new ArrayList<String>();
        while (names.hasMoreElements()) {
            listNames.add((String)names.nextElement());
        }
        return listNames;
    }

    public String getRequestPath() {
        return this.request.getPathInfo() != null ? this.request.getPathInfo() : this.request.getServletPath();
    }

    public Object getParameter(String key) {
        return this.parametersMap.get(key);
    }

    public Collection<String> getParametersKey() {
        return Collections.unmodifiableCollection(this.parametersMap.keySet());
    }

    public Map<String, Object> getParametersMap() {
        return Collections.unmodifiableMap(this.parametersMap);
    }

    public Map<String, Object> getModifiableParametersMap() {
        return this.parametersMap;
    }

    public UploadFileDescriptor getUpload() {
        return UploadHelper.getUploadFileDescriptor(this.request);
    }
}

