/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.auth;

import com.senior.FrameworkProperty;
import com.senior.formcenter.auth.AuthenticationKey;
import com.senior.formcenter.auth.AuthenticationState;
import com.senior.formcenter.auth.SubstituteUserKey;
import com.senior.formcenter.processor.HttpRequestDescriptor;
import com.senior.formcenter.servlet.IOProcessorHelper;
import com.senior.http.AbstractSeniortoolsFilter;
import com.senior.http.ContextHelper;
import com.senior.http.SeniortoolsContextListener;
import com.senior.internal.IWritableSecurityManager;
import com.senior.internal.IWritableUser;
import com.senior.security.AuthenticationType;
import com.senior.security.ISecurityManager;
import com.senior.security.ISubstitutedUser;
import com.senior.security.IUser;
import com.senior.security.SecurityException;
import com.senior.security.SecurityManagerProvider;
import com.senior.security.SubstituteUserType;
import com.senior.security.impl.ChangePasswordHelper;
import com.senior.security.impl.G5BinaryHelper;
import com.senior.security.impl.MalformedTokenException;
import com.senior.security.impl.TokenUtils;
import com.senior.ui.core.FilterMessageList;
import com.senior.ui.core.FormcenterException;
import com.senior.ui.core.IIOProcessor;
import com.senior.ui.core.IRequestDescriptor;
import com.senior.ui.core.RequestProperties;
import com.senior.util.Context;
import com.senior.util.ISessionManager;
import com.senior.util.ResourceUnavailableException;
import com.senior.util.SessionManagerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationFilter
extends AbstractSeniortoolsFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAuthenticationFilter.class);
    private static final String STATE_KEY = "AUTHENTICATION_STATE_KEY";
    private static final String USER_KEY = "USER_KEY";
    private static final String QUESTIONS_LIST_KEY = "QUESTIONS_LIST_KEY";
    private static final String FIRST_WARNING_GIVEN_KEY = "FIRST_WARNING_GIVEN_KEY";
    private static final String SECOND_WARNING_GIVEN_KEY = "SECOND_WARNING_GIVEN_KEY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerDoFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session;
        response.setHeader("Cache-Control", "no-cache");
        if (AbstractAuthenticationFilter.isDestroySessionRequest(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HttpSession httpSession = session = request.getSession(true);
        synchronized (httpSession) {
            IUser currentUser;
            if (!SeniortoolsContextListener.getServerStartedSuccessfully()) {
                ResourceUnavailableException e = new ResourceUnavailableException("O sistema est\u00e1 indispon\u00edvel pois existem erros de compila\u00e7\u00e3o nas customiza\u00e7\u00f5es. Para corrigir o problema, edite as customiza\u00e7\u00f5es pela ferramenta Senior Developer.");
                LOGGER.error(e.getMessage(), (Throwable)e);
                AbstractAuthenticationFilter.printLoginException(new FilterObjects(request, response, session, chain), (Exception)e);
                return;
            }
            AuthenticationState currentState = (AuthenticationState)((Object)session.getAttribute(STATE_KEY));
            if (currentState == null || currentState == AuthenticationState.LOGGED && SecurityManagerProvider.getInstance().getCurrentUser() == null) {
                currentState = AuthenticationState.NONE;
            }
            if (currentState == AuthenticationState.LOGGED && (currentUser = SecurityManagerProvider.getInstance().getCurrentUser()) != null) {
                String username = request.getParameter(AuthenticationKey.USER_NAME.getValue());
                String token = request.getParameter(AuthenticationKey.TOKEN.getValue());
                try {
                    if (username != null && !username.equals(currentUser.getName()) || AbstractAuthenticationFilter.isTokenCurrentUser(currentUser, token)) {
                        session.invalidate();
                        session = request.getSession(true);
                        ContextHelper.setUp((HttpSession)session);
                        currentState = AuthenticationState.NONE;
                    }
                }
                catch (MalformedTokenException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    AbstractAuthenticationFilter.printLoginException(new FilterObjects(request, response, session, chain), (Exception)((Object)e));
                    return;
                }
            }
            if (currentState == AuthenticationState.LOGGED) {
                if (AbstractAuthenticationFilter.checkParameters(request, response, session, chain)) {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                FilterObjects filterObjects = new FilterObjects(request, response, session, chain);
                try {
                    AbstractAuthenticationFilter.routeRequest(filterObjects, currentState);
                }
                catch (SecurityException e) {
                    AbstractAuthenticationFilter.handleSecurityException(filterObjects, e);
                    return;
                }
                catch (FormcenterException e) {
                    AbstractAuthenticationFilter.handleException(filterObjects, e.getMessage());
                    return;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    AbstractAuthenticationFilter.printLoginException(filterObjects, e);
                    session.invalidate();
                    return;
                }
            }
        }
    }

    private static boolean isTokenCurrentUser(IUser currentUser, String token) throws MalformedTokenException {
        return FrameworkProperty.TOKEN_ACTIVE.getBoolean() && StringUtils.isNotBlank((String)token) && !currentUser.getName().equals(TokenUtils.getUserName((String)token));
    }

    private static void routeRequest(FilterObjects filterObjects, AuthenticationState currentState) throws SecurityException, IOException, ServletException {
        switch (currentState) {
            case NONE: {
                AbstractAuthenticationFilter.routeFirstRequest(filterObjects);
                break;
            }
            case MUST_INFORM_USER: {
                AbstractAuthenticationFilter.routeInformUserPage(filterObjects);
                break;
            }
            case INFORMING_USER: {
                AbstractAuthenticationFilter.routeInformingUserRequest(filterObjects);
                break;
            }
            case MUST_ANSWER_QUESTIONS: {
                AbstractAuthenticationFilter.handleQuestionsPage(filterObjects);
                break;
            }
            case ANSWERING_QUESTIONS: {
                AbstractAuthenticationFilter.routeQuestionPageRequest(filterObjects);
                break;
            }
            case MUST_CHANGE_PASSWORD: {
                AbstractAuthenticationFilter.handleChangePasswordPage(filterObjects);
                break;
            }
            case CHANGING_PASSWORD: {
                AbstractAuthenticationFilter.routeChangePasswordRequest(filterObjects);
                break;
            }
            case MUST_SELECT_SUBSTITUTION: {
                AbstractAuthenticationFilter.handleSubstituteUser(filterObjects);
                break;
            }
            case SELECTING_SUBSTITUTION: {
                AbstractAuthenticationFilter.routeSubstitutionScreenRequest(filterObjects);
                break;
            }
            case LOGGED_WITH_WEEK_PERIODS: {
                AbstractAuthenticationFilter.verifyWeekPeriods(filterObjects);
                break;
            }
            default: {
                throw new RuntimeException("The state '".concat(currentState.toString()).concat("' is not supported."));
            }
        }
    }

    private static void routeFirstRequest(FilterObjects filterObjects) throws IOException, SecurityException, ServletException {
        boolean forgotPassword = Boolean.valueOf(filterObjects.request.getParameter(AuthenticationKey.FORGOT_PASSWORD.getValue()));
        if (forgotPassword) {
            filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.MUST_INFORM_USER);
            AbstractAuthenticationFilter.handleNextStep(filterObjects);
        } else {
            try {
                String username = filterObjects.request.getParameter(AuthenticationKey.USER_NAME.getValue());
                String password = filterObjects.request.getParameter(AuthenticationKey.PASSWORD.getValue());
                String token = filterObjects.request.getParameter(AuthenticationKey.TOKEN.getValue());
                if (username == null) {
                    username = FrameworkProperty.AUTH_USER.get();
                    password = FrameworkProperty.AUTH_PASSWORD.get();
                }
                boolean tokenActive = FrameworkProperty.TOKEN_ACTIVE.getBoolean();
                if (!(username != null && password != null || token != null && tokenActive)) {
                    AbstractAuthenticationFilter.loadLoginPage(filterObjects);
                } else {
                    IUser user = tokenActive && StringUtils.isNotBlank((String)token) ? AbstractAuthenticationFilter.authenticate(token) : AbstractAuthenticationFilter.authenticate(username, password);
                    AbstractAuthenticationFilter.routeAfterAuthenticated(filterObjects, user);
                }
            }
            catch (SecurityException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                SecurityException.ErrorCode defaultError = SecurityException.ErrorCode.INVALID_USERNAME_OR_PASSWORD;
                if (SecurityException.ErrorCode.USER_MUST_CHANGE_PASSWORD.equals((Object)e.getErrorCode())) {
                    defaultError = SecurityException.ErrorCode.USER_MUST_CHANGE_PASSWORD;
                }
                throw new SecurityException(defaultError, new String[0]);
            }
        }
    }

    private static void routeInformUserPage(FilterObjects filterObjects) throws IOException {
        Map<String, Object> requestParameters = filterObjects.descriptor.getModifiableParametersMap();
        String username = filterObjects.request.getParameter(AuthenticationKey.USER_NAME.getValue());
        requestParameters.put(AuthenticationKey.USER_NAME.getValue(), username);
        filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.INFORMING_USER);
        filterObjects.ioProcessor.handleLoginRequest((IRequestDescriptor)filterObjects.descriptor, (OutputStream)filterObjects.response.getOutputStream(), true);
    }

    private static void routeInformingUserRequest(FilterObjects filterObjects) throws SecurityException, IOException {
        block10: {
            String username = filterObjects.request.getParameter(AuthenticationKey.USER_NAME.getValue());
            String cancel = filterObjects.request.getParameter(AuthenticationKey.CANCEL.getValue());
            if (username == null && cancel == null) {
                AbstractAuthenticationFilter.routeInformUserPage(filterObjects);
            } else if (!AbstractAuthenticationFilter.cancelToLoginPage(filterObjects, cancel)) {
                ISessionManager manager = SessionManagerFactory.newInstance();
                try {
                    IUser user = SecurityManagerProvider.getInstance().getUser(username);
                    if (user != null) {
                        try {
                            List userQuestions = SecurityManagerProvider.getInstance().getUserQuestions(user);
                            filterObjects.session.setAttribute(QUESTIONS_LIST_KEY, (Object)userQuestions);
                            AbstractAuthenticationFilter.handleNextStep(filterObjects);
                            filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.MUST_ANSWER_QUESTIONS);
                            filterObjects.session.setAttribute(USER_KEY, (Object)user);
                            break block10;
                        }
                        catch (SecurityException e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                            SecurityException.ErrorCode defaultError = SecurityException.ErrorCode.INVALID_USERNAME;
                            if (SecurityException.ErrorCode.USER_MUST_CHANGE_PASSWORD.equals((Object)e.getErrorCode())) {
                                defaultError = SecurityException.ErrorCode.USER_MUST_CHANGE_PASSWORD;
                            }
                            throw new SecurityException(defaultError, new String[0]);
                        }
                    }
                    throw new FormcenterException(SecurityException.ErrorCode.INVALID_USERNAME.getMessage());
                }
                finally {
                    manager.stop(Context.current());
                }
            }
        }
    }

    private static void handleQuestionsPage(FilterObjects filterObjects) throws IOException {
        Map<String, Object> requestParameters = filterObjects.descriptor.getModifiableParametersMap();
        List userQuestions = (List)filterObjects.session.getAttribute(QUESTIONS_LIST_KEY);
        requestParameters.put(AuthenticationKey.QUESTIONS_LIST.getValue(), userQuestions);
        filterObjects.ioProcessor.handleQuestionForgottenPassword((IRequestDescriptor)filterObjects.descriptor, (OutputStream)filterObjects.response.getOutputStream());
        filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.ANSWERING_QUESTIONS);
    }

    private static void routeQuestionPageRequest(FilterObjects filterObjects) throws IOException {
        String cancel = filterObjects.request.getParameter(AuthenticationKey.CANCEL.getValue());
        if (filterObjects.request.getParameter(String.valueOf(AuthenticationKey.ANSWER.getValue()) + 0) == null && cancel == null) {
            AbstractAuthenticationFilter.handleQuestionsPage(filterObjects);
        } else if (!AbstractAuthenticationFilter.cancelToLoginPage(filterObjects, cancel)) {
            IUser user = (IUser)filterObjects.session.getAttribute(USER_KEY);
            List answers = user.getAnswers();
            int i = 0;
            while (i < answers.size()) {
                byte[] expectedEncryptAnswer;
                List questions = user.getQuestions();
                String answer = filterObjects.request.getParameter(String.valueOf(AuthenticationKey.ANSWER.getValue()) + i);
                if (StringUtils.isEmpty((String)answer)) {
                    throw new FormcenterException("H\u00e1 perguntas n\u00e3o respondidas.");
                }
                answer = answer.toUpperCase().trim();
                byte[] currentEncryptAnswer = G5BinaryHelper.encryptUserPassword((String)((String)questions.get(i)), (String)answer);
                if (!Arrays.equals(currentEncryptAnswer, expectedEncryptAnswer = (byte[])answers.get(i))) {
                    throw new FormcenterException("A resposta ".concat(Integer.toString(i + 1).concat(" est\u00e1 incorreta.")));
                }
                ++i;
            }
            filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.MUST_CHANGE_PASSWORD);
            AbstractAuthenticationFilter.handleNextStep(filterObjects);
        }
    }

    private static void handleChangePasswordPage(FilterObjects filterObjects) throws IOException {
        filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.CHANGING_PASSWORD);
        filterObjects.ioProcessor.handleChangePasswordRequest((IRequestDescriptor)filterObjects.descriptor, (OutputStream)filterObjects.response.getOutputStream());
    }

    private static void routeChangePasswordRequest(FilterObjects filterObjects) throws IOException, SecurityException, ServletException {
        String newPassword = filterObjects.request.getParameter(AuthenticationKey.NEW_PASSWORD.getValue());
        String confirmPassword = filterObjects.request.getParameter(AuthenticationKey.CONFIRM_PASSWORD.getValue());
        String cancel = filterObjects.request.getParameter(AuthenticationKey.CANCEL.getValue());
        if (newPassword == null && confirmPassword == null && cancel == null) {
            AbstractAuthenticationFilter.handleChangePasswordPage(filterObjects);
        } else if (!AbstractAuthenticationFilter.cancelToLoginPage(filterObjects, cancel)) {
            if (!StringUtils.equals((String)newPassword, (String)confirmPassword)) {
                throw new FormcenterException("As senhas informadas n\u00e3o conferem.");
            }
            IUser user = SecurityManagerProvider.getInstance().getCurrentUser();
            if (user == null) {
                user = (IUser)filterObjects.session.getAttribute(USER_KEY);
            }
            ISessionManager manager = SessionManagerFactory.newInstance();
            try {
                ChangePasswordHelper.changePassword((IUser)user, (String)newPassword);
                IUser authenticatedUser = AbstractAuthenticationFilter.authenticate(user.getName(), newPassword);
                AbstractAuthenticationFilter.routeAfterAuthenticated(filterObjects, authenticatedUser);
            }
            finally {
                manager.stop(Context.current());
            }
        }
    }

    private static void routeSubstitutionScreenRequest(FilterObjects filterObjects) throws SecurityException, IOException {
        String joinedUserConfirmation = filterObjects.request.getParameter(SubstituteUserKey.JOINED_USER_CONFIRMATION.getValue());
        String selectedSubstituted = filterObjects.request.getParameter(SubstituteUserKey.SUBSTITUTED_USER_ID.getValue());
        if (joinedUserConfirmation == null && selectedSubstituted == null) {
            AbstractAuthenticationFilter.handleSubstituteUser(filterObjects);
            return;
        }
        ArrayList<ISubstitutedUser> substitutedUsers = (ArrayList<ISubstitutedUser>)filterObjects.session.getAttribute(SubstituteUserKey.SUBSTITUTED_USER_LIST.getValue());
        IWritableUser user = (IWritableUser)filterObjects.session.getAttribute(SubstituteUserKey.AUTHENTICATED_USER.getValue());
        AbstractAuthenticationFilter.validateSelectedSusbtitutedUser(selectedSubstituted, (List<ISubstitutedUser>)substitutedUsers);
        try {
            IWritableSecurityManager securityManager = (IWritableSecurityManager)SecurityManagerProvider.getInstance();
            if (securityManager.getSubstituteType() == SubstituteUserType.SINGLE) {
                ISubstitutedUser searchSubstitutedUser = AbstractAuthenticationFilter.searchSubstitutedUser((List<ISubstitutedUser>)substitutedUsers, Long.parseLong(selectedSubstituted));
                substitutedUsers = new ArrayList<ISubstitutedUser>(1);
                substitutedUsers.add(searchSubstitutedUser);
            }
            user.setSubstitutedUsers(AbstractAuthenticationFilter.converteToIUserList((List<ISubstitutedUser>)substitutedUsers));
            securityManager.logon((IUser)user);
        }
        finally {
            Context.current().retainShareableResources();
        }
        filterObjects.session.removeAttribute(SubstituteUserKey.SUBSTITUTED_USER_LIST.getValue());
        filterObjects.session.removeAttribute(SubstituteUserKey.AUTHENTICATED_USER.getValue());
        filterObjects.ioProcessor.handleLoginStepFinish((IRequestDescriptor)filterObjects.descriptor, (OutputStream)filterObjects.response.getOutputStream());
        AbstractAuthenticationFilter.setLoggedState(filterObjects, (IUser)user);
    }

    private static List<IUser> converteToIUserList(List<ISubstitutedUser> substitutedUsers) {
        ArrayList<IUser> user = new ArrayList<IUser>();
        for (ISubstitutedUser substitutedUserInfo : substitutedUsers) {
            user.add(substitutedUserInfo.getUser());
        }
        return user;
    }

    private static ISubstitutedUser searchSubstitutedUser(List<ISubstitutedUser> substitutedUsers, long userId) {
        for (ISubstitutedUser iSubstitutedUser : substitutedUsers) {
            IUser user = iSubstitutedUser.getUser();
            if (user.getId() != userId) continue;
            return iSubstitutedUser;
        }
        return null;
    }

    private static void verifyWeekPeriods(FilterObjects filterObjects) throws IOException, ServletException {
        ISessionManager manager = SessionManagerFactory.newInstance();
        ISecurityManager securityManager = SecurityManagerProvider.getInstance();
        try {
            try {
                securityManager.checkWeekPeriod(securityManager.getCurrentUser(), LocalDateTime.now());
            }
            catch (SecurityException e) {
                AbstractAuthenticationFilter.printLoginException(filterObjects, (Exception)((Object)e));
                filterObjects.session.invalidate();
            }
        }
        finally {
            manager.stop(Context.current());
        }
        String message = null;
        Boolean firstWarningGiven = (Boolean)filterObjects.session.getAttribute(FIRST_WARNING_GIVEN_KEY);
        String propertyKey = null;
        if (firstWarningGiven == null || !firstWarningGiven.booleanValue()) {
            message = securityManager.getWeekPeriodExpiringMessage(LocalDateTime.now(), 10);
            propertyKey = FIRST_WARNING_GIVEN_KEY;
        } else {
            Boolean secondWarningGiven = (Boolean)filterObjects.session.getAttribute(SECOND_WARNING_GIVEN_KEY);
            if (secondWarningGiven == null || !secondWarningGiven.booleanValue()) {
                message = securityManager.getWeekPeriodExpiringMessage(LocalDateTime.now(), 5);
                propertyKey = SECOND_WARNING_GIVEN_KEY;
            }
        }
        if (message != null) {
            FilterMessageList messages = (FilterMessageList)Context.current().get(FilterMessageList.FILTER_MESSAGE_LIST_KEY);
            messages.addMessage(message);
            filterObjects.session.setAttribute(propertyKey, (Object)Boolean.TRUE);
        }
        if (AbstractAuthenticationFilter.checkParameters(filterObjects.request, filterObjects.response, filterObjects.session, filterObjects.chain)) {
            filterObjects.chain.doFilter((ServletRequest)filterObjects.request, (ServletResponse)filterObjects.response);
        }
    }

    private static void setLoggedState(FilterObjects filterObjects, IUser user) throws SecurityException {
        ISessionManager manager = SessionManagerFactory.newInstance();
        try {
            ISecurityManager securityManager = SecurityManagerProvider.getInstance();
            if (securityManager.checkWeekPeriod(user, LocalDateTime.now())) {
                filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.LOGGED_WITH_WEEK_PERIODS);
            } else {
                filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.LOGGED);
            }
        }
        finally {
            manager.stop(Context.current());
        }
        AbstractAuthenticationFilter.verifyExpiringPasswordMessage(filterObjects, user);
    }

    private static void verifyExpiringPasswordMessage(FilterObjects filterObjects, IUser user) throws SecurityException {
        FilterMessageList messages = new FilterMessageList();
        Context.current().put(FilterMessageList.FILTER_MESSAGE_LIST_KEY, (Object)messages);
        if (user.getLastAuthenticationType() == AuthenticationType.SENIOR) {
            ISessionManager manager = SessionManagerFactory.newInstance();
            try {
                ISecurityManager securityManager = SecurityManagerProvider.getInstance();
                String passwordExpiringMessage = securityManager.getPasswordExpiringMessage(user);
                if (passwordExpiringMessage != null) {
                    messages.addMessage(passwordExpiringMessage);
                }
            }
            finally {
                manager.stop(Context.current());
            }
        }
    }

    private static boolean cancelToLoginPage(FilterObjects filterObjects, String cancel) throws IOException {
        boolean isCancel = Boolean.parseBoolean(cancel);
        if (isCancel) {
            filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.NONE);
            AbstractAuthenticationFilter.handleNextStep(filterObjects);
        }
        return isCancel;
    }

    private static void routeAfterAuthenticated(FilterObjects filterObjects, IUser user) throws IOException, SecurityException, ServletException {
        List<ISubstitutedUser> substituteUsers = AbstractAuthenticationFilter.getSubstitutedUsers(user);
        if (!substituteUsers.isEmpty()) {
            filterObjects.session.setAttribute(SubstituteUserKey.SUBSTITUTED_USER_LIST.getValue(), substituteUsers);
            filterObjects.session.setAttribute(SubstituteUserKey.AUTHENTICATED_USER.getValue(), (Object)user);
            if (AbstractAuthenticationFilter.handleNextStep(filterObjects)) {
                filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.MUST_SELECT_SUBSTITUTION);
            } else {
                AbstractAuthenticationFilter.handleSubstituteUser(filterObjects);
            }
        } else {
            ISecurityManager securityManager = SecurityManagerProvider.getInstance();
            try {
                securityManager.logon(user);
            }
            finally {
                Context.current().retainShareableResources();
            }
            AbstractAuthenticationFilter.setLoggedState(filterObjects, user);
            if (!AbstractAuthenticationFilter.handleNextStep(filterObjects)) {
                filterObjects.chain.doFilter((ServletRequest)filterObjects.request, (ServletResponse)filterObjects.response);
            }
        }
    }

    private static boolean handleNextStep(FilterObjects filterObjects) throws IOException {
        return filterObjects.ioProcessor.handleLoginStepFinish((IRequestDescriptor)filterObjects.descriptor, (OutputStream)filterObjects.response.getOutputStream());
    }

    private static void handleSubstituteUser(FilterObjects filterObjects) throws IOException {
        ISessionManager manager = SessionManagerFactory.newInstance();
        try {
            try {
                List substitutedUsers = (List)filterObjects.session.getAttribute(SubstituteUserKey.SUBSTITUTED_USER_LIST.getValue());
                IWritableSecurityManager securityManager = (IWritableSecurityManager)SecurityManagerProvider.getInstance();
                IUser authenticatedUser = (IUser)filterObjects.session.getAttribute(SubstituteUserKey.AUTHENTICATED_USER.getValue());
                Map<String, Object> requestParameters = filterObjects.descriptor.getModifiableParametersMap();
                SubstituteUserType substituteType = securityManager.getSubstituteType();
                ISubstitutedUser substitutedUser = AbstractAuthenticationFilter.searchSubstitutedUser(substitutedUsers, authenticatedUser.getId());
                if (substitutedUser == null && substituteType == SubstituteUserType.SINGLE) {
                    substitutedUsers.add(0, new AuthenticatedUserSubstituedUser(authenticatedUser));
                }
                requestParameters.put(SubstituteUserKey.SUBSTITUTED_USER_LIST.getValue(), substitutedUsers);
                requestParameters.put(SubstituteUserKey.SUBSTITUTED_USER_TYPE.getValue(), substituteType);
                filterObjects.ioProcessor.handleSubstituteUser((IRequestDescriptor)filterObjects.descriptor, (OutputStream)filterObjects.response.getOutputStream());
                filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.SELECTING_SUBSTITUTION);
            }
            catch (Exception e) {
                AbstractAuthenticationFilter.printLoginException(filterObjects, e);
                manager.stop(Context.current());
            }
        }
        finally {
            manager.stop(Context.current());
        }
    }

    private static void validateSelectedSusbtitutedUser(String selectedSubstituted, List<ISubstitutedUser> substitutedUsers) {
        if (selectedSubstituted != null) {
            long selectedUserId = Long.parseLong(selectedSubstituted);
            boolean userFound = false;
            for (ISubstitutedUser iUser : substitutedUsers) {
                if (iUser.getUser().getId() != selectedUserId) continue;
                userFound = true;
                break;
            }
            if (!userFound) {
                throw new IllegalArgumentException("Usu\u00e1rio substitu\u00eddo selecionado \u00e9 inv\u00e1lido.");
            }
        }
    }

    private static boolean checkParameters(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws IOException {
        boolean handleException;
        String substitutedUserId = request.getParameter(SubstituteUserKey.SUBSTITUTED_USER_ID.getValue());
        boolean bl = handleException = substitutedUserId != null;
        if (handleException) {
            FilterObjects filterObjects = new FilterObjects(request, response, session, chain);
            AbstractAuthenticationFilter.printLoginException(filterObjects, (Exception)((Object)new FormcenterException("A\u00e7\u00e3o indispon\u00edvel, a sess\u00e3o de usu\u00e1rio j\u00e1 est\u00e1 criada, favor pressionar F5 para continuar.")));
        }
        return !handleException;
    }

    private static void printLoginException(FilterObjects filterObjects, Exception e) throws IOException {
        Map<String, Object> requestParameters = filterObjects.descriptor.getModifiableParametersMap();
        requestParameters.put(RequestProperties.MESSAGE_TITLE.name(), "Relat\u00f3rio de erro: " + e.getMessage());
        requestParameters.put(RequestProperties.MESSAGE.name(), e.getMessage());
        requestParameters.put(RequestProperties.STATUS_CODE.name(), "500");
        filterObjects.ioProcessor.handleError((IRequestDescriptor)filterObjects.descriptor, (OutputStream)filterObjects.response.getOutputStream());
    }

    private static void loadLoginPage(FilterObjects filterObjects) throws IOException {
        filterObjects.ioProcessor.handleLoginRequest((IRequestDescriptor)filterObjects.descriptor, (OutputStream)filterObjects.response.getOutputStream(), false);
        StringBuilder sb = new StringBuilder();
        sb.append("Basic realm=\"");
        sb.append(filterObjects.request.getServerName());
        sb.append(':');
        sb.append(filterObjects.request.getServerPort());
        sb.append(filterObjects.request.getContextPath());
        sb.append('\"');
    }

    private static Map<String, Object> getRequestParameters(HttpServletRequest request) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Object parameter : request.getParameterMap().keySet()) {
            String parameterValue = request.getParameter((String)parameter);
            if (parameterValue == null) continue;
            ret.put((String)parameter, parameterValue);
        }
        return ret;
    }

    private static IUser authenticate(String username, String password) throws SecurityException {
        ISessionManager manager = SessionManagerFactory.newInstance();
        try {
            ISecurityManager securityManager = SecurityManagerProvider.getInstance();
            IUser iUser = securityManager.authenticate(username, password);
            return iUser;
        }
        finally {
            manager.stop(Context.current());
        }
    }

    private static IUser authenticate(String token) throws SecurityException {
        ISessionManager manager = SessionManagerFactory.newInstance();
        try {
            IUser user;
            ISecurityManager securityManager = SecurityManagerProvider.getInstance();
            IUser iUser = user = securityManager.authenticate(token);
            return iUser;
        }
        finally {
            manager.stop(Context.current());
        }
    }

    private static List<ISubstitutedUser> getSubstitutedUsers(IUser user) {
        ISessionManager manager = SessionManagerFactory.newInstance();
        try {
            IWritableSecurityManager securityManager = (IWritableSecurityManager)SecurityManagerProvider.getInstance();
            List substitutedUser = securityManager.getSubstituteType() != SubstituteUserType.NONE ? securityManager.getSubstitutedUser(user) : Collections.emptyList();
            List list = substitutedUser;
            return list;
        }
        finally {
            manager.stop(Context.current());
        }
    }

    private static void handleSecurityException(FilterObjects filterObjects, SecurityException e) throws IOException {
        if (SecurityException.ErrorCode.USER_MUST_CHANGE_PASSWORD.equals((Object)e.getErrorCode())) {
            if (AbstractAuthenticationFilter.handleNextStep(filterObjects)) {
                String username = filterObjects.request.getParameter(AuthenticationKey.USER_NAME.getValue());
                ISessionManager manager = SessionManagerFactory.newInstance();
                try {
                    try {
                        filterObjects.session.setAttribute(USER_KEY, (Object)SecurityManagerProvider.getInstance().getUser(username));
                    }
                    catch (SecurityException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                finally {
                    manager.stop(Context.current());
                }
                filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.MUST_CHANGE_PASSWORD);
            } else {
                filterObjects.session.setAttribute(STATE_KEY, (Object)AuthenticationState.CHANGING_PASSWORD);
                filterObjects.ioProcessor.handleChangePasswordRequest((IRequestDescriptor)filterObjects.descriptor, (OutputStream)filterObjects.response.getOutputStream());
            }
        } else {
            AbstractAuthenticationFilter.handleException(filterObjects, e.getMessage());
        }
    }

    private static void handleException(FilterObjects filterObjects, String message) throws IOException {
        Map<String, Object> requestParameters = filterObjects.descriptor.getModifiableParametersMap();
        requestParameters.put("errorMessage", message);
        filterObjects.ioProcessor.handleLoginAuthenticateError((IRequestDescriptor)filterObjects.descriptor, (OutputStream)filterObjects.response.getOutputStream());
    }

    private static boolean isDestroySessionRequest(HttpServletRequest request) {
        return "/logOff".equals(request.getServletPath()) || "/destroy".equals(request.getServletPath()) && "loginPage".equals(request.getParameter("perspective"));
    }

    private static final class AuthenticatedUserSubstituedUser
    implements ISubstitutedUser {
        private final IUser user;

        public AuthenticatedUserSubstituedUser(IUser user) {
            this.user = user;
        }

        public IUser getUser() {
            return this.user;
        }

        public LocalDate getDateStart() {
            return null;
        }

        public LocalDate getDateEnd() {
            return null;
        }
    }

    private static final class FilterObjects {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final FilterChain chain;
        private final IIOProcessor ioProcessor;
        private final HttpSession session;
        private final HttpRequestDescriptor descriptor;

        FilterObjects(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) {
            this.request = request;
            this.response = response;
            this.response.setHeader("Content-Type", "text/html; charset=iso-8859-1");
            this.ioProcessor = IOProcessorHelper.getIOProcessor(request);
            this.session = session;
            this.descriptor = new HttpRequestDescriptor(request, AbstractAuthenticationFilter.getRequestParameters(request));
            this.chain = chain;
        }
    }
}

