/**
 * Controla a execuo do profiler no client, bem como o envio das
 * informaes coletadas para o server
 * 
 */
SProfilerManager = {};

SProfilerManager.apply = function(o, c, defaults) {
    /* no "this" reference for friendly out of scope calls */
    if (defaults) {
        Senior.apply(o, defaults);
    }
    if (o && c && typeof c == 'object') {
        for ( var p in c) {
            o[p] = c[p];
        }
    }
};

SProfilerManager.apply(SProfilerManager, {

    START : "start",
    STEP : "step",
    STOP : "stop",

    enabled : false,

    events : new Array(),

    block : 1000,

    xmlEvent : "<event type ='{0}'>",
    xmlDescription : "<description><![CDATA[{0}]]></description>",
    xmlBlock : "<block>{0}</block>",
    xmlTime : "<time>{0}</time>",

    start : Ext.emptyFn,
    stop : Ext.emptyFn,
    step : Ext.emptyFn,

    /* ================================================================================ */

    setEnabled : function(enabled) {
        if (enabled) {
            this.start = function(description) {
                this.block++;

                var event = new EventProfiler(this.START, this.currentMillis(), description, this.block);
                this.events.push(event);

                return this.block;
            };

            this.stop = function(block) {
                var event = new EventProfiler(this.STOP, this.currentMillis(), "", block);
                this.events.push(event);
            };

            this.step = function(description, block) {
                var event = new EventProfiler(this.STEP, this.currentMillis(), description, block);
                this.events.push(event);
            };
            this.enabled = true;
        } else {
            this.start = Ext.emptyFn;
            this.stop = Ext.emptyFn;
            this.step = Ext.emptyFn;
	        this.enabled = false;
        }
    },

    /* ================================================================================ */

    /**
     * @protected
     */
    flush : function(profilerName) {
        if (!this.enabled) {
            return;
        }

        var url =  window.location.protocol + "//" + window.location.host + window.location.pathname + "profiler/";

        var xmlData = this.buildXml();

        this.events = new Array();

        Ext.Ajax.request( {
            method : 'POST',
            scope : this,
            url : url,
            success : this.requestSuccessHandler,
            failure : this.requestFaliureHandler,
            timeout : 100000,
            headers : {
                'Pragma' : 'no-cache',
                'Content-Type' : 'application/x-www-form-urlencoded; charset=UTF8'
            },
            xmlData : "xmlData=" + xmlData
        });
    },

    /**
     * @private
     */
    buildXml : function(profiler) {
        var data = "<events>";

        for ( var i = 0; i < this.events.length; i++) {
            var event = this.events[i];

            data += String.format(this.xmlEvent, event.getType());
            if (event.getDescription().length > 0) {
                data += String.format(this.xmlDescription, event.getDescription());
            }
            data += String.format(this.xmlTime, event.getTime());
            data += String.format(this.xmlBlock, event.getBlock());
            data += "</event>";
        }

        data += "</events>";
        return data;
    },

    requestSuccessHandler : function() {
        // nada a implementar aqui por enquanto 
    },

    requestFaliureHandler : function() {
        // nada a implementar aqui por enquanto
    },

    /**
     * @private
     */
    currentMillis : function() {
        return new Date().getTime();
    },

    /**
     * @private
     */
    getSession : function() {
        return ConnectionManager.getContext();
    }

});

/**
 * Construtor
 */
function EventProfiler(type, time, description, block) {
    this.description = description;
    this.type = type;
    this.time = time;
    this.block = block;
}

EventProfiler.prototype = {

    getDescription : function() {
        return this.description;
    },

    getType : function() {
        return this.type;
    },

    getTime : function() {
        return this.time;
    },

    getBlock : function() {
        return this.block;
    }
};
