Ext.namespace('Ext.ux.senior.form.plugins');

/**
 * Este plugin no guarda estados.
 * 
 * A mesma referncia a este plugin ser utilizada por todos os componentes que possuem tooltip, 
 * por isso este plugin no pode guardar estados. 
 * 
 * @author Daniel.Pereira
 */
Ext.ux.senior.form.plugins.TooltipPlugin = {

    init : function(owner) {
        Ext.apply(owner, this.ownerOverrides);
        owner.onRender = owner.onRender.createSequence(this.onRender, owner);
    },

    showHintsFunction : function() {
        var cmp = Ext.getCmp(this.anchorTarget.id);

        if (!!cmp) {
            /* se o componente existir e estiver visvel e habilitado, apresenta o hint do componente */
            if (cmp.isVisible() && !cmp.disabled) {
                Ext.ToolTip.prototype.show.apply(this, arguments);
            }
        } else {
        	// se no existir, pode ser que seja um element
            var el = Ext.get(this.anchorTarget.id);

            if (!!el && el.isVisible() && !el.dom.disabled) {
                Ext.ToolTip.prototype.show.apply(this, arguments);
            }
        }

    },

    /**
     * Destri o objeto Ext.Tooltip do componente
     */
    destroyTooltipObject : function() {
        if (this.objTooltip != null) {
            this.objTooltip.destroy();
            this.objTooltip = null;
        }
    },

    /**
     * @override
     */
    onRender : function() {
        /* Se houver hints para criar, chama o mtodo para criar um objeto com o html dos hints */
        if (this.hints != null && this.hints.length > 0) {
            this.objTooltip = TooltipHelper.createHintsHtml(this.hints, /* */
            this.getHintTarget(), false,/* */
            Ext.ux.senior.form.plugins.TooltipPlugin.showHintsFunction);
        } else {
            Ext.ux.senior.form.plugins.TooltipPlugin.destroyTooltipObject();
        }

    },

    ownerOverrides : {

        /**
         * Instncia do tooltip do ext
         */
        objTooltip : null,

        /**
         * Informa os hints que devero aparecer para o componente.
         * 
         * Cada hint da lista ir aparecer em uma nova linha
         * 
         * @param {JSON}
         *            pHint uma lista de objetos que formaro o hint O objeto desta lista deve ter duas propriedades, icon e text, o cone do hint, e o hint propriamente dito.
         * @public
         */
        setHints : function(pHint) {
            this.hints = pHint;

            /* Se houver um objeto de hints j criado para este componente, destri o objeto de hints */
            this.removeHints();

            this.hints = pHint;

            /* s manda criar os hints se o componente j estiver renderizado e houver hints para criar */
            if (this.rendered && this.hints != null && this.hints.length > 0) {
                this.objTooltip = TooltipHelper.createHintsHtml(this.hints,/* */
                this.getHintTarget(),/* */
                false,/* */
                Ext.ux.senior.form.plugins.TooltipPlugin.showHintsFunction);
            }
        },

        /**
         * @public
         */
        getHints : function() {
            if (!this.hints) {
                return "";
            }
            var temp = "";
            for ( var i = 0; i < this.hints.length; i++) {
                if (i > 0) {
                    temp += ",";
                }
                temp += "{";
                temp += "text : \"" + this.hints[i].text + "\",";
                temp += "icon : \"" + this.hints[i].icon + "\"}";
            }
            return "[" + temp + "]";
        },

        /**
         * @public
         */
        removeHints : function() {
            this.hints = null;
            if (this.objTooltip != null) {
                this.objTooltip.destroy();
                this.objTooltip = null;
            }
        },

        /**
         * @public
         */
        disableHints : function() {
            if (this.objTooltip) {
                this.objTooltip.disable();
            }
        },

        /**
         * @public
         */
        enableHints : function() {
            if (this.objTooltip) {
                this.objTooltip.enable();
            }
        },

        /**
         * @public
         */
        hintsEnabled : function() {
            return !this.objTooltip.disabled;
        }
    }
};

Ext.preg('seniortooltip', Ext.ux.senior.form.plugins.TooltipPlugin);
