Ext.namespace('Ext.ux.senior.form.plugins');

/**
 * Plugin que adiciona controle de mscara a um componente.
 * O plugin guarda o valor original sem mscara no atributo rawValue 
 * e mostra este valor quando o componente  focado.
 * 
 * @author Andr Hildinger
 */
Ext.ux.senior.form.plugins.MaskPlugin = function(config) {
    Ext.apply(this, config);
};

Ext.extend(Ext.ux.senior.form.plugins.MaskPlugin, Ext.util.Observable, {

    /**
     * Campo que recebe o plugin
     */
    field : null,

    init : function(field) {
        Ext.apply(field, this.overrides);
        this.field = field;
        this.field.enableKeyEvents = true;

        if (!field.rawValue) {
            field.rawValue = "";
        }
        if (!field.maskedValue) {
            field.maskedValue = "";
        }
        
        if(field.maskEnabled){
            field.maskEnabled = false;
            field.setMaskPluginEnabled(true);
        }
    },

    overrides : {

        /**
         * Indica que o valor do campo foi alterado.
         * Esta propriedade  utilizada para retornar o valor mascarado que j estava no campo quando o rawValue no for alterado.
         */
        componentValueChanged : false,

        /**
         * Indica se o plugin de mscara est habilitado.
		 * @cfg maskEnabled 
         */

        /**
         * Seta os valores raw e masked
         * 
         * @param rawValue valor sem mscara
         * @param maskedValue valor com mscara
         */
        setValues : function(rawValue, maskedValue) {
            this.maskedValue = maskedValue;
            this.rawValue = rawValue;
            if (this.hasFocus) {
                this.setValue(rawValue);
                this.startValue = rawValue;
            } else {
                this.setValue(maskedValue);
                this.startValue = maskedValue;
            }
        },

        /**
         * Habilitada/desabilita o plugin de mscara neste componente
         * 
         * @param enabled Indica se deve adicionar ou remover os listeners de mscara
         */
        setMaskPluginEnabled : function(enabled) {
            if (this.maskEnabled != enabled) {
                if (enabled) {
                    this.on('focus', this.maskOnFocus, this);
                    this.on('change', this.maskOnChange, this);
                    this.on('blur', this.maskOnBlur, this);
                } else {
                    this.un('focus', this.maskOnFocus, this);
                    this.un('change', this.maskOnChange, this);
                    this.un('blur', this.maskOnBlur, this);
                }
                this.maskEnabled = enabled;
            }
        },

        /**
         * Evento de foco de um componente que possui o plugin ativado.
         * 
         * @param field Componente que disparou o evento
         * @param evt Evento
         */
        maskOnFocus : function(field, evt) {
            if(this.maskedValue != this.getValue()){
                this.fireEvent("change");
            }
            this.setValue(this.rawValue);
            if (this.selectOnFocus) {
                this.el.dom.select();
            }

            this.startValue = this.rawValue ? this.rawValue : "";
        },

        /**
         * Evento de change de um componente que possui o plugin ativado.
         */
        maskOnChange : function() {
            if (this.rawValue != this.getValue()) {
                this.rawValue = this.getValue();
                this.componentValueChanged = true;
            }
        },

        /**
         * Evento de blur de um componente que possui o plugin ativado.
         */
        maskOnBlur : function() {
            if (this.componentValueChanged) {
                this.componentValueChanged = false;
            } else if (!this.hasError) {
                this.setValue(this.maskedValue);
            }
        }

    }

});

Ext.preg('maskplugin', Ext.ux.senior.form.plugins.MaskPlugin);
