Ext.namespace('Ext.ux.senior.form.plugins');

Ext.ux.senior.form.plugins.InformationTipsPlugin = {

    init : function(cmp) {
        Ext.apply(cmp, this.overrides);
        var fn = function() {
            if(cmp.isMessageVisible()) {
                cmp.showMessage.defer(200, cmp, [true]);
            }
        };
        if(Ext.isIE) {
            window.attachEvent('onresize', fn);
        } else {
            window.addEventListener('resize', fn);
        }
    },

    overrides : {
        
        /**
         * mensagem que aparecer para o usurio, explicando o erro ocorrido
         */
        message : '',
        
        /**
         * se este tip ter o boto fechar
         */
        closable : false,
        
        /**
         * cone do hint que aparecer para o usurio
         */
        hintIcon : 'resources/images/login/SeverityError.png',

        /**
         * Atribui um novo valor para a mensagem exibida no hint
         * 
         * @param message novo valor para a mensagem exibida no hint
         */
        setMessageHint : function(message, closable) {
            if(message !== this.message) {
                this.message = message;
                if(this.tipMessage) {
                    this.tipMessage.destroy();
                    this.tipMessage = null;
                }
            }
            this.closable = closable;
        },

        /**
         * Retorna o contedo do hint da mensagem
         * 
         * @returns o contedo do hint da mensagem
         */
        getMessageHint : function() {
            return this.message;
        },

        /**
         * Exibe ou esconde o hint com a mensagem, dependendo do parmetro que for passado
         * 
         * @param visible true para exibir o hint, false para esconder
         */
        setMessageVisible : function(visible) {
            if (visible) {
                this.showMessage();
            } else {
                this.hideMessage();
            }
        },
        
        /**
         * Retorna se o hint com a mensagem est vsivel
         * 
         * @returns {Boolean} true se o hint com a mensagem estiver visvel, false caso contrrio
         */
        isMessageVisible : function() {
            return this.tipMessage && this.tipMessage.isVisible();
        },

        /**
         * Exibe o hint com a mensagem. Caso o hint no tenha sido criado ainda, ser criado antes de ser exibido.
         *  
         */
        showMessage : function() {
            if (!this.tipMessage) {
                this.createMessage();
            }
            this.tipMessage.show(true);
        },
        
        /**
         * Criar a mensagem contendo o problema
         */
        createMessage : function() {
            this.tipMessage = TooltipHelper.createHintsHtml([ {
                text : this.message,
                icon : this.hintIcon
            } ], this.id, false, Ext.ux.senior.form.plugins.TooltipPlugin.showHintsFunction, {
                alignTo : 'br'
            }, this.closable);
            this.tipMessage.show = TooltipHelper.createKeyAndClickInterceptor(this.tipMessage.show);
            this.tipMessage.hide = TooltipHelper.createKeyAndClickInterceptor(this.tipMessage.hide);
        },

        /**
         * Esconde o hint que exibe a mensagem
         */
        hideMessage : function() {
            if (this.tipMessage) {
                this.tipMessage.hide(true);
            }
        },
        
        /**
         * Retorna o cone exibido pelo hint de informao
         * 
         * @returns cone exibido pelo hint de informao
         */
        getHintIcon : function() {
            return this.hintIcon;
        }
        

    }

};

Ext.preg('informationtipsplugin', Ext.ux.senior.form.plugins.InformationTipsPlugin);