Ext.namespace('Ext.ux.senior.plugins');
/**
 * Plugin para adicionar doritos e a "cobrinha" de erro nos elementos.
 */
Ext.ux.senior.plugins.FieldStatusPlugin = Ext.extend(Object, {

    /**
     * @cfg {Boolean} changedMark Flag que define se o editable deve chamar a fun��o de marcar como alterado
     */

    /**
     * @template
     */
    init : function(owner) {

        Ext.apply(owner, {

            // id para quando criar uma tag IMG
            imgId : null,

            /**@cfg {Boolean} hasError*/

            /**
             * Adiciona ou remove a classe css que mostra aplica a imagem do sublinhado de erro (cobrinha) nos componentes
             * @param hasError <code>true</code> para mostrar o sublinhado de erro, <code>false</code> para remover o sublinhado. 
             */
            setHasError : function(hasError) {
                this.hasError = hasError;
                if (this.rendered) {

                    if (hasError === true) {
                        this.getEl().addClass('invalid-field');
                    } else {
                        this.getEl().removeClass('invalid-field');
                    }

                } else {
                    this.on('afterrender', function() {
                        this.setHasError(hasError);
                    }, this);
                }
            },

            /**
             * Foi sobrescrito pois se o componente possuir erro, vai ter o background-image da 'cobrinha' de erro aplicado, assim n�o pode aplicar o background do estilo din�mico, 
             * pois caso isso ocorra o background do estilo din�mico ir� sobrescrever o da 'cobrinha' e ela n�o ir� aparecer. 
             * 
             * @override
             */
            getStyleEl : owner.getStyleEl.createInterceptor(function(scope, toAdd) {
                var styleScope = scope.split('$')[0];
                var styleProperty = scope.split('$')[1];
                return !(styleScope != 'label' && styleProperty == 'background' && this.hasError && toAdd);
            }),

            /**
             * Cria um elemento para mostrar a imagem do 'doritos' se ainda n�o tiver sido criado. Caso o elemento da imagem j� tenha sido criado, apenas deixa a imagem vis�vel.
             * 
             * @param component o componente que ir� mostrar o indicador de altera��oes (doritos)
             */
            createMarkChange : function(component) {

                var imgEl = Ext.get(this.imgId);

                if (imgEl == null) {
                    this.imgId = "img_" + component.getEl().id;

                    var img = document.createElement("img");

                    imgEl = new Ext.Element(img);
                    imgEl.set({
                        id : "img_" + component.getEl().id,
                        src : "resources/images/shared/doritos_markchange.gif"
                    });

                    if (component.xtype == 'seniorcheckbox') {
                        //como a imagem fica sobre o checkbox, e ocupa quase 1/4 do checkbox, quando clicar na imagem dispara o click no checkbox.
                        imgEl.on("click", function(ev, el, o) {
                            this.getEl().dom.click();
                        }, this);
                    }

                    var ownerCt = component.ownerCt;

                    component.on("destroy", function(cmp) {
                        imgEl.purgeAllListeners();
                        imgEl.removeAnchor();
                        imgEl.remove();
                        if (ownerCt) {
                            ownerCt.un("afterLayout", cmp.afterLayout, cmp);
                        }
                    });

                    component.getEl().parent().appendChild(imgEl);
                    imgEl.setStyle("position", "absolute");
                    imgEl.anchorTo(component.getId(), 'tl', null, false, true);

                    if (ownerCt) {
                        ownerCt.on('afterLayout', component.afterLayout, component);
                    }

                    // se o campo estiver em uma modal, 
                    var window = this.getModal(component);
                    if (window != null) {
                        window.on("move", function() {
                            imgEl.show();
                        }, this);

                        var startDrag = window.dd.startDrag;
                        window.dd.startDrag = function() {
                            startDrag.apply(window.dd, []);
                            imgEl.hide();
                        };
                    }

                }
                imgEl.setVisible(true);

            },

            markAfterRender : function() {
                this.createMarkChange(this);
            },

            afterLayout : function(cmp) {
                var imgEl = Ext.get(this.imgId);
                if (imgEl != null) {
                    imgEl.anchorTo(cmp.getId(), 'tl', null, false, true);
                }
            },

            /**
             * Mostra ou esconde o indicador de valor alterado (doritos).
             * 
             * @param markChanged <code>true</code> para mostrar o indicador, <code>false</code> para esconder
             */
            markChanged : function(markChanged) {
                if (markChanged) {
                    if (this.rendered) {
                        this.createMarkChange(this);
                    } else {
                        this.on("afterrender", this.markAfterRender);
                    }
                } else {

                    var imgEl = Ext.get(this.imgId);
                    if (imgEl) {
                        imgEl.setVisible(false);
                    } else {
                        this.un("afterrender", this.markAfterRender);
                    }
                }
            },

            /**
             * Verifica na hierquia se existe uma janela modal
             */
            getModal : function(component) {
                var container = component.ownerCt;
                while (container != null) {
                    if (container.xtype == "seniorwindow") {
                        return container;
                    }
                    container = container.ownerCt;
                }
                return null;
            }

        });

        owner.on('afterrender', this.onOwnerAfterRender, owner, {
            single : true
        });

    },

    onOwnerAfterRender : function() {
        if (this.hasError === true) {
            this.setHasError(true);
        }

        /* changedMark � uma flag que vem do servidor se o componente estiver alterado na renderiza��o*/
        if (this.changedMark === undefined) {
            return;
        }

        if (!this.ownerCt || !Ext.get(this.imgId)) {
            this.markChanged(this.changedMark);

        }

        delete this.changedMark;
    }

});

Ext.preg('fieldstatus', Ext.ux.senior.plugins.FieldStatusPlugin);