Ext.namespace('Ext.ux.senior.plugins');

Ext.ux.senior.plugins.DragDropPlugin = Ext.extend(Object, {

    init : function(owner) {
        Ext.apply(owner, {
            onRender : owner.onRender.createSequence(function(ct, position) {
                /*  verifica se  uma grid "!this.enableDragDrop" */
                if (this.dragGroups && !this.gridDragZone && !this.treeDragZone) {
                    this.dd = new Ext.ux.senior.SeniorDD(this, this.dragGroups[0]);
                    for ( var i = 1; i < this.dragGroups.length; i++) {
                        this.dd.addToGroup(this.dragGroups[i]);
                    }
                    this.dd.componentOwner = owner;
                }
                if (this.gridDragZone) {
                    /* this.getView().dragZone.on("startdrag",this.startDrag,this); */
                    var dragZone = this.getView().dragZone;
                    Ext.apply(dragZone, {
                        startDrag : dragZone.startDrag.createSequence(function(x, y) {
                            var cmp = Ext.getCmp(this.grid.getEl().id);
                            var reqObj = {
                                id : cmp.getId(),
                                type : 'dragperformed',
                                properties : []
                            };

                            /* tratamento especfico para a grid*/
                            if (cmp.xtype == "senioreditorgrid" && cmp.rowOver != null) {
                                reqObj.eventParams = {
                                    row : cmp.getRowOver()
                                };
                            }
                            var conn = ConnectionManager.connectionFor(cmp);
                            reqObj.target = conn.context;
                            conn.connection[ConnectionManager.DEFAULT_URL].enqueueRequest(reqObj);
                        })
                    });
                }
                if (this.dropGroups) {
                    var configGroups = {
                        "ddGroup" : this.dropGroups[0]
                    };
                    this.ddt = new Ext.ux.senior.SeniorDDTarget(this.getEl().dom, configGroups);
                    for ( var i = 1; i < this.dropGroups.length; i++) {
                        this.ddt.addToGroup(this.dropGroups[i]);
                    }
                }
                if (this.gridDropZone || this.gridDragZone) {
                /* Adicionado para que o Drag'n'Drop saiba em qual linha o Evento de Drop Ocorreu */
                    this.on('rowmouseover', this.notifyRowOver, this);
                }
            })

        });
    }
});

Ext.preg('dragdrop', Ext.ux.senior.plugins.DragDropPlugin);