SubstituteUserPage = {
    name : "SubstituteUserPage",

    /**
     * Configura os estilos e o foco depois que a pagina de usurio substituto 
     * renderizada.
     */
    afterRender : function() {
        this.dynamicCSS();
        this.updateTitle();
        this.setStyle();
        this.removeIncorrectBorders();
        this.rendered = true;
    },

    /**
     * Informa se a pgina de usurio substituto j est renderizada.
     */

    /**
     * Mtodo que define qual ser o css da pagina
     */
    dynamicCSS : function() {
        // O Css  injetado na pagina atraves da classe LoginPage.jet
    },

    /**
     * Modifica o ttulo da pgina.
     */
    updateTitle : function() {
        Senior.changeWindowTitle("Usurio Substituto");
    },

    /**
     * Adiciona estilos panel da tela de login.
     */
    setStyle : function() {
        Ext.getCmp('usersInternalPanel').body.setStyle({
            borderColor : 'transparent',
            backgroundColor : 'transparent'
        });
        Ext.getCmp('usersExternalPanel').body.setStyle({
            borderColor : 'transparent',
            backgroundColor : 'transparent'
        });
        Ext.getCmp('usersExternalPanel').header.setStyle({
            borderColor : 'transparent',
            backgroundColor : 'transparent',
            backgroundImage : 'none',
            paddingLeft : '0px'
        });
    },

    removeIncorrectBorders : function() {
        var loginPanel = Ext.getCmp('loginInternalPanel');
        var body = loginPanel.body;
        body.setWidth(body.getWidth() - body.getBorderWidth('lr'));
    },

    /**
     * Inicializa os componentes da tela de usurio substituto e cria os
     * tratamentos de conexo e request.
     */
    initComponents : function() {
        this.render();

        ConnectionManager.conn = null;
        ConnectionManager.context = null;
        ConnectionManager.registerContext("SubstituteUserPage", null);

        var connection = ConnectionManager.getConnection();
        var onSuccess = connection.onSuccess;
        var onFailure = connection.onFailure;

        connection.loginResponse = null;
        connection.observe(this);

        connection.onSuccess = function(response, options) {
            onSuccess.apply(connection, [ response, options ]);

            if (!this.loginResponse.success) {
                if (this.loginResponse.type == "fatal") {
                    CriticalErrorPage.render(this.loginResponse.title, this.loginResponse.message, this.loginResponse.stackTrace, this.loginResponse.dateTime, true);
                }
                ProcessManager.finishProcess();
            }
        };

        connection.onFailure = function(response, status) {
            onFailure.apply(connection, [ response, status ]);

            CriticalErrorPage.render("Erro", "Ocorreu um problema com a conex&atilde;o com o servidor", "", new Date().format('d/M/y H:m:s'), true);

            ProcessManager.finishProcess();
        };
    },

    afterRequest : function() {
        ConnectionManager.getConnection().setServerIdle();
        ConnectionManager.setUserActionDone(true);
    },

    sendOkRequest : function() {
        var requestParams = {
            joinedUserConfirmation : true
        };
        this.sendRequest(requestParams);
    },

    sendUserRequest : function(userId) {
        var requestParams = {
            substituteUserId : userId
        };
        this.sendRequest(requestParams);
    },

    sendRequest : function(requestParams) {
        requestParams.subsUserReq = true;
        var connection = ConnectionManager.getConnection();
        connection.sendHttpRequest(requestParams);

        ProcessManager.startProcess(true);
    },

    /**
     * Renderiza a tela de login.
     */
    render : function() {
        new Ext.ux.senior.Viewport({
            xtype : "seniorpanel",
            id : "loginExternalPanel",
            name : "loginExternalPanel",
            layout : "vbox",
            layoutConfig : {
                align : "center",
                pack : "center"
            },
            items : [ {
                xtype : "seniorpanel",
                id : "loginInternalPanel",
                height : 230,
                layout : {
                    type : "vbox",
                    align : "center"
                },
                items : [ {
                    xtype : "seniorpanel",
                    height : 120,
                    name : "loginLogoPanel",
                    id : "loginLogoPanel"
                }, {
                    xtype : "seniorgroupbox",
                    id : "usersExternalPanel",
                    title : "Seleo de usurio substituto:",
                    cls : "substituteUserGroupbox",
                    width : "100%",
                    autoScroll : true,
                    items : [ {
                        xtype : "seniorpanel",
                        id : "usersInternalPanel",
                        layout : "seniorform",
                        name : "usersPanel",
                        width : "100%"
                    } ]
                } ]
            } ]
        });

        this.afterRender();
    },

    /**
     * Destroy a tela de login.
     */
    destroy : function() {
        try {
            Ext.getCmp('mainPanel').destroy();
        } catch (e) {
        }

        document.body.innerHTML = "";

        // remove
        var arrayStyleClass = new Ext.Element(document.body).getAttribute("class").split(" ");
        var newStyleClass = "";
        var length = arrayStyleClass.length;
        for ( var i = 0; i < length; i++) {
            if (arrayStyleClass[i].indexOf("login") == -1) {
                newStyleClass += " " + arrayStyleClass[i];
            }
        }

        document.body.setAttribute("class", newStyleClass);
    },

    /**
     * Renderiza a lista de usurios substitutos.
     * 
     * @param userList
     *            Lista contendo id e nome de cada usurio
     */
    renderSubstituteUserList : function(substituteUserType, userList) {
        var loginExternalPanel = Ext.getCmp('loginExternalPanel');
        var loginInternalPanel = Ext.getCmp('loginInternalPanel');
        var usersExternalPanel = Ext.getCmp('usersExternalPanel');
        var usersInternalPanel = Ext.getCmp('usersInternalPanel');

        var maxWidth = 0;
        var elements = new Array();

        if (substituteUserType == 'JOINED') {

            usersExternalPanel.setTitle(' Voc est substituindo: ');

            var size = usersExternalPanel.getEl().getTextWidth();
            if (size > maxWidth) {
                maxWidth = size;
            }

            var userLabel;
            for ( var i = 0; i < userList.length; i++) {
                userLabel = new Ext.ux.senior.form.Label({
                    xtype : "seniorlabel",
                    width : "100%",
                    height : "22",
                    id : "substituteUser" + i,
                    text : userList[i].name
                });
                usersInternalPanel.add(userLabel);
                elements.push(userLabel);
            }

            var continuePanel = new Ext.ux.senior.Panel({
                xtype : "seniorpanel",
                width : "100%",
                height : 28,
                layout : "hbox",
                layoutConfig : {
                    pack : "center"
                },
                margins : "5 0 0 0",
                items : [ {
                    xtype : "seniorbutton",
                    text : "Continuar",
                    id : "continueButton",
                    height : 24,
                    listeners : {
                        'click' : function(btn, evt) {
                            SubstituteUserPage.sendOkRequest();
                        }
                    }
                } ]
            });
            loginInternalPanel.add(continuePanel);
            loginExternalPanel.doLayout(false, true);
            continuePanel.body.setStyle({
                borderColor : 'transparent',
                backgroundColor : 'transparent'
            });

        } else {
            usersExternalPanel.setTitle(' Seleo de usurio substituto: ');

            var size = usersExternalPanel.getEl().getTextWidth();
            if (size > maxWidth) {
                maxWidth = size;
            }

            var button;
            for ( var i = 0; i < userList.length; i++) {
                var id = userList[i].id;
                button = new Ext.ux.senior.Button({
                    xtype : "seniorbutton",
                    text : userList[i].name,
                    kind : "FLATBUTTON",
                    userId : id,
                    id : "substituteUser" + i,
                    width : "100%",
                    height : "24",
                    cls : "substituteUserButton",
                    listeners : {
                        'click' : function(btn, evt) {
                            SubstituteUserPage.sendUserRequest(btn.userId);
                        }
                    }
                });
                usersInternalPanel.add(button);

                elements.push(button);
            }

        }
        this.calculateHeight(substituteUserType, userList.length);

        loginExternalPanel.doLayout(false, true);

        for ( var i = 0; i < elements.length; i++) {
            var size = elements[i].getEl().getTextWidth();
            if (size > maxWidth) {
                maxWidth = size;
            }
        }

        if (substituteUserType == 'JOINED') {
            maxWidth += 40;
        } else {
            maxWidth -= 40;
        }

        Ext.getCmp("loginExternalPanel").setWidth(maxWidth);
        Ext.getCmp("loginLogoPanel").setWidth(maxWidth);
        Ext.getCmp("usersExternalPanel").setWidth(maxWidth);
        Ext.getCmp("loginInternalPanel").setWidth(maxWidth);

        //loginExternalPanel.setVisible(true);
        loginExternalPanel.doLayout(false, true);

    },

    calculateHeight : function(substituteUserType, listCount) {
        var labelHeight = 23;
        var buttonHeight = 24;
        var logoPanelHeight = 120;
        var panelTitleHeight = 33;
        var continuePanelHeight = 28;
        var offsetHeight = 15;
        var singleOffsetHeight = 10;
        var joinedMaxHeight = 300;
        var singleMaxHeight = 307;
        var singleMessageHeight = 20;

        var loginInternalPanel = Ext.getCmp('loginInternalPanel');
        var usersExternalPanel = Ext.getCmp('usersExternalPanel');
        var usersInternalPanel = Ext.getCmp('usersInternalPanel');

        var usersInternalHeight;
        var usersExternalHeight;
        var loginInternalHeight;

        if (substituteUserType == 'JOINED') {
            usersInternalHeight = labelHeight * listCount;
            usersExternalHeight = usersInternalHeight + panelTitleHeight;
            loginInternalHeight = usersExternalHeight + logoPanelHeight + continuePanelHeight + offsetHeight;

            if (loginInternalHeight > joinedMaxHeight) {
                usersExternalHeight = joinedMaxHeight - logoPanelHeight - continuePanelHeight - offsetHeight;
                loginInternalHeight = joinedMaxHeight;
            }
        } else {
            usersInternalHeight = buttonHeight * listCount;
            usersExternalHeight = usersInternalHeight + panelTitleHeight + singleOffsetHeight;
            loginInternalHeight = usersExternalHeight + logoPanelHeight + offsetHeight + singleMessageHeight;

            if (loginInternalHeight > singleMaxHeight) {
                usersExternalHeight = singleMaxHeight - logoPanelHeight - offsetHeight - singleMessageHeight;
                loginInternalHeight = singleMaxHeight;
            }
        }

        usersInternalPanel.setHeight(usersInternalHeight);
        loginInternalPanel.setHeight(loginInternalHeight);
        usersExternalPanel.setHeight(usersExternalHeight);
        
        var parent = Ext.get(usersInternalPanel.getEl().dom.parentNode);
        parent.setStyle("height", Math.min(usersInternalHeight, logoPanelHeight) + "px");
    }

};