QuestionPage = {
    name : "QuestionPage",

    sessionExpiredMessage : "Your session has expired due to inactivity.",

    /**
     * Configura os estilos e o foco depois que a pagina de pergunta  renderizada.
     */
    afterRender : function() {
        this.dynamicCSS();
        this.setStyle();
        this.removeIncorrectBorders();
        this.updateTitle();
        this.rendered = true;
    },

    /**
     * Forma que o pergunta foi feito: click no boto logar ou enter precionado nos edits
     */
    okType : "click",
    /**
     * Diz se a pagina de pergunta j est renderizada.
     */
    rendered : false,

    /**
     * Mtodo que define qual ser o css da pagina
     */
    dynamicCSS : function() {
        //O Css  injetado na pagina atraves da classe QuestionPage.jet
    },

    /**
     * Modifica o titulo da aba.
     */
    updateTitle : function() {
        Senior.changeWindowTitle("Pergunta");
    },

    /**
     * Adiciona estilos panel da tela de pergunta.
     */
    setStyle : function() {
        Ext.getCmp('boxPanel').body.setStyle({
            borderColor : 'transparent',
            backgroundColor : 'transparent'
        });
        Ext.getCmp("buttonPanel").body.setStyle({
            borderColor : 'transparent',
            backgroundColor : 'transparent'
        });
        Ext.getCmp('titlePanel').header.setStyle({
            backgroundImage : 'none',
            borderColor : 'transparent',
            backgroundColor : 'transparent',
            textAlign : 'center'
        });
    },

    /**
     * Foca o campo de usuario quando a tela de pergunta  aberta.
     */
    focusFirst : function() {
        var firstFocus = Ext.getCmp("asw0");
        firstFocus.focus(true, 10);
    },

    /**
     * Inicializa os componentes da tela de pergunta e cria os tratamentos de conexo e request.
     */
    initComponents : function() {
        this.render();

        ConnectionManager.conn = null;
        ConnectionManager.context = null;
        ConnectionManager.registerContext("QuestionPage", null);

        var connection = ConnectionManager.getConnection();
        var onSuccess = connection.onSuccess;
        var onFailure = connection.onFailure;

        connection.loginResponse = null;
        connection.observe(this);

        connection.onSuccess = function(response, options) {
            onSuccess.apply(connection, [ response, options ]);

            if (!this.loginResponse.success) {
                if (this.loginResponse.type == "fatal") {
                    CriticalErrorPage.render(this.loginResponse.title, this.loginResponse.message, this.loginResponse.stackTrace, this.loginResponse.dateTime, true);
                } else {
                    Ext.getCmp('ok').setMessageHint(this.loginResponse.message, true);
                    Ext.getCmp('ok').setMessageVisible(true);
                }
                ProcessManager.finishProcess(true);
            }
        };

        connection.onFailure = function(response, status) {
            onFailure.apply(connection, [ response, status ]);

            var btnOk = Ext.getCmp('ok');
            btnOk.setMessageHint('Ocorreu um problema com a conex&atilde;o com o servidor');
            btnOk.setMessageVisible(true);

            ProcessManager.finishProcess();
        };
    },

    afterRequest : function() {
        ConnectionManager.getConnection().setServerIdle();
        ConnectionManager.setUserActionDone(true);
    },

    sendRequestQuestion : function() {
        var requestParams = {};
        var listResponse = this.getListResponse();

        for ( var i = 0; i < listResponse.length; i++) {
            requestParams['asw' + i] = listResponse[i];
        }
        requestParams['scrReq'] = true;

        this.sendRequest(requestParams);
    },

    getListResponse : function() {
        var boxPanel = Ext.getCmp("boxPanel");
        var items = boxPanel.items.items;
        var response = [];
        var indexListResponse = 0;
        //O index esta sendo incrementado em i+2 para evidar validar se  um textfield. (Lista ordenada com label e textfield)
        for ( var i = 1, len = items.length; i < len; i += 2, indexListResponse++) {
            response[indexListResponse] = items[i].getValue();
        }
        return response;
    },

    sendRequest : function(requestParams) {
        requestParams.scrReq = true;
        var connection = ConnectionManager.getConnection();

        connection.sendHttpRequest(requestParams);
        ProcessManager.startProcess(true);
    },

    sendRequestCancel : function() {
        var requestParams = {
            cancel : true,
            srcReq : true
        };

        this.sendRequest(requestParams);
    },

    /**
     * Renderiza a tela de pergunta.
     */
    render : function() {
        new Ext.ux.senior.Viewport({
            xtype : "seniorpanel",
            id : "loginExternalPanel",
            name : "loginExternalPanel",
            layout : "hbox",
            layoutConfig : {
                align : "middle",
                pack : "center"
            },
            items : [ {
                xtype : "seniorpanel",
                id : "loginInternalPanel",
                height : 230,
                width : 400,
                modal : false,
                closable : false,
                layout : "seniorborder",
                items : [ {
                    xtype : "seniorpanel",
                    region : "north",
                    width : 400,
                    height : 120,
                    name : "loginLogoPanel",
                    id : "loginLogoPanel"
                }, {
                    xtype : "seniorpanel",
                    id : "titlePanel",
                    region : "center",
                    title : "Responda as seguintes perguntas:",
                    items : [ {
                        xtype : "seniorpanel",
                        layout : "seniorform",
                        labelAlign : "right",
                        buttonAlign : "center",
                        autoScroll : true,
                        name : "boxPanel",
                        id : "boxPanel",
                        margins : {
                            top : 0,
                            right : 0,
                            bottom : 0,
                            left : 0
                        }
                    } ]
                }, {
                    xtype : "seniorpanel",
                    bodyBorder : true,
                    region : "south",
                    layout : "seniorflowlayout",
                    name : "buttonPanel",
                    height : 30,
                    margins : "10px 0px 5px 0px",
                    id : "buttonPanel",
                    items : [ {
                        xtype : "seniorbutton",
                        id : "ok",
                        text : "OK",
                        labelStyle : 'background: transparent',
                        width : 60,
                        plugins : [ 'informationtipsplugin', 'componentfocusplugin' ],
                        listeners : {
                            'click' : function(btn, evt) {
                                QuestionPage.okType = "click";
                                QuestionPage.sendRequestQuestion();
                            }
                        }
                    }, {
                        xtype : "seniorbutton",
                        id : "cancel",
                        text : "Cancelar",
                        labelStyle : 'background: transparent',
                        width : 60,
                        plugins : [ 'informationtipsplugin', 'componentfocusplugin' ],
                        margins : "5px",
                        listeners : {
                            'click' : function(btn, evt) {
                                QuestionPage.sendRequestCancel();
                            }
                        }
                    } ]
                } ]
            } ]
        });

        QuestionPage.afterRender();
    },

    navigateKey : function() {
        var hideHint = function(textfield, evt) {
            var btnLogin = Ext.getCmp('ok');
            btnLogin.setMessageVisible(false);
        };

        var keyDownInterceptor = function(evt) {
            return evt.getCharCode() === evt.BACKSPACE || evt.getCharCode() === evt.DELETE;
        };

        var aswEl = Ext.getCmp("asw0").getEl();

        aswEl.on("keypress", hideHint);
        aswEl.on("keydown", hideHint.createInterceptor(keyDownInterceptor));

        var listSize = this.getListResponse();// ->utiliza este mtodo s para saber quantos textFields existem
        for ( var i = 0; i < listSize.length - 1; i++) {
            Ext.getCmp("asw" + i).getEl().on("keydown", function(e) {
                if (e.getKey() == e.ENTER) {
                    e.stopEvent();
                    QuestionPage.loginType = "key";
                    QuestionPage.sendRequestQuestion();
                    Ext.getCmp("asw" + i).focus(true, 10);
                }
            }, this);
        }
    },
    /**
     * Destroy a tela de pergunta.
     */
    destroy : function() {
        try {
            Ext.getCmp('mainPanel').destroy();
        } catch (e) {
        }

        document.body.innerHTML = "";
        //remove 
        var arrayStyleClass = new Ext.Element(document.body).getAttribute("class").split(" ");
        var newStyleClass = "";
        var length = arrayStyleClass.length;
        for ( var i = 0; i < length; i++) {
            if (arrayStyleClass[i].indexOf("ok") == -1) {
                newStyleClass += " " + arrayStyleClass[i];
            }
        }

        document.body.setAttribute("class", newStyleClass);
    },

    renderQuestionTextList : function(questionList) {
        var loginExternalPanel = Ext.getCmp('loginExternalPanel');
        var boxPanel = Ext.getCmp("boxPanel");
        var aswTextfield;
        var qstLabel;

        for ( var i = 0; i < questionList.length; i++) {
            qstLabel = new Ext.ux.senior.form.Label({
                xtype : "seniorlabel",
                id : "qst" + i,
                text : questionList[i].text,
                margins : "0px 0px 5px 0px"
            });
            aswTextfield = new Ext.ux.senior.form.TextField({
                xtype : "seniortextfield",
                id : "asw" + i,
                width : 360,
                hideLabel : true,
                margins : "0px 0px 5px 0px",
                plugins : [ 'componentfocusplugin' ]
            });

            boxPanel.add(qstLabel);
            boxPanel.add(aswTextfield);
        }

        this.calculateHeight(questionList.length);
        loginExternalPanel.doLayout(false, true);
        this.navigateKey();

        for ( var i = 0; i < questionList.length; i++) {
            var aswTextfield = Ext.getCmp("asw" + i);
            aswTextfield.setFocusGroup("defaultGroup");
            aswTextfield.setFocusOrder(i + 1);
            aswTextfield.conn = {
                connection : ConnectionManager.getConnection()
            };
        }

        var btnOk = Ext.getCmp("ok");
        btnOk.setFocusGroup("defaultGroup");
        btnOk.setFocusOrder(questionList.length + 1);
        btnOk.conn = {
            connection : ConnectionManager.getConnection()
        };

        var btnCancel = Ext.getCmp("cancel");
        btnCancel.setFocusGroup("defaultGroup");
        btnCancel.setFocusOrder(questionList.length + 2);
        btnCancel.conn = {
            connection : ConnectionManager.getConnection()
        };

        this.focusFirst();
    },

    removeIncorrectBorders : function() {
        var loginPanel = Ext.getCmp('loginInternalPanel');
        var body = loginPanel.body;
        body.setWidth(body.getWidth() - body.getBorderWidth('lr'));
    },

    showSessionExpiredMsg : function() {
        var btnLogin = Ext.getCmp('ok');
        btnLogin.setMessageHint(QuestionPage.sessionExpiredMessage);
        btnLogin.setMessageVisible.defer(100, btnLogin, [ true ]);
    },

    calculateHeight : function(listCount) {
        var questionHeight = 49;
        var logoPanelHeight = 120;
        var continuePanelHeight = 28;
        var offsetHeight = 25;
        var boxPanelMaxHeight = 150;
        var loginInternalMaxHeight = 345;
        var titleTextHeight = 13;

        var loginInternalPanel = Ext.getCmp('loginInternalPanel');
        var loginExternalPanel = Ext.getCmp("loginExternalPanel");
        var boxPanel = Ext.getCmp('boxPanel');
        var titlePanel = Ext.getCmp('titlePanel');

        var boxPanelHeight;
        var loginInternalHeight;
        var titlePanelHeight;

        boxPanelHeight = questionHeight * listCount;
        titlePanelHeight = boxPanelHeight + titleTextHeight;
        loginInternalHeight = titlePanelHeight + logoPanelHeight + continuePanelHeight + offsetHeight;

        if (boxPanelHeight > boxPanelMaxHeight) {
            boxPanelHeight = boxPanelMaxHeight;//ajustar painel para caber no maximo 3 perguntas sem gerar scroll
        }

        if (loginInternalHeight > loginInternalMaxHeight) {
            loginInternalHeight = loginInternalMaxHeight;
        }

        boxPanel.setHeight(boxPanelHeight);
        loginInternalPanel.setHeight(loginInternalHeight);
        loginExternalPanel.setHeight(loginInternalHeight);
        titlePanel.setHeight(titlePanelHeight);
    }
};
