LoginPage = {
    name : "LoginPage",

    sessionExpiredMessage : "Your session has expired due to inactivity.",

    /**
     * Configura os estilos e o foco depois que a pagina de login  renderizada.
     */
    afterRender : function() {
        this.dynamicCSS();
        this.setStyle();
        this.removeIncorrectBorders();
        this.focusFirst();
        this.updateTitle();
        this.rendered = true;

        ProcessManager.finishProcess(true);
    },

    /**
     * Forma que o login foi feito: click no boto logar ou enter precionado nos edits
     */
    loginType : "click",
    /**
     * Diz se a pagina de login j est renderizada.
     */
    rendered : false,

    /**
     * Mtodo que define qual ser o css da pagina
     */
    dynamicCSS : function() {
        //O Css  injetado na pagina atraves da classe LoginPage.jet
    },

    /**
     * Modifica o titulo da aba.
     */
    updateTitle : function() {
        Senior.changeWindowTitle("Autenticao");
    },

    /**
     * Adiciona estilos panel da tela de login.
     */
    setStyle : function() {
        Ext.getCmp('boxPanel').body.setStyle({
            borderColor : 'transparent',
            backgroundColor : 'transparent'
        });

        Ext.getCmp('tablePanel').body.setStyle({
            borderColor : 'transparent',
            backgroundColor : 'transparent'
        });
        Ext.getCmp('tablePanel').header.setStyle({
            backgroundImage : 'none',
            borderColor : 'transparent',
            backgroundColor : 'transparent',
            textAlign : 'center'
        });
        Ext.getCmp('buttonPanelLogin').body.setStyle({
            borderColor : 'transparent',
            backgroundColor : 'transparent'
        });
        Ext.getCmp('buttonPanelUsr').body.setStyle({
            borderColor : 'transparent',
            backgroundColor : 'transparent'
        });
    },

    hidePasswordComponent : function() {
        Ext.getCmp("buttonPanelLogin").hide();
        Ext.getCmp("psw").hide();
        Ext.getCmp("buttonPanelUsr").setVisible(true);
        Ext.getCmp('tablePanel').setTitle("Favor informar o nome do usurio para recuperao de senha:");
    },

    /**
     * Foca o campo de usuario quando a tela de login  aberta.
     */
    focusFirst : function() {
        var firstFocus = Ext.getCmp("usr");
        firstFocus.focus(true, 10);
    },

    /**
     * Inicializa os componentes da tela de login e cria os tratamentos de conexo e request.
     */
    initComponents : function(usernameOnly, username) {
        this.render();
        if (usernameOnly) {
            this.hidePasswordComponent();
            if (username) {
                Ext.getCmp('usr').setValue(username);
            }
        }
        ConnectionManager.conn = null;
        ConnectionManager.context = null;
        ConnectionManager.registerContext("LoginPage", null);

        var connection = ConnectionManager.getConnection();
        var onSuccess = connection.onSuccess;
        var onFailure = connection.onFailure;

        connection.loginResponse = null;
        connection.observe(this);

        connection.onSuccess = function(response, options) {
            onSuccess.apply(connection, [ response, options ]);

            if (!this.loginResponse.success) {
                if (this.loginResponse.type == "fatal") {
                    document.title = this.loginResponse.title;
                    document.body.innerHTML = this.loginResponse.pageError;
                } else {
                    var messageCmp;
                    // Define se est na tela padro de login ou na tela de recuperao de senha (apenas o campo usurio visvel)
                    var isLoginPage = Ext.getCmp("buttonPanelLogin").isVisible();
                    if (isLoginPage) {
                        messageCmp = Ext.getCmp('login');
                    } else {
                        messageCmp = Ext.getCmp('usr');
                    }

                    messageCmp.setMessageHint(this.loginResponse.message, true);
                    messageCmp.setMessageVisible(true);
                    var tfUsr = Ext.getCmp('usr');

                    var focusCmp;
                    if (isLoginPage) {
                        focusCmp = Ext.getCmp('psw');
                    } else {
                        focusCmp = Ext.getCmp('usr');
                    }

                    if (LoginPage.loginType == "click") {
                        focusCmp.focus(true, 10);
                    } else if (!tfUsr.getEl().hasClass(tfUsr.focusClass) && LoginPage.loginType == "key") {
                        focusCmp.focus(true, 10);
                    }
                }
                ProcessManager.finishProcess();
            }
        };

        connection.onFailure = function(response, status) {
            onFailure.apply(connection, [ response, status ]);

            var btnLogin = Ext.getCmp('login');
            btnLogin.setMessageHint('Ocorreu um problema com a conex&atilde;o com o servidor', true);
            btnLogin.setMessageVisible(true);

            ProcessManager.finishProcess();
        };
        
        window.onunload = function(event) {
            var connection = ConnectionManager.getConnection();
            
            // no precisa finalizar a sesso caso o "unload" seja gerado por sucesso em alguma etapa do login
            if (!connection.loginResponse || !connection.loginResponse.success) {
                var xmlHttp = new XMLHttpRequest();
                xmlHttp.open('POST', "destroy?perspective=loginPage", false);
                xmlHttp.send();
            }
        };
    },

    afterRequest : function() {
        ConnectionManager.getConnection().setServerIdle();
        ConnectionManager.setUserActionDone(true);
    },

    sendRequest : function(requestParams) {
        var connection = ConnectionManager.getConnection();
        connection.sendHttpRequest(requestParams);

    },

    sendCancelRequest : function() {
        var requestParams = {
            cancel : true,
            scrReq : true
        };
        this.sendRequest(requestParams);
    },

    sendRequestLogin : function() {
        var requestParams = {
            usr : Ext.getCmp('usr').getValue(),
            psw : Ext.getCmp('psw').getValue(),
            scrReq : true
        };
        this.sendRequest(requestParams);
    },

    sendRequestQuestionPage : function() {
        var requestParams = {
            usr : Ext.getCmp('usr').getValue(),
            fgtPsw : true,
            scrReq : true
        };
        this.sendRequest(requestParams);
    },

    sendForgotPasswordUserInformed : function() {
        var requestParams = {
            usr : Ext.getCmp('usr').getValue(),
            scrReq : true
        };
        this.sendRequest(requestParams);
    },

    /**
     * Renderiza a tela de login.
     */
    render : function() {

        var pswPlugins = [];

        if (!Senior.hasNativeCapsLockInformation()) {
            pswPlugins = [ "capslockplugin" ];
        }

        new Ext.ux.senior.Viewport({
            xtype : "seniorpanel",
            id : "loginExternalPanel",
            name : "loginExternalPanel",
            layout : "hbox",
            layoutConfig : {
                align : "middle",
                pack : "center"
            },
            items : [ {
                xtype : "seniorpanel",
                id : "loginInternalPanel",
                height : 230,
                width : 400,
                modal : false,
                closable : false,
                layout : "seniorborder",
                items : [ {
                    xtype : "seniorpanel",
                    region : "north",
                    height : 100,
                    name : "loginLogoPanel",
                    id : "loginLogoPanel"
                }, {
                    xtype : "seniorpanel",
                    id : "tablePanel",
                    modal : false,
                    closable : false,
                    region : "center",
                    padding : 15,
                    layout : 'seniortable',
                    layoutConfig : {
                        columns : 1
                    },
                    defaults : {},
                    header : true,
                    items : [ {
                        xtype : "seniorpanel",
                        layout : "seniorform",
                        labelAlign : "right",
                        buttonAlign : "center",
                        name : "boxPanel",
                        id : "boxPanel",
                        items : [ {
                            xtype : "seniortextfield",
                            id : "usr",
                            fieldLabel : "Usurio",
                            width : 210,
                            plugins : [ "informationtipsplugin", "fieldstyle" ]
                        }, {
                            xtype : "seniortextfield",
                            id : "psw",
                            inputType : "password",
                            fieldLabel : "Senha",
                            width : 210,
                            plugins : pswPlugins
                        } ]
                    }, {
                        xtype : "seniorpanel",
                        id : "buttonPanelUsr",
                        modal : false,
                        region : "center",
                        closable : false,
                        hidden : true,
                        layout : 'seniortable',
                        layoutConfig : {
                            columns : 3
                        },
                        defaults : {
                            style : 'margin: 2.5px 2.5px 2.5px 0px'
                        },
                        items : [ {
                            xtype : "seniorlabel",
                            id : "labelEmptyUsr",
                            width : 103,
                            cellCls : "ux-gridlayout-cell-horizontal-right",
                            text : " "
                        }, {
                            xtype : "seniorbutton",
                            id : "ok",
                            text : "OK",
                            labelStyle : 'background: transparent',
                            hideLabel : false,
                            fieldLabel : " ",
                            labelSeparator : "",
                            width : 60,
                            plugins : [ 'informationtipsplugin' ],
                            listeners : {
                                'click' : function(btn, evt) {
                                    LoginPage.sendForgotPasswordUserInformed();
                                }
                            }
                        }, {
                            xtype : "seniorbutton",
                            id : "cancel",
                            text : "Cancelar",
                            labelStyle : 'background: transparent',
                            width : 60,
                            plugins : [ 'informationtipsplugin' ],
                            listeners : {
                                'click' : function(btn, evt) {
                                    LoginPage.sendCancelRequest();
                                }
                            }
                        } ]
                    }, {
                        xtype : "seniorpanel",
                        id : "buttonPanelLogin",
                        modal : false,
                        region : "center",
                        closable : false,
                        layout : 'seniortable',
                        layoutConfig : {
                            columns : 3
                        },
                        items : [ {
                            xtype : "seniorlabel",
                            id : "labelEmptyLogin",
                            width : 103,
                            cellCls : "ux-gridlayout-cell-horizontal-right",
							style: {
                                margin: '2px 2px 2px 0px'
                            },
                            text : " "
                        }, {
                            xtype : "seniorbutton",
                            id : "login",
                            text : "Entrar",
                            applyStylesToText : false,
                            style : {
                                margin: '0px 6px 0px 0px'
                            },
                            hideLabel : false,
                            fieldLabel : " ",
                            labelSeparator : "",
                            labelStyle : 'background: transparent',
                            width : 60,
                            plugins : [ 'informationtipsplugin' ],
                            listeners : {
                                'click' : function(btn, evt) {
                                    LoginPage.loginType = "click";
                                    LoginPage.sendRequestLogin();
                                }
                            }
                        }, {
                            xtype : "seniorlink",
                            id : "forgottenPwd",
                            name : "forgottenPwd",
                            text : "Esqueci minha senha",
                            hideLabel : false,
                            fieldLabel : " ",
                            selectText : false,
                            cellCls : "ux-gridlayout-cell-horizontal-right",
                            labelSeparator : "",
                            labelStyle : 'background: transparent',
                            plugins : [ 'informationtipsplugin' ],
                            style: {
                                margin: '2px 2px 2px 0px'
                            },
                            listeners : {
                                'click' : function(btn, evt) {
                                    LoginPage.loginType = "click";
                                    LoginPage.sendRequestQuestionPage();
                                }
                            }
                        } ]
                    } ]
                } ]
            } ]

        });

        var hideHint = function(textfield, evt) {
            var btnLogin = Ext.getCmp('login');
            btnLogin.setMessageVisible(false);
        };

        var keyDownInterceptor = function(evt) {
            return evt.getCharCode() === evt.BACKSPACE || evt.getCharCode() === evt.DELETE;
        };

        var usrEl = Ext.getCmp("usr").getEl();
        var pswEl = Ext.getCmp("psw").getEl();

        usrEl.on("keypress", hideHint);
        usrEl.on("keydown", hideHint.createInterceptor(keyDownInterceptor));
        pswEl.on("keypress", hideHint);
        pswEl.on("keydown", hideHint.createInterceptor(keyDownInterceptor));

        Ext.getCmp("login").getEl().on("keydown", function(e) {
            if (e.getKey() == e.TAB && !e.shiftKey) {
                e.stopEvent();
                var edtUsr = Ext.getCmp("usr");
                edtUsr.focus(true, 10);
            } else if (e.getKey() == e.TAB && e.shiftKey) {
                e.stopEvent();
                var tfPsw = Ext.getCmp("psw");
                tfPsw.focus(true, 10);
            }
        }, this);

        Ext.getCmp("cancel").getEl().on("keydown", function(e) {
            if (e.getKey() == e.TAB && !e.shiftKey) {
                e.stopEvent();
                var edtUsr = Ext.getCmp("usr");
                edtUsr.focus(true, 10);
            } else if (e.getKey() == e.TAB && e.shiftKey) {
                e.stopEvent();
                var btnLogin = Ext.getCmp("ok");
                btnLogin.focus(true, 10);
            }
        }, this);

        Ext.getCmp("ok").getEl().on("keydown", function(e) {
            if (e.getKey() == e.TAB && !e.shiftKey) {
                e.stopEvent();
                var btCancel = Ext.getCmp("cancel");
                btCancel.focus(true, 10);
            } else if (e.getKey() == e.TAB && e.shiftKey) {
                e.stopEvent();
                var tfUsr = Ext.getCmp("usr");
                tfUsr.focus(true, 10);
            }
        }, this);

        Ext.getCmp("usr").getEl().on("keydown", function(e) {
            if (Ext.getCmp("buttonPanelLogin").isVisible()) {
                if (e.getKey() == e.TAB && e.shiftKey) {
                    e.stopEvent();
                    var btnLogin = Ext.getCmp("login");
                    btnLogin.focus(true, 10);
                } else if (e.getKey() == e.TAB && !e.shiftKey) {
                    e.stopEvent();
                    var edtPsw = Ext.getCmp("psw");
                    edtPsw.focus(true, 10);
                } else if (e.getKey() == e.ENTER) {
                    LoginPage.loginType = "key";
                    LoginPage.sendRequestLogin();
                    Ext.getCmp("usr").focus(true, 10);
                }
            } else {
                if (e.getKey() == e.TAB && e.shiftKey) {
                    e.stopEvent();
                    var btCancel = Ext.getCmp("cancel");
                    btCancel.focus(true, 10);
                } else if (e.getKey() == e.TAB && !e.shiftKey) {
                    e.stopEvent();
                    var btnOk = Ext.getCmp("ok");
                    btnOk.focus(true, 10);
                } else if (e.getKey() == e.ENTER) {
                    LoginPage.loginType = "key";
                    LoginPage.sendRequestLogin();
                    Ext.getCmp("usr").focus(true, 10);
                }
            }
        }, this);

        pswEl.on('keydown', function(e) {
            if (e.getKey() == e.ENTER) {
                LoginPage.loginType = "key";
                LoginPage.sendRequestLogin();
            } else if (e.getKey() == e.TAB && e.shiftKey) {
                e.stopEvent();
                var edtUsr = Ext.getCmp("usr");
                edtUsr.focus(true, 10);

            } else if (e.getKey() == e.TAB && !e.shiftKey) {
                e.stopEvent();
                var btnLogin = Ext.getCmp("login");
                btnLogin.focus(true, 10);

            }
        });

        this.afterRender();
    },

    /**
     * Destroy a tela de login.
     */
    destroy : function() {
        try {
            Ext.getCmp('mainPanel').destroy();
        } catch (e) {
        }

        document.body.innerHTML = "";

        //remove 
        var arrayStyleClass = new Ext.Element(document.body).getAttribute("class").split(" ");
        var newStyleClass = "";
        var length = arrayStyleClass.length;
        for ( var i = 0; i < length; i++) {
            if (arrayStyleClass[i].indexOf("login") == -1) {
                newStyleClass += " " + arrayStyleClass[i];
            }
        }

        document.body.setAttribute("class", newStyleClass);
    },

    removeIncorrectBorders : function() {
        var loginPanel = Ext.getCmp('loginInternalPanel');
        var body = loginPanel.body;
        body.setWidth(body.getWidth() - body.getBorderWidth('lr'));
    },

    showSessionExpiredMsg : function() {
        var btnLogin = Ext.getCmp('login');
        btnLogin.setMessageHint(this.sessionExpiredMessage, true);
        btnLogin.setMessageVisible.defer(100, btnLogin, [ true ]);
    }

};