ChangePasswordPage = {
    name : "ChangePasswordPage",

    sessionExpiredMessage : "Your session has expired due to inactivity.",

    /**
     * Configura os estilos e o foco depois que a pagina de alterao de senha  renderizada.
     */
    afterRender : function() {
        this.dynamicCSS();
        this.setStyle();
        this.removeIncorrectBorders();
        this.focusFirst();
        this.updateTitle();
        this.rendered = true;
    },

    /**
     * Click no boto aplicar ou enter precionado nos edits
     */
    loginType : "click",

    /**
     * Diz se a pagina de alterao de senha j est renderizada.
     */
    rendered : false,

    /**
     * Mtodo que define qual ser o css da pagina
     */
    dynamicCSS : function() {
        //O Css  injetado na pagina atraves da classe ChangePasswordPage.jet
    },

    /**
     * Modifica o ttulo da pgina.
     */
    updateTitle : function() {
        Senior.changeWindowTitle("Alterar Senha");
    },

    /**
     * Adiciona estilos panel da tela de Alterao de senha.
     */
    setStyle : function() {
        Ext.getCmp('boxPanel').body.setStyle({
            borderColor : 'transparent',
            backgroundColor : 'transparent'
        });
        Ext.getCmp("buttonPanel").body.setStyle({
            borderColor : 'transparent',
            backgroundColor : 'transparent'
        });
        Ext.getCmp('boxPanel').header.setStyle({
            backgroundImage : 'none',
            borderColor : 'transparent',
            backgroundColor : 'transparent',
            textAlign : 'center'
        });
    },

    /**
     * Foca o campo de senha atual quando a tela de alterao de senha  aberta.
     */
    focusFirst : function() {
        var firstFocus = Ext.getCmp("newPsw");
        firstFocus.focus(true, 10);
    },

    /**
     * Inicializa os componentes da tela de alterar senha e cria os tratamentos de conexo e request.
     */
    initComponents : function() {
        this.render();

        ConnectionManager.conn = null;
        ConnectionManager.context = null;
        ConnectionManager.registerContext("ChangePasswordPage", null);

        var connection = ConnectionManager.getConnection();
        var onSuccess = connection.onSuccess;
        var onFailure = connection.onFailure;

        connection.loginResponse = null;
        connection.observe(this);

        connection.onSuccess = function(response, options) {
            onSuccess.apply(connection, [ response, options ]);

            if (!this.loginResponse.success) {
                if (this.loginResponse.type == "fatal") {
                    CriticalErrorPage.render(this.loginResponse.title, this.loginResponse.message, this.loginResponse.stackTrace, this.loginResponse.dateTime, true);
                } else {
                    var btnApply = Ext.getCmp('apply');
                    btnApply.setMessageHint(this.loginResponse.message);
                    btnApply.setMessageVisible(true);
                    var tfNewPsw = Ext.getCmp('newPsw');

                    if (this.loginType == "apply") {
                        var tfCnfPsw = Ext.getCmp('cnfPsw');
                        tfCnfPsw.focus(true, 10);
                    } else if (!tfNewPsw.getEl().hasClass(tfNewPsw.focusClass) && this.loginType == "key") {
                        var tfCnfPsw = Ext.getCmp('cnfPsw');
                        tfCnfPsw.focus(true, 10);
                    }
                }
                ProcessManager.finishProcess(true);
            }
        };

        connection.onFailure = function(response, status) {
            onFailure.apply(connection, [ response, status ]);

            var btnApply = Ext.getCmp('apply');
            btnApply.setMessageHint('Ocorreu um problema com a conex&atilde;o com o servidor');
            btnApply.setMessageVisible(true);

            ProcessManager.finishProcess();
        };
    },

    afterRequest : function() {
        ConnectionManager.getConnection().setServerIdle();
        ConnectionManager.setUserActionDone(true);
    },

    sendRequest : function() {
        var requestParams = {
            newPsw : Ext.getCmp('newPsw').getValue(),
            cnfPsw : Ext.getCmp('cnfPsw').getValue(),
            scrReq : true
        };
        var connection = ConnectionManager.getConnection();

        connection.sendHttpRequest(requestParams);
        ProcessManager.startProcess(true);
    },

    sendCancelRequest : function(requestParams) {
        var requestParams = {
            cancel : true,
            scrReq : true
        };
        var connection = ConnectionManager.getConnection();

        connection.sendHttpRequest(requestParams);
        ProcessManager.startProcess(true);
    },

    /**
     * Renderiza a tela de Alterao de senha.
     */
    render : function() {
        new Ext.ux.senior.Viewport({
            xtype : "seniorpanel",
            id : "loginExternalPanel",
            name : "loginExternalPanel",
            layout : "hbox",
            layoutConfig : {
                align : "middle",
                pack : "center"
            },
            items : [ {
                xtype : "seniorpanel",
                id : "loginInternalPanel",
                height : 250,
                width : 400,
                modal : false,
                closable : false,
                layout : "seniorborder",
                items : [ {
                    xtype : "seniorpanel",
                    region : "north",
                    height : 100,
                    name : "loginLogoPanel",
                    id : "loginLogoPanel"
                }, {
                    xtype : "seniorpanel",
                    region : "center",
                    layout : 'seniortable',
                    layoutConfig : {
                        columns : 2
                    },
                    defaults : {
                        frame : false,
                        style : 'margin: 2.5px 2.5px 2.5px 0px'
                    },
                    labelAlign : "right",
                    buttonAlign : "center",
                    name : "boxPanel",
                    id : "boxPanel",
                    padding : "15",
                    title : "Informe a nova senha do usurio:",
                    items : [ {
                        xtype : "seniorlabel",
                        id : "lNewPsw",
                        cellCls : "ux-gridlayout-cell-horizontal-right",
                        text : "Nova Senha:"
                    }, {
                        xtype : "seniortextfield",
                        id : "newPsw",
                        inputType : "password",
                        width : "210",
                        plugins : [ "capslockplugin" ]
                    }, {
                        xtype : "seniorlabel",
                        id : "lCnfPsw",
                        cellCls : "ux-gridlayout-cell-horizontal-right",
                        text : "Confirmar Nova Senha:"
                    }, {
                        xtype : "seniortextfield",
                        id : "cnfPsw",
                        inputType : "password",
                        width : "210",
                        plugins : [ "capslockplugin" ]
                    }, {
                        xtype : "seniorlabel",
                        id : "labelEmpty",
                        cellCls : "ux-gridlayout-cell-horizontal-right",
                        text : " "
                    }, {
                        xtype : "seniorpanel",
                        id : "buttonPanel",
                        modal : false,
                        closable : false,
                        layout : 'seniortable',
                        layoutConfig : {
                            columns : 2
                        },
                        defaults : {
                            style : 'margin: 2.5px 2.5px 2.5px 0px'
                        },
                        items : [ {
                            xtype : "seniorbutton",
                            id : "apply",
                            text : "Aplicar",
                            labelStyle : 'background: transparent',
                            width : 60,
                            plugins : [ 'informationtipsplugin' ],
                            listeners : {
                                'click' : function(btn, evt) {
                                    ChangePasswordPage.loginType = "click";
                                    ChangePasswordPage.sendRequest();
                                }
                            }
                        }, {
                            xtype : "seniorbutton",
                            id : "cancel",
                            text : "Cancelar",
                            labelStyle : 'background: transparent',
                            width : 60,
                            plugins : [ 'informationtipsplugin' ],
                            listeners : {
                                'click' : function(btn, evt) {
                                    ChangePasswordPage.sendCancelRequest();
                                }
                            }
                        } ]
                    } ]

                } ]
            } ]
        });

        var hideHint = function(textfield, evt) {
            var btnApply = Ext.getCmp('apply');
            btnApply.setMessageVisible(false);
        };

        var keyDownInterceptor = function(evt) {
            return evt.getCharCode() === evt.BACKSPACE || evt.getCharCode() === evt.DELETE;
        };

        var newPswEl = Ext.getCmp("newPsw").getEl();
        var cnfPswEl = Ext.getCmp("cnfPsw").getEl();

        newPswEl.on("keypress", hideHint);
        newPswEl.on("keydown", hideHint.createInterceptor(keyDownInterceptor));
        cnfPswEl.on("keypress", hideHint);
        cnfPswEl.on("keydown", hideHint.createInterceptor(keyDownInterceptor));

        Ext.getCmp("apply").getEl().on("keydown", function(e) {
            if (e.getKey() == e.TAB && !e.shiftKey) {
                e.stopEvent();
                var btnCancel = Ext.getCmp("cancel");
                btnCancel.focus(true, 10);
            } else if (e.getKey() == e.TAB && e.shiftKey) {
                e.stopEvent();
                var tfCnfPsw = Ext.getCmp("cnfPsw");
                tfCnfPsw.focus(true, 10);
            }
        }, this);

        newPswEl.on("keydown", function(e) {
            if (e.getKey() == e.TAB && e.shiftKey) {
                e.stopEvent();
                var btnCancel = Ext.getCmp("cancel");
                btnCancel.focus(true, 10);
            } else if (e.getKey() == e.TAB && !e.shiftKey) {
                e.stopEvent();
                var edtCnfPsw = Ext.getCmp("cnfPsw");
                edtCnfPsw.focus(true, 10);
            } else if (e.getKey() == e.ENTER) {
                ChangePasswordPage.loginType = "key";
                ChangePasswordPage.sendRequest();
                Ext.getCmp("newPsw").focus(true, 10);
            }
        }, this);

        Ext.getCmp("cancel").getEl().on("keydown", function(e) {
            if (e.getKey() == e.TAB && !e.shiftKey) {
                e.stopEvent();
                var tfNewPsw = Ext.getCmp("newPsw");
                tfNewPsw.focus(true, 10);
            } else if (e.getKey() == e.TAB && e.shiftKey) {
                e.stopEvent();
                var btnApply = Ext.getCmp("apply");
                btnApply.focus(true, 10);
            }
        }, this);

        cnfPswEl.on('keydown', function(e) {
            if (e.getKey() == e.ENTER) {
                ChangePasswordPage.loginType = "key";
                ChangePasswordPage.sendRequest();
            } else if (e.getKey() == e.TAB && e.shiftKey) {
                e.stopEvent();
                var edtNewPsw = Ext.getCmp("newPsw");
                edtNewPsw.focus(true, 10);

            } else if (e.getKey() == e.TAB && !e.shiftKey) {
                e.stopEvent();
                var btnApply = Ext.getCmp("apply");
                btnApply.focus(true, 10);

            }
        });

        this.afterRender();

    },

    /**
     * Destroy a tela de Alterao de senha.
     */
    destroy : function() {
        try {
            Ext.getCmp('mainPanel').destroy();
        } catch (e) {
        }

        document.body.innerHTML = "";

        //remove 
        var arrayStyleClass = new Ext.Element(document.body).getAttribute("class").split(" ");
        var newStyleClass = "";
        var length = arrayStyleClass.length;
        for ( var i = 0; i < length; i++) {
            if (arrayStyleClass[i].indexOf("login") == -1) {
                newStyleClass += " " + arrayStyleClass[i];
            }
        }

        document.body.setAttribute("class", newStyleClass);
    },

    removeIncorrectBorders : function() {
        var loginPanel = Ext.getCmp('loginInternalPanel');
        var body = loginPanel.body;
        body.setWidth(body.getWidth() - body.getBorderWidth('lr'));
    },

    showSessionExpiredMsg : function() {
        var btnApply = Ext.getCmp('apply');
        btnApply.setMessageHint(this.sessionExpiredMessage);
        btnApply.setMessageVisible.defer(100, btnApply, [ true ]);
    }
};