/**
 * Utilizar a nossa blank image, o prprio ext recomenda que faamos o cdigo abaixo
 */
Ext.BLANK_IMAGE_URL = "resources/images/shared/s.gif";

Date.useStrict = true;

/**
 * Object Singleton para agrupar funes utilitrias e atributos Globais da Aplicao, Assim como Ext.js
 */
Senior = {
    name : "Singleton Senior Util Object",

    aborted : false,

    isRefresh : false,

    blockInfId : null,

    toString : function() {
        return this.name;
    }
};

Senior.apply = function(o, c, defaults) {
    /* no "this" reference for friendly out of scope calls */
    if (defaults) {
        Senior.apply(o, defaults);
    }
    if (o && c && typeof c == 'object') {
        for ( var p in c) {
            o[p] = c[p];
        }
    }

    return o;
};

Senior.apply(Senior, {
    /**
     * Deixa a aplicao com status de abortada se a primeira perspectiva no abrir.
     */
    abort : function() {
        this.aborted = true;
    },
    /**
     * Retorna o status de abortado da aplicao
     * @returns {Boolean} true, se o status for de abortado, false se o status no for de abortado.
     */
    isAborted : function() {
        return this.aborted;
    },

    /**
     * Abre a url na window
     * 
     * @param url
     *            url a se aberta
     * @param name
     *            titulo da janela
     * @param id
     *            Identificador da janela aberta.
     */
    openWindow : function(url, name) {
        window.open(url, name);
    },

    closeWindow : function() {
        window.close();
    },

    /**
     * registra a window no Array de windows que mantm o "workspace" (perspectivas abertas em cada sesso de browser)
     */
    registerPerspective : function(perspectiveId) {
        this.registerUnloadListener(perspectiveId);
        this.registerBeforeUnloadListener(perspectiveId);
    },

    setBlockInfId : function(id) {
        this.blockInfId = id;
    },

    getBlockInfCmp : function() {
        return Ext.get(this.blockInfId);
    },

    /**
     * Abre um link em uma nova janela.
     * 
     * @param link
     *            json contendo as informaes do link a ser invocado
     */
    redirect : function(url) {
        window.location = url;
    },

    /**
     * Abre um link em uma nova janela.
     * 
     * @param link
     *            json contendo as informaes do link a ser invocado
     * @param windowName
     *            nome da nova janela
     */
    openLink : function(url, link, windowName) {
        window.open("./resources/redirect.html?resourceUrl=" + url + "&id=" + link, windowName);
    },

    /**
     * Altera o ttulo da janela do browser.
     * 
     * @param title
     *            Novo ttulo.
     */
    changeWindowTitle : function(title) {
        document.title = title;
    },

    /**
     * Adiciona um listener para o "unload" desta janela, referenciando determinada perspectiva.
     */
    registerUnloadListener : function(perspectiveId) {

        var unloadEvent = function() {
            Senior.destroyPerspective(perspectiveId);
        };

        window.onunload = unloadEvent;
    },

    /**
     * Destroi a perspectiva 
     * @param perspectiveId id da perspectiva
     */
    destroyPerspective : function(perspectiveId) {
        var xmlHttp = new XMLHttpRequest();
        xmlHttp.open('POST', "destroy?perspective=" + perspectiveId);
        xmlHttp.send();
    },

    /**
     * Funo de checagem de alterao nos dados
     */
    verifyPendingData : function(perspectiveId, onload) {
        var url = Senior.getUrl() + 'beforeDestroy?perspective=' + perspectiveId;

        if (!ConnectionManager.getConnection(ConnectionManager.UPLOAD_URL).isConnectionIdle()) {
            return "O carregamento de arquivo(s) est em progresso. Deseja fechar a perspectiva e cancelar esse(s) carregamento(s)?";
        }

        var xmlHttp = new XMLHttpRequest();
        xmlHttp.open('GET', url);
        xmlHttp.send();
        var result = xmlHttp.responseText;

        if (result === 'true') {
            if (onload) {
                return 'Existem alteraes de dados pendentes. Ao fechar a perspectiva as alteraes nos dados sero perdidas.';
            } else {
                return 'Existem alteraes de dados pendentes. Ao sair da pgina as alteraes nos dados sero perdidas. \n\n Tem certeza que deseja sair desta pgina?';
            }
        }
    },

    /**
     * Adiciona um listener no evento "onBeforeUnload" para confirmao de fechar o browser.
     */
    registerBeforeUnloadListener : function(perspectiveId) {
        var beforeUnloadEvent = function(e) {
            return Senior.verifyPendingData(perspectiveId, true);
        };
        if (this.isRunningTest()) {
            SPerspective.beforeUnloadURL = Senior.destroyUrl(perspectiveId);
        } else {
            window.onbeforeunload = beforeUnloadEvent;
        }
    },

    /**
     * Cria a perspectiva destroy a sesso
     * 
     * @param perspectiveId id da perspectiva
     */
    destroyUrl : function(perspectiveId) {
        return Senior.getUrl() + 'beforeDestroy?perspective=' + perspectiveId;
    },

    /**
     *Verifica se o modo que esta rodando  teste.
     * @returns <code>true</code> se esta rodando em teste.
     */
    isRunningTest : function() {
        return !!window.Selenium;
    },

    /**
     * Retorna a URL utilizada no browser
     */
    getUrl : function() {
        return window.location.protocol + '//' + window.location.host + window.location.pathname;
    },

    /**
    * @return true caso o browser utilizado  um IE suportado pelo framework.
    */
    isSupportedIE : function() {
        return Ext.isIE9 || Ext.isIE10 || Ext.isIE11;
    },

    /**
     * @return true caso o browser IE9 ou uma verso superior
     */
    isIE9OrLater : function() {
        return Ext.isIE9 || Ext.isIE10 || Ext.ieIE11;
    },

    /**
     * Verifica se o browser possui a informao nativa no mostra o hint
     * 
     * @returns {Boolean}
     */
    hasNativeCapsLockInformation : function() {
        return Ext.isIE10 || Ext.isIE10p;
    },

    /**
     * O recurso de caps lock nativo esta ativado
     *
     * @returns {Boolean}
     */
    isNativeCapslockInformationEnabled : function() {
        if (Ext.isIE10 || Ext.isIE10p) {
            return !document.msCapsLockWarningOff;
        }

        return false;
    },

    /**
     * Envia requisio de logoff
     * 
     * @param perspectiveId id da perspectiva
     */
    logOff : function(perspectiveId) {
        var message = Senior.verifyPendingData(perspectiveId, false);
        if (message) {

            var callback = function(button) {
                if (button === "yes") {
                    Senior.logoffAndReload();
                }
            };

            Ext.MessageBox.show({
                title : 'Confirmao',
                msg : message,
                buttons : {
                    no : "Permanecer nesta pgina",
                    yes : "Sair desta pgina"
                },
                fn : callback,
                scope : this,
                icon : Ext.MessageBox.QUESTION,
                minWidth : this.minWidth
            })

        } else {
            Senior.logoffAndReload();
        }

    },

    /**
     * Destroy a sesso e recarrega a tela, assim mostra a tela de login
     */
    logoffAndReload : function() {
        var xmlHttp = new XMLHttpRequest();
        xmlHttp.open('POST', "logOff", false);
        xmlHttp.send();

        window.location.reload();
    }

});

/**
 * Adiciona o CSS para saber se esta executando no Mas e no Safari, porque no  possivel criar um css com [ext-mac e ext-safari] .x-senior... 
 */
(function() {
    var initSeniorExtCss = function() {

        var bd = document.body || document.getElementsByTagName('body')[0];
        if (!bd) {
            return false;
        }

        if (Ext.isMac && Ext.isSafari) {
            var cls = [];
            cls.push("ext-safari-mac");
            Ext.fly(bd, '_internal').addClass(cls);
        }

        return true;
    };

    if (!initSeniorExtCss()) {
        Ext.onReady(initSeniorExtCss);
    }
})();

/**
 * No IE8 no  permitido atribuir o keyCode de um evento, ele lana um 'Acess Denied'.
 */
Ext.lib.Event.preventDefault = function(ev) {
    ev = ev.browserEvent || ev;
    if (ev.preventDefault) {
        ev.preventDefault();
    } else {
        if (ev.keyCode && !Ext.isIE8) {
            ev.keyCode = 0;
        }
        ev.returnValue = false;
    }
};