/**
 * As funcionalidades referentes ao correspondente dos ActionCommands no
 * servidor, devem ser implementadas aqui
 */
MainConnector = {
    /**
     * Faz a conexo para a serverUrl informada, passando adiante os
     * parmetros.
     * 
     * @param serverUrl
     *            {String} recurso.
     * @param postData
     *            {Mapa} mapa <chave,valor> contendo os parmetros POST a
     *            serem passados adiante.
     */
    connect : function(serverUrl, postData) {
        ProcessManager.startProcess(true);

        this.connection = new DefaultConnection(serverUrl, null);
        this.connection.observe(this);
        //adiciona no request a resoluo da tela e o userAgent
        postData.screenWidth = window.screen.width;
        postData.screenHeight = window.screen.height;
        //        postData.userAgent = window.navigator.userAgent;
        postData.userAgent = "browser"; // Por enquanto vamos enviar apenas browser, pois para o formcenter no interessa qual browser 
        this.connection.sendHttpRequest(postData);

    },

    afterRequest : function() {
        ProcessManager.finishProcess();
        this.connection = null;
    }
};

/**
 * Utilitrio para tratamento com componentes em geral
 */
RenderComponent = {
    /**
     * Pede novamente uma resposta para o contexto do server 0.5 segundos
     * mais tarde
     */
    askLater : function(perspectiveId) {
        var reqobj = {
            target : "RenderComponent",
            id : "null",
            type : "renderAction"
        };
        ConnectionManager.registerContext(perspectiveId, null);
        ConnectionManager.getConnection().enqueueProtocolRequest(reqobj);
    },

    registerContext : function(perspectiveId, componentId) {
        ConnectionManager.registerContext(perspectiveId, componentId);
    },

    registerHandler : function(fragmentId, componentId) {
        ConnectionManager.registerConnectionFrom(fragmentId, componentId);
        // o selenium no  importado sempre... mas mesmo assim isto deveria
        // ser removido daqui
        if (Senior.isRunningTest()) {
            Selenium.put(fragmentId, componentId);
        }
        /*
         * necessrio para descobrir, a partir de uma window, qual sua
         * perspectiva
         */
        window.perspectiveId = ConnectionManager.getContext();
    }
};

/**
 * Responsvel por gerenciar o processo de download
 */
DownloadComponent = {
    /* URL defaul */
    url : Senior.getUrl() + "?download=",
    /**
     * Chama a ao de download real com um pequeno atraso (defer) para
     * permitir o browser se redesenhar e tirar o aviso de 'aguarde'.
     * 
     * @public
     */
    doDownload : function(context, path) {
        this.internalDoDownload.defer(1, this, [ context, path ]);
    },

    /**
     * Cria um frame se no existir nenhum disponvel e utiliza Se no
     * utiliza do pool de frames (downloadFrames).
     * 
     * @private
     */
    internalDoDownload : function(context, path) {
        /*
         * Todo o cdigo abaixo  w3c standard
         */
        var src = this.url + encodeURIComponent(path);
        /* cria um iframe */
        var ifrm = document.createElement("iframe");
        /* identificador para download */
        ifrm.id = context;
        /* cria invisivel */
        ifrm.style.display = "none";
        ifrm.style.width = "1px";
        ifrm.style.heigh = "1px";
        /* coloca no corpo do documento */
        Ext.getBody().appendChild(ifrm);

        /*
         * pega o document do iframe contentDocument apesar de ser w3c o IE
         * no suporta, ento troquei para contentWindow.document, que  w3c
         * e todos suportam
         */
        var doc = ifrm.contentWindow.document;

        /* abre stream para escrita */
        doc.open();
        /* limpa */
        doc.write("");
        doc.close();
        /* escreve formulario de download */
        doc.write("<html><body>");
        doc.write("<form name='download'; id='download' method='post' action='" + src + "'>");
        doc.write("<\/body><\/html>");
        /* finaliza a stream, nesse momento o contedo ser processado */
        doc.close();
        /* pega o formulario do documento, sendo que s tem um */
        var form = doc.forms[0];
        /* e faz a requisio de download */
        form.submit();

        /*
         *  necessario fazer o defer porque se nno ele deleta o arquivo
         * antes de inicar o download, e ele precisa do arquivo para iniciar
         * o download
         */
        Ext.removeNode.defer(100, ifrm, [ ifrm ]);
    }
};

/**
 * Responsvel por gerenciar o processo de upload.
 */
UploadAction = {

    doUpload : function(cmpId) {
        var fileComponent = Ext.getCmp(cmpId);
        fileComponent.doUpload();
    }
};

/**
 * @static
 */
ModalComponent = {

    /**
     * @public
     */
    closeModal : function() {
        FocusManager.popContext();
        // garante que ultima execuo ser o foco no componente
        (function() {
            FocusManager.focusCurrentComponent();
        }).defer(1, this);
    }
};

/**
 * Responsvel pelas aes referentes ao controle de foco.
 * 
 * @static
 */
FocusManagerAction = {
    /**
     * @public
     */
    setComponentFocus : function(cmpId) {
        var cmp = Ext.getCmp(cmpId);
        if (cmp) {
            //o comboBox tem uma peculiaridade de "mimetizar" evento blur capturando eventos de mousedown. 
            //Como o focus manual no gera mousedown, precisamos forar o blur no comboBox
            //maiores detalhes tarefa 380792 
            var focusedCmp = FocusManager.getFocusedComponent();
            if (focusedCmp && (focusedCmp instanceof Ext.form.ComboBox)) {
                // preciso invocar o triggerBlur antes do blur.
                focusedCmp.triggerBlur();
                focusedCmp.blur();
            }

            FocusManager.focusComponent(cmp);
        }
    },

    /**
     * @public
     */
    focusFirst : function() {
        FocusManager.focusFirstComponent();
    },

    /**
     * Deve ser usado apenas nas aes internas de afterRender: o cliente pode ter setado foco em outro componente. 
     * Neste caso, este focusFirst nao ter efeito algum para no sobrescrever ao anterior.
     * 
     * @private
     */
    focusFirstAfterRender : function() {
        var focusedComponent = FocusManager.getFocusedComponent();
        // Se no tiver um focado ou se estiver focado um container (painel, window), tenta focar um componente de edio
        if (!focusedComponent || focusedComponent instanceof Ext.Container) {
            FocusManagerAction.focusFirst();
        }
    },

    /**
     * @public
     */
    changeVision : function() {
        /* libera recursos da viso anterior. */
        FocusManager.popContext();
        /* cria um contexto para a viso atual. */
        FocusManager.pushContext();
    },

    /**
     * @public
     */
    rearrangeTabOrder : function() {
        FocusManager.rearrangeTabOrder();
    }

};
