URLInvoker = {

    invoke : function(urlFile) {

        var setAjax = {
            success : function(result, operation) {
                var link = result.responseText;
                link = Ext.util.JSON.decode(link);

                // create form
                var submitForm = document.createElement("FORM");
                submitForm.method = link.method;
                submitForm.action = link.url;
                document.body.appendChild(submitForm);

                // create childs
                if (link.params) {
                    for ( var i = 0; i < link.params.length; i++) {
                        var key = link.params[i].key;
                        var value = link.params[i].value;
                        var newElement = document.createElement("input");
                        newElement.setAttribute("type", "hidden");   
                        // seta os valores aps a criao para no quebrar no apstrofo.
                        newElement.name = key;
                        newElement.value = value;
                        submitForm.appendChild(newElement);
                    }
                }
                // submit form
                submitForm.submit();
            },
            failure : function() {
                Ext.MessageBox.alert('Erro', 'Erro ao se conectar com o servidor.');
            }
        };

        Ext.Ajax.request( {
            url : urlFile,
            method : 'POST',
            headers : {
                'Content-type' : 'application/x-www-form-urlencoded'
            },
            success : setAjax.success,
            failure : setAjax.failure
        });

    }

};

/**
 * Realiza o trabalho de redirecionar para uma nova URL. Mtodo invocado pelo redirect.html.
 */
function doWork() {
    var urlVars = getUrlVars();
    var id = urlVars["id"];
    var resourceUrl = urlVars["resourceUrl"];
    // chama o URLInvoker para pegar o resource
    URLInvoker.invoke("../" + resourceUrl + "/" + id);
}

/**
 * Retorna os parmetros da URL na forma de um array.
 */
function getUrlVars() {
    var vars = [], hash;
    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');

    for ( var i = 0; i < hashes.length; i++) {
        hash = hashes[i].split('=');
        vars.push(hash[0]);
        vars[hash[0]] = hash[1];
    }

    return vars;
}
