ScreenManager = {

    /** elemento de processando - instncia nica */
    processingEl : null,

    /** elemento de "inatividade" */
    inactivityEl : null,

    /** pilha de mscaras que esto bloqueando a interface */
    masks : new Array(),

    /**
	 * Bloqueia a interface do usurio com uma mscara ao fundo e uma
	 * informao, assim impossibilitando de utilizar qualquer componente na
	 * tela.
	 * 
	 * @param text
	 *            texto opcional que ser mostrado ao bloquear a tela. Caso no
	 *            venha texto, a tela é apenas bloqueada com uma mscara.
	 * @param buttonLock
	 *            true caso essa a ao tenha vindo de um boto com a opo
	 *            'blockInterface'.
	 */
    blockScreen : function(text, buttonLock) {

    	this.checkBlockedByInactivity();

    	// ao bloquar, esconde o indicador de processando.
        this.hideProcessIndicator();

        var elementToMask = this.getActiveWindow();

        // Ext s suporta uma mscada por elemento, ele ignora a primeira caso
		// adicionar uma nova.
        if (elementToMask.isMasked()) {

            // Se j estiver mascarado, ignora, a no ser que for um buttonLock.
            // buttonLock sobreescreve pois o servidor manipula o momento que
			// ele deve ser removido.
            if (!buttonLock)
                return;
        }

        var mask = new Ext.LoadMask(elementToMask, {
            msg : text ? text : null,
            msgCls : text ? "x-senior-block-loading" : null
        });
        this.masks.push(mask);
        mask.show();

        // salva na mscara se ela veio de um lock de boto
        mask.buttonLocked = !!buttonLock;

        // alinhando o texto verticalmente
        var blockEl = elementToMask.child(".x-senior-block-loading div");
        if (blockEl)
            blockEl.setStyle("lineHeight", blockEl.getHeight() + "px");

    },

    /**
	 * Remove a mscara que est na interface.
	 * 
	 * @param unlockAction
	 *            true se é uma ao que deve remover a mscara que foi
	 *            adicionada por um boto, tem prioridade na remoo.
	 */
    unblockScreen : function(unlockAction) {

        var mask = this.masks[this.masks.length - 1];

        // s remove se for uma action da mscara do boto ou se a mscara no
		// foi adicionada por um boto.
        if (unlockAction || (mask && mask.buttonLocked === false)) {
            var mask = this.masks.pop();
            if (mask != null) {
                mask.disable();
                mask.hide();
            }
        }

    },

    /**
	 * Exibe um indicador visual demonstrando que a interface est processando
	 * alguma requisio.
	 */
    showProcessIndicator : function() {
    	
    	this.checkBlockedByInactivity();
    	
        // quando h mscara, no mostra o indicador de processando
        if (this.getActiveWindow().isMasked())
            return;

        if (this.processingEl == null) {
            this.processingEl = new Ext.Element(document.createElement('div'));
            Ext.getBody().appendChild(this.processingEl);
            this.processingEl.addClass('x-senior-box-loading');
            this.processingEl.setStyle('position', 'absolute');
            this.processingEl.setStyle('top', '1px');
            this.processingEl.mask('Processando...', '');

            // alinha o texto verticalmente
            this.processingEl.child("div.ext-el-mask-msg div").setStyle("lineHeight", this.processingEl.getHeight() + "px");
        }

        // tamanho da tela dividindo por 2 para centralizar, desconta a metade
		// do tamanho do elemento.
        var left = (Ext.getBody().getViewSize().width / 2) - (this.processingEl.getWidth() / 2);
        this.processingEl.setStyle('left', left + "px");

        this.processingEl.show();
    },

    /**
	 * Remove o indicador visual de processando.
	 */
    hideProcessIndicator : function() {
        if (this.processingEl != null) {
            this.processingEl.hide();
        }
    },

    // retorna a window (modal) ativa. Caso no existir, retorna o body.
    getActiveWindow : function() {
        return Ext.ux.senior.WindowMgr.getActive() ? Ext.ux.senior.WindowMgr.getActive().el : Ext.getBody();
    },

    isInterfaceBlocked : function() {
        var ret = this.masks.length > 0 && (!Ext.ux.senior.WindowMgr.getActive() || Ext.ux.senior.WindowMgr.getActive().el.isMasked());
        for ( var i = 0; i < this.masks.length; i++) {
            ret = ret && !this.masks[i].disabled;
        }
        return ret;
    },
    
    /**
	 * Bloqueia a interface do usurio com uma mscara ao fundo e uma
	 * informao, assim impossibilitando de utilizar e ver qualuer informao
	 * da tela.
	 */
    hideDataOnInactivityDetected : function() {
    	
    	// Se j est mascarado, ignora pois vai ser chamado de novo quando vier
		// a resposta do comando atualmente em execuo
    	
    	if (this.masks.length > 0) {
    		return;
    	}

        var elementToMask = this.getActiveWindow();


        var mask = new Ext.LoadMask(elementToMask, {
            msg : "Proteo de dados por inatividade do usurio ativada.\nClick para continuar...",
            msgCls : "x-senior-block-data"
        });
        this.masks.push(mask);
        mask.show();
        // salva na mscara se ela veio de um lock de boto
        mask.buttonLocked = false;

        var blockEl = elementToMask.child(".x-senior-block-data div");
   		blockEl.addListener("click", this.onClickBlockDataMask, this); 

        // Encontrar o elemento que faz a mscara atual da tela
        var elements = elementToMask.query(".ext-el-mask");
        var arrayLength = elements.length;
        for (var i = 0; i < arrayLength; i++) {
        	var lid = elements[i].id;
        	blockEl = Ext.Element.get(lid);
        	if (blockEl.isVisible()){
        		blockEl.setStyle("opacity", "1");
        		blockEl.addListener("click", this.onClickBlockDataMask, this); 
        	}
        }
    },
    
    /**
	 * Bloqueia a interface do usurio com uma mscara ao fundo e uma
	 * informao, assim impossibilitando de utilizar e ver qualuer informao
	 * da tela.
	 */
    checkBlockedByInactivity : function() {
    	
        var mask = this.masks[this.masks.length - 1];
        
        // se no tem mscara
        if (mask == null){
        	return;
        }
        
        // se a mscara no  de blockData
        if (mask.msgCls != "x-senior-block-data") {
        	return;
        }
        
    	// Se j est mascarado, ignora pois vai ser chamado de novo quando vier
		// a resposta do comando atualmente em execuo
    	
    	if (this.masks.length > 0) {
    		return;
    	}

    	this.unblockScreen(true);
    },

    /**
	 * Libera a interface do usurio com click na mscara que bloqueia os dados.
	 */
    // @private
    onClickBlockDataMask : function(e, t, o) {
    	
        // Encontrar o elemento que faz a mscara atual da tela
        var elementToMask = this.getActiveWindow();
        var elements = elementToMask.query(".x-senior-block-data div");
        var arrayLength = elements.length;
        for (var i = 0; i < arrayLength; i++) {
        	var html = elements[i];
        	blockEl = Ext.Element.get(html.id);
        	if (blockEl.isVisible()){
        		html.innerText = "Proteo de dados por inatividade do usurio ativada.\nAguarde...";
        	}
        }
    	//this.unblockScreen(true);
        var reqobj = {
                target : "NULL_MESSAGE_HANDLER",
                type : "NULL_MESSAGE_HANDLER",
                id : "NULL_MESSAGE_HANDLER"
            };
        ConnectionManager.getConnection().enqueueProtocolRequest(reqobj);
    }
    
    
};
