ProcessManager = {

    processingTimeout : 600,
    blockProcessingTimeout : 4000,
    dataBlockTimeout : 0,

    processingTimeoutId : null,
    blockProcessingTimeoutId : null,

    instantLocked : false,

    blockCount : 0,
    
    lastTime : 0,
    
    startProcess : function(instantLock) {
        

        if (instantLock) {
            this.hideProcessingIndicator();
            if (this.blockProcessingTimeoutId && this.blockCount > 0 && !this.instantLocked) {
                this.blockCount--;
            }
            this.hideBlockProcessingIndicator();
        }

        if (this.processingTimeoutId == null && this.blockProcessingTimeoutId == null) {

            if (!instantLock)
                this.processingTimeoutId = setTimeout(function() {
                    ScreenManager.showProcessIndicator();
                }, this.processingTimeout);
            else
                this.instantLocked = true;

            this.blockProcessingTimeoutId = setTimeout(function() {
                ProcessManager.blockCount++;
                ScreenManager.blockScreen("Processando...");
            }, instantLock ? 0 : this.blockProcessingTimeout);

        }
    },

    finishProcess : function(instant) {
        this.blockCount--;
        
        /*
         * Esse controle para desbloquear a tela somente quando a última chamada de desbloqueio for feita 
         * existe apenas porque o upload ocorre em uma fila separada dos outros requests 
         */
        
        if (this.blockCount <= 0) {
            this.blockCount = 0;

            if (this.instantLocked === true) {

                if (instant) {
                    this.hideProcessingIndicator();
                    this.hideBlockProcessingIndicator();

                    this.instantLocked = false;
                }

            } else {
                this.hideProcessingIndicator();
                this.hideBlockProcessingIndicator();
            }
            
        }
        if (this.dataBlockTimeout > 0){
        	var d = new Date();
        	this.lastTime = d.getTime();
        	this.nextTimer();
        }
    },

    hideProcessingIndicator : function() {
        if (this.processingTimeoutId != null) {
            clearTimeout(this.processingTimeoutId);
            this.processingTimeoutId = null;

            ScreenManager.hideProcessIndicator();
        }
    },

    hideBlockProcessingIndicator : function() {
        if (this.blockProcessingTimeoutId != null) {
            clearTimeout(this.blockProcessingTimeoutId);
            this.blockProcessingTimeoutId = null;

            ScreenManager.unblockScreen();
        }
    },

    setProcessingTimeout : function(timeout) {
        if (!isNaN(timeout)) {
            this.processingTimeout = timeout;
        }
    },

    setBlockProcessingTimeout : function(timeout) {
        if (!isNaN(timeout)) {
            this.blockProcessingTimeout = timeout;
        }
    },
    
    setDataBlockTimeout : function(timeout) {
        if (!isNaN(timeout)) {
            this.dataBlockTimeout = timeout;
        }
    },
    
    onTimer : function() {
        if (this.blockCount <= 0) {
            var d = new Date();
            var currTime = d.getTime();

        	if (currTime - this.lastTime > (this.dataBlockTimeout)) {
        		ScreenManager.hideDataOnInactivityDetected();
        	} else {
        		this.nextTimer();
        	}
        }
    },
    
    nextTimer : function() {
        var fun = function(){ProcessManager.onTimer();};
        setTimeout(fun, 1000);
  }

};