/**
 * Monta parmetros padres para todos os requests
 * @author Jean.Kirchner
 */
EventDataBuilder = {
    buildData : function(component) {
        var params = {};
        this.getModifiers(Ext.EventObject, params);
        this.getKeyModify(Ext.EventObject, params);

        return params;
    },

    /**
     * Converte para o mesmo padro de teclas pressionadas que o sistema utiliza Posicao Tecla 0 Nenhum tecla pressionada 1 ctrl 2 alt 3 shift
     * @private 
     */
    getModifiers : function(ev, props) {
        /* !! (nega duas vezes) garante que vai ser true ou false, nunca undefined/null ou outras coisa */
        props.shiftKey = !!ev.shiftKey;
        props.altKey = !!ev.altKey;
        props.ctrlKey = !!ev.ctrlKey;
    },

    /** 
     * Adiciona os parametros de teclas digitadas no request
     * @private
     */
    getKeyModify : function(ev, property) {
        if (ev != null && ev.type == "keydown") {
            var k = ev.getKey();
            /* no ie, nem sempre pode ter uma tecla */
            if (k) {
                property.key = k;
            }
        }
    }
};