Ext.namespace('Ext.ux.senior.tree');

/**
 * @class Ext.tree.DefaultSelectionModel
 * @extends Ext.util.Observable
 * The default single selection for a TreePanel.
 */
Ext.ux.senior.tree.DefaultSelectionModel = function(config) {
    Ext.apply(this, config);
    Ext.ux.senior.tree.DefaultSelectionModel.superclass.constructor.call(this);
};

Ext.extend(Ext.ux.senior.tree.DefaultSelectionModel, Ext.tree.DefaultSelectionModel, {

   onKeyDown : function(e) {
        var s = this.selNode || this.lastSelNode;
        if (!s) {
            return;
        }
        var k = e.getKey();
        switch (k) {
        case e.PAGE_DOWN:
            e.stopEvent();
            this.tree.pageDown();
            break;
        case e.PAGE_UP:
            e.stopEvent();
            this.tree.pageUp();
            break;
        case e.HOME:
            e.stopEvent();
            this.tree.home();
            break;
        case e.END:
            e.stopEvent();
            this.tree.end();
            break;
        default:
            Ext.ux.senior.tree.DefaultSelectionModel.superclass.onKeyDown.call(this, e);
            break;
        }
    }
});
