Ext.namespace('Ext.ux.senior.tree');

Ext.ux.senior.tree.TreePanel = Ext.extend(Ext.tree.TreePanel, {

    border : false,
    animate : false,
    rootVisible : false,
    showFilter : false,
    autoScroll : true,
    useArrows : true,

    rootNodes : null,
    editor : null,
    selModel : null,
    message : null,
    emptyTextFilter : "",
    emptyText : "",
    filterExpression : null,

    // Tempo de espera para a pesquisa na Tree.
    timeWaitFilter : 750,

    // Tamanho fixo de cada nodo da Tree.
    nodeHeight : 20,

    eventMapping : function() {
        return {
            nodeExpand : this.onNodeExpand,
            nodeCollapse : this.onNodeCollapse,
            nodeactivated : this.onActivatedNode,
            selectionchange : this.onSelectionChange,
            filter : this.onFilter,
            checkchange : this.onCheckChange
        };
    },

    focus : function() {
        //Se no tiver nodo selecionado seleciona o primeiro
        if (!this.selModel.getSelectedNode()) {
            this.selModel.select(this.root.item(0));
        } else {
            //Se j possuir o foco no  necessrio pedir denovo
            if (document.activeElement !== this.selModel.getSelectedNode().ui.anchor) {
                this.selModel.getSelectedNode().ui.focus();
            }
        }
    },

    onNodeExpand : function(rootNode, arguments) {
        //chama o foco para o nodo que est sendo expandido
        this.selModel.select(rootNode);
        return {
            nodeId : rootNode.id,
            action : "EXPAND",
            type : "treeEvent"
        };
    },

    onNodeCollapse : function(rootNode, arguments) {
        //chama o foco para o nodo que est sendo colapsado
        this.selModel.select(rootNode);
        return {
            nodeId : rootNode.id,
            action : "COLLAPSE",
            type : "treeEvent"
        };
    },

    onCheckChange : function(rootNode, checked) {
        var event;
        if (checked === true) {
            event = 'CHECK_NODE';
        } else {
            event = 'UNCHECK_NODE';
        }

        return {
            nodeId : rootNode.id,
            action : event,
            type : "treeEvent"
        };
    },

    initComponent : function() {
        this.loader = new Ext.ux.senior.tree.TreeLoader();

        this.root = new Ext.tree.TreeNode( {
            id : 'root',
            text : 'root',
            expanded : true
        });

        this.selModel = new Ext.ux.senior.tree.DefaultSelectionModel();
        this.loader.addNodes(this.root, this.rootNodes);

        if (this.showFilter) {
            //Cria o editbox de filtro.
            if (!this.editor.isXType) {
                this.editor = Ext.create(this.editor);
            }
            this.editor.enableKeyEvents = true;

            //Cria a toolbar com o editbox de filtro
            this.tbar = new Ext.Toolbar( {
                layout : 'fit',
                height : 26,
                hidden : !this.showFilter,
                cls : "x-tree-filter-panel",
                items : [ this.editor ]
            });
        }

        Ext.ux.senior.tree.TreePanel.superclass.initComponent.call(this);

        this.addLabelMessage();

        this.verifyTreeEmpty();

        this.on('containerclick', this.onTreeMouseDown);

        delete this['rootNodes'];
    },

    onTreeMouseDown : function(e) {
        // Se existir algum nodo focado ento seleciona novamente, pois o foco foi para o body.
        if (this.selModel.getSelectedNode()) {
            this.selModel.getSelectedNode().select();
            // Caso no exista nodo selecionado e existir um filho, seleciona o primeiro nodo da tree.
        } else if (this.root.firstChild) {
            this.root.firstChild.select();
        }
    },

    treeKeyPressed : function(e) {
        //Apenas  necessrio ativar em caso de espao, o ENTER  considerado um click
        if (e.getKey() == e.SPACE) {
            e.stopEvent();
            this.fireEvent('nodeactivated');
        }
    },

    onActivatedNode : function(node) {
        if (!node) {
            node = this.selModel.getSelectedNode();
        }

        var properties = {
            nodeId : node.id,
            action : "ACTIVATE_NODE",
            type : "treeEvent"
        };
        return properties;
    },

    onSelectionChange : function(model, node) {
        // Faz essa verificao pois quando  feito um clearSelections(), acaba acionando
        // um evento de "selectionchange" e acaba enviando como parametro um node que no existe mais.
        // Quando for habilitado multipla seleo na Tree, deve ser retirada essa verificao.
        // node.ownerTree validao porque quando  apertado 'enter', na pesquisa envia um evento de enter para tree tambem
        if (node != null && node.ownerTree != null) {
            // avisa o FocusManager que a tree est com o foco.
            FocusManager.onComponentFocus(node.ownerTree);

            var properties = {
                nodeId : node.id,
                action : "FOCUS_NODE",
                type : "treeEvent"
            };
            return properties;

        }
    },

    /**
     * Verifica se a tree est vazia, se estiver seta a mensagem "No h itens para serem exibidos"
     */
    verifyTreeEmpty : function() {
        this.showNotFoundMessage(!this.root.hasChildNodes());
    },

    /**
     * Seta o painel de pesquisa para visivel ou no
     */
    setShowFilter : function(show) {
        this.showFilter = show;
        this.tbar.setVisible(show);
    },

    /**
     * Cria um Label para adicionar mensagem de campo no informado
     */
    addLabelMessage : function() {
        this.message = new Ext.form.Label( {
            hidden : true,
            cls : 'x-senior-label x-tree-message'
        });
        this.add(this.message);
    },

    /**
     * Mostra ou esconde a mensagem de nodos no encontrados
     */
    showNotFoundMessage : function(show) {
        this.message.setVisible(show);
        this.message.setText(this.emptyText);
    },

    onFilter : function(forceFilter, filter) {
        forceFilter = forceFilter === true ? true : false;
        return {
            id : this.getId(),
            type : 'treeEvent',
            value : filter,
            action : 'FILTER',
            forceFilter : forceFilter
        };
    },

    /**
     * Adiciona nodos baseado no pai
     */
    addNodes : function(parentNodeID, nodesAttrs) {
        var parentNode = this.getNodeById(parentNodeID);
        this.loader.addNodes(parentNode, nodesAttrs);

        this.verifyTreeEmpty();

    },

    /**
     * Expande o node informado
     */
    expandNode : function(parentNodeID) {
        var node = this.getNodeById(parentNodeID);
        if (node) {
            node.expand();
        }
    },

    /**
     * Fecha o node informado
     */
    collapseNode : function(parentNodeID) {
        var node = this.getNodeById(parentNodeID);
        if (node) {
            node.collapse();
        }
    },

    /**
    * Remove todos os filhos
    */
    clearAllChildren : function() {
        while (this.root.firstChild) {
            this.root.removeChild(this.root.firstChild);
        }
        //Necessrio limpar o SelectionModel para caso existisse algum nodo selecionado
        this.selModel.clearSelections(true);
    },

    /**
     * cria um timer para esperar um tempo antes de disparar a consulta na tree Aguarda X milisegundo aps a ltima tecla precionada
     */
    timeWait : function(conteudo, treeEditId) {
        this.clearTimeWait();
        var treeId = this.getId();
        if (!this.timeoutReturn) {
            this.timeoutReturn = setTimeout(function() {
                verifyChangeTreeFilter(conteudo, treeEditId, treeId);
            }, this.timeWaitFilter);
        }
    },

    /**
     * Limpa o timer que foi criado para fazer um refresh no filtro.  usado quando um enter  pressionado e tambm quando uma 
     * chamada a timeWait  feita para reiniciar o timer.
     */
    clearTimeWait : function() {
        if (this.timeoutReturn) {
            clearTimeout(this.timeoutReturn);
            this.timeoutReturn = null;
        }
    },

    /**
     * Executa uma consulta na tree;
     */
    setFilterExpression : function(conteudo) {
        this.filterExpression = conteudo;
        if (this.editor && this.editor.getValue() != conteudo) {
            this.editor.setValue(conteudo);
            this.filter(false);
        }
    },

    /**
     * retorna a expresso de cosulta
     */
    getFilterExpression : function() {
        return this.filterExpression;
    },

    /**
     * seta o texto vazio para a tree
     */
    setEmptyText : function(emptyText) {
        this.emptyText = emptyText;
    },

    afterRender : function() {
        Ext.ux.senior.tree.TreePanel.superclass.afterRender.call(this);

        this.on('click', this.nodeClick, this);

        this.getSelectionModel().on('selectionchange', function(model, node) {
            this.fireEvent('selectionchange', model, node);
        }, this);

        this.mon(this.getTreeEl(), 'keydown', this.treeKeyPressed, this);

        if (this.showFilter) {
            this.editor.on("keyup", this.editKeyUpEvent, this);
        }

        // Se a tree tiver "nodos" ento deve focar no primeiro "nodo".
        if (this.root.firstChild) {
            this.nodeClick(this.root.firstChild);
            this.root.firstChild.select();
        }
    },

    nodeClick : function(node) {
        // Avisa o FocusManager que a Tree est com o foco.
        FocusManager.onComponentFocus(node.ownerTree);
        this.fireEvent('nodeactivated', node);
    },

    /**
     * Eventos do Editbox de filtragem
     */

    editKeyUpEvent : function(textField, event) {
        if (event.getKey() == 13) {
            this.clearTimeWait();
            this.filter(true);
        } else {
            /* No disparar com as teclas direcionais e tab */
            if ((event.getKey() < 37 || event.getKey() > 40) && event.getKey() != 9) {
                this.timeWait(textField.getValue(), textField.id);
            }
        }
    },
    

    /**
     * Envia o evento para fazer a filtragem da tree
     */
    filter : function(forceFilter) {
        this.fireEvent('filter', forceFilter, this.editor.getValue());
    },

    /**
     * Retorna o  Element que possui o estilo desejado.
     */
    getStyleEl : function(scope) {
        var el = null;
        var styleScope = scope.split("$")[0];
        var property = scope.split("$")[1];

        if (styleScope == 'tree') {
            if (property == 'font-color') {
                el = this.getEl().child('.x-tree-node a span');
            } else if (property.indexOf('font') > -1) {
                el = this.getEl().child('div.x-tree-node-el');
            } else if (property == 'tree-node-icon-expanded' || property == 'tree-node-icon-collapsed') {
                el = this.getEl().child('img.x-tree-node-icon');
            } else {
                el = this.getEl().child('div.x-panel-body');
            }
        }

        return el;
    },

    home : function() {
        this.selModel.select(this.root.item(0));
    },

    end : function() {
        this.findLastChild(this.root.childNodes[this.root.childNodes.length - 1]);
    },

    /**
     * Retorna o tamanho da tree, retirando o tamanho do editbox de pesquisa caso necessrio
     */
    getTreeHeight : function() {
        var heightTree = this.getHeight();
        if (this.showFilter) {
            heightTree = heightTree - 39;
        }
        return heightTree;
    },

    /**
     * Retorna quantos nodos da tree conseguem ficar visveis ao mesmo tempo
     */
    getCountVisibleNodes : function() {
        var heightTree = this.getTreeHeight();
        var count = parseInt(heightTree / this.nodeHeight);

        //Se tiver scroll horizontal devemos retirar 1 nodo
        if (this.body.dom.scrollWidth > this.body.dom.clientWidth) {
            count--;
        }
        return count;
    },

    pageDown : function() {
        this.initialSearchPageDown(this.selModel.getSelectedNode(), this.getCountVisibleNodes());
    },

    pageUp : function() {
        this.searchParentPageUp(this.selModel.getSelectedNode(), this.getCountVisibleNodes());
    },

    searchParentPageUp : function(node, count) {
        var parent = node.parentNode;
        var actualPosition = -1;
        for ( var i = 0; i < parent.childNodes.length; i++) {
            if (parent.childNodes[i] === node) {
                actualPosition = i;
                break;
            }
        }

        for ( var i = actualPosition - 1; i != -1; i--) {
            count = this.searchChildrenPageUp(parent.childNodes[i], count);
            if (count == 0) {
                return count;
            }
        }

        count = count - 1;
        if (count == 0) {
            this.selModel.select(parent);
            return count;
        }

        //Se no for o root temos que continuar a busca 
        if (!parent.isRoot) {
            this.searchParentPageUp(parent, count);
        } else {
            this.selModel.select(this.root.item(0));
        }
    },

    searchChildrenPageUp : function(node, count) {

        if (node.isExpanded()) {
            for ( var i = node.childNodes.length - 1; i != -1; i--) {
                count = this.searchChildrenPageUp(node.childNodes[i], count);
                if (count == 0) {
                    return count;
                }
            }
        }

        count = count - 1;
        if (count == 0) {
            this.selModel.select(node);
        }

        return count;
    },

    initialSearchPageDown : function(node, count) {
        if (count == 0) {
            this.selModel.select(node);
            return;
        }

        if (node.isExpanded()) {
            //Verifica todos os filhos desse nodo para ver se s com eles j chegamos no limite
            for ( var i = 0; i < node.childNodes.length; i++) {
                count = this.searchChildrenPageDown(node.childNodes[i], count);
                if (count == 0) {
                    break;
                }
            }
        }

        //Se no chegamos ao limite  necessrio ver os irmos, mas para isso temos que ir no pai 
        if (count > 0) {
            this.searchParentPageDown(node, count);
        }
    },

    searchParentPageDown : function(node, count) {
        //Acha o pai
        var parent = node.parentNode;

        //Flag para ver se encontrei a posio do filho
        var findActual = false;

        for ( var i = 0; i < parent.childNodes.length; i++) {

            //J encontrei o filho onde me encontrava antes
            if (findActual == true) {
                count = count - 1;

                if (count == 0) {
                    this.selModel.select(parent.childNodes[i]);
                    return count;
                }

                if (parent.childNodes[i].isExpanded()) {
                    //Verifica filhos do filho
                    for ( var j = 0; j < parent.childNodes[i].childNodes.length; j++) {
                        count = this.searchChildrenPageDown(parent.childNodes[i].childNodes[j], count);
                        if (count == 0) {
                            return count;
                        }
                    }
                }
            }

            if (parent.childNodes[i] === node) {
                findActual = true;
            }
        }

        if (!parent.isRoot) {
            this.searchParentPageDown(parent, count);
        } else {
            this.findLastChild(this.root.childNodes[this.root.childNodes.length - 1]);
        }
    },

    searchChildrenPageDown : function(node, count) {
        count = count - 1;
        if (count == 0) {
            this.selModel.select(node);
            return count;
        }

        if (node.isExpanded()) {
            for ( var i = 0; i < node.childNodes.length; i++) {
                count = this.searchChildrenPageDown(node.childNodes[i], count);
                if (count == 0) {
                    return count;
                }
            }
        }

        return count;
    },

    findLastChild : function(node) {
        if (node.isExpanded()) {
            this.findLastChild(node.childNodes[node.childNodes.length - 1]);
        } else {
            this.selModel.select(node);
        }
    }
});

function verifyChangeTreeFilter(conteudo, treeEditId, treeId) {
    var edit = Ext.getCmp(treeEditId);
    var tree = Ext.getCmp(treeId);
    if (conteudo == edit.getValue()) {
        tree.filter();
    }
}

Ext.reg('seniortreepanel', Ext.ux.senior.tree.TreePanel);