Ext.namespace('Ext.ux.senior.tree');

Ext.ux.senior.tree.AsyncTreeNode = function(config) {
    Ext.ux.senior.tree.AsyncTreeNode.superclass.constructor.apply(this, arguments);
};

Ext.extend(Ext.ux.senior.tree.AsyncTreeNode, Ext.tree.TreeNode, {
    
    onExpand : function() {
        return {
            type : 'treeEvent',
            nodeId : this.id,
            action : 'EXPAND'
        };
    },

    onCollapse : function(deep, anim) {
        return {
            type : 'treeEvent',
            nodeId : this.id,
            action : 'COLLAPSE'
        };
    },

    expand : function(deep, anim, callback) {
        Ext.ux.senior.tree.AsyncTreeNode.superclass.expand.call(this, deep, anim, callback);
        this.getOwnerTree().fireEvent('nodeExpand', this, arguments);
    },

    collapse : function(deep, anim) {
        Ext.ux.senior.tree.AsyncTreeNode.superclass.collapse.call(this, deep, anim);
        this.getOwnerTree().fireEvent('nodeCollapse', this, arguments);
    },
    
    render : function(bulkRender) {
        Ext.ux.senior.tree.AsyncTreeNode.superclass.render.call(this, bulkRender);
        //remove a classe css que dava a impresso que o menu no podia ser selecionado
        Ext.get(this.ui.elNode).removeClass('x-unselectable');
    }

});

Ext.tree.TreePanel.nodeTypes.seniorasync = Ext.ux.senior.tree.AsyncTreeNode;
Ext.reg('seniorasynctreenode', Ext.ux.senior.tree.AsyncTreeNode);