Ext.namespace('Ext.ux.senior.timer');

/**
 * Gerenciador de instncias de <code>Timer</code>.
 */
Ext.ux.senior.timer.TimerManager = {
		timers : {},
		
		/**
		 * Cria e retorna um <code>Timer</code>. 
		 */
		create : function(id, interval) {
			return new Ext.ux.senior.timer.Timer(id, interval);
		},
		
		/**
		 * Registra o timer no <code>TimerManager</code>. Este mtodo  chamado automaticamente
		 * pelo <code>Timer</code> quando ele  criado.
		 * 
		 * @public
		 */
		register : function(timer) {
			var id = timer.getId();
			if (this.timers[id] !== undefined) {
				this.throwAlreadyExistentTimerException();
			}
			
			this.timers[id] = timer;
		},
		
		/**
		 * Remove o registro do timer no <code>TimerManager</code>. Este mtodo  chamado automaticamente
		 * pelo <code>Timer</code> quando ele  destrudo.
		 * 
		 * @public
		 */
		unregister : function(timer) {
			var id = timer.getId();
			if (this.timers[id] === undefined) {
				throwInexistentTimerException();
			}
			
			delete this.timers[id];
		},
		
		/**
		 * Obtm o timer associado ao <code>id</code>.
		 * 
		 * @public
		 */
		get : function(timerId) {
			var timer = this.timers[timerId];
			if (timer === undefined) {
				throwInexistentTimerException();
			}
			
			return timer;
		},
		
		
		/**
		 * @private
		 */
		throwAlreadyExistentTimerException : function(id) {
			throw String.format('A timer is already associated with the id "{0}"', id);
		},
		
		/**
		 * @private
		 */
		throwInexistentTimerException : function(id) {
			throw String.format('There is no timer associated with the id "{0}"', id);
		}
};